/*
 * Decompiled with CFR 0.152.
 */
package hSql;

import hSql.hChannel;
import hSql.hColumn;
import hSql.hDatabase;
import hSql.hError;
import hSql.hIndex;
import hSql.hNode;
import hSql.hRecord;
import hSql.hResult;
import java.sql.SQLException;
import java.util.Vector;

abstract class hTable {
    private String sName;
    private Vector vColumn;
    private Vector vIndex;
    private int iVisibleColumns;
    private int iColumnCount;
    private int iRowCount;
    private int iPrimaryKey;
    private int iRowId;
    protected hDatabase dDatabase;
    protected int iIndexCount;

    hTable(hDatabase hDatabase2, String string) {
        this.dDatabase = hDatabase2;
        this.sName = string;
        this.iPrimaryKey = -1;
        this.vColumn = new Vector();
        this.vIndex = new Vector();
    }

    void addColumn(String string, int n) throws SQLException {
        this.addColumn(string, n, true);
    }

    void addColumn(String string, int n, boolean bl) throws SQLException {
        hError.assert((this.iPrimaryKey == -1 ? 1 : 0) != 0, (String)"hTable.addColumn");
        this.vColumn.addElement(new hColumn(string, bl, n));
        ++this.iColumnCount;
    }

    void addColumns(hResult hResult2) throws SQLException {
        int n = 0;
        while (n < hResult2.getColumnCount()) {
            this.addColumn(hResult2.sLabel[n], hResult2.iType[n], true);
            ++n;
        }
    }

    abstract void copyNode(hNode var1, hNode var2);

    void createIndex(int[] nArray, String string, boolean bl) throws SQLException {
        hError.assert((this.iPrimaryKey != -1 ? 1 : 0) != 0, (String)"createIndex");
        int n = 0;
        while (n < this.iIndexCount) {
            hIndex hIndex2 = this.getIndex(n);
            if (string.equals(hIndex2.getName())) {
                throw hError.error((int)23);
            }
            ++n;
        }
        int n2 = nArray.length;
        int[] nArray2 = new int[bl ? n2 : n2 + 1];
        int[] nArray3 = new int[bl ? n2 : n2 + 1];
        int n3 = 0;
        while (n3 < n2) {
            nArray2[n3] = nArray[n3];
            nArray3[n3] = this.getColumn((int)nArray2[n3]).iType;
            ++n3;
        }
        if (!bl) {
            nArray2[n2] = this.iPrimaryKey;
            nArray3[n2] = this.getColumn((int)this.iPrimaryKey).iType;
        }
        hIndex hIndex3 = new hIndex(string, nArray2, nArray3, bl, this);
        if (this.iIndexCount != 0) {
            hNode hNode2 = this.getIndex(0).first();
            while (hNode2 != null) {
                hNode hNode3 = this.getNewNode();
                this.copyNode(hNode3, hNode2);
                hIndex3.insert(hNode3);
                hNode2 = hIndex.next((hNode)hNode2);
            }
        }
        this.vIndex.addElement(hIndex3);
        ++this.iIndexCount;
    }

    void createPrimaryKey() throws SQLException {
        hError.assert((this.iPrimaryKey == -1 ? 1 : 0) != 0, (String)"hTable.createPrimaryKey");
        this.addColumn("SYSTEM_ID", 4, true);
        this.createPrimaryKey(this.iColumnCount - 1);
        this.iVisibleColumns = this.iColumnCount - 1;
    }

    void createPrimaryKey(int n) throws SQLException {
        hError.assert((this.iPrimaryKey == -1 ? 1 : 0) != 0, (String)"hTable.createPrimaryKey(column)");
        this.iVisibleColumns = this.iColumnCount;
        this.iPrimaryKey = n;
        int[] nArray = new int[]{n};
        this.createIndex(nArray, "SYSTEM_PK", true);
    }

    void delete(Object[] objectArray, hChannel hChannel2) throws SQLException {
        int n = 0;
        while (n < this.iIndexCount) {
            this.getIndex(n).delete(objectArray);
            ++n;
        }
        if (hChannel2 != null) {
            hChannel2.addTransactionDelete(this, objectArray);
        }
        if (this.dDatabase.isLog()) {
            this.dDatabase.writeLog(this.getDeleteStatement(objectArray));
        }
    }

    abstract void deleteNode(hNode var1);

    void dropIndex(String string) throws SQLException {
        int n = 0;
        while (n < this.iIndexCount) {
            if (string.equals(this.getIndex(n).getName())) {
                hError.check((n != 0 ? 1 : 0) != 0, (int)18);
                this.vIndex.removeElementAt(n);
                --this.iIndexCount;
                return;
            }
            ++n;
        }
        throw hError.error((int)13, (String)string);
    }

    private hColumn getColumn(int n) {
        return (hColumn)this.vColumn.elementAt(n);
    }

    int getColumnCount() {
        return this.iVisibleColumns;
    }

    boolean getColumnIsNullable(int n) {
        return this.getColumn(n).isNullable();
    }

    String getColumnName(int n) {
        return this.getColumn((int)n).sName;
    }

    int getColumnNr(String string) throws SQLException {
        int n = this.searchColumn(string);
        if (n == -1) {
            throw hError.error((int)7, (String)string);
        }
        return n;
    }

    int getColumnType(int n) {
        return this.getColumn((int)n).iType;
    }

    abstract Object[] getData(hNode var1);

    private String getDeleteStatement(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer("DELETE FROM ");
        stringBuffer.append(this.sName);
        stringBuffer.append(" WHERE ");
        if (this.iVisibleColumns < this.iColumnCount) {
            int n = 0;
            while (n < this.iVisibleColumns) {
                stringBuffer.append(this.getColumn((int)n).sName);
                stringBuffer.append('=');
                stringBuffer.append(hColumn.createString((Object)objectArray[n], (int)this.getColumn((int)n).iType));
                if (n < this.iVisibleColumns - 1) {
                    stringBuffer.append(" AND ");
                }
                ++n;
            }
        } else {
            stringBuffer.append(this.getColumn((int)this.iPrimaryKey).sName);
            stringBuffer.append("=");
            stringBuffer.append(hColumn.createString((Object)objectArray[this.iPrimaryKey], (int)this.getColumn((int)this.iPrimaryKey).iType));
        }
        return stringBuffer.toString();
    }

    protected hIndex getIndex(int n) {
        return (hIndex)this.vIndex.elementAt(n);
    }

    protected hIndex getIndex(String string) {
        int n = 0;
        while (n < this.iIndexCount) {
            hIndex hIndex2 = this.getIndex(n);
            if (string.equals(hIndex2.getName())) {
                return hIndex2;
            }
            ++n;
        }
        return null;
    }

    hIndex getIndexForColumn(int n) throws SQLException {
        int n2 = 0;
        while (n2 < this.iIndexCount) {
            hIndex hIndex2 = this.getIndex(n2);
            if (hIndex2.getColumns()[0] == n) {
                return hIndex2;
            }
            ++n2;
        }
        return null;
    }

    String getInsertStatement(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
        stringBuffer.append(this.getName());
        stringBuffer.append(" VALUES(");
        int n = 0;
        while (n < this.iVisibleColumns) {
            stringBuffer.append(hColumn.createString((Object)objectArray[n], (int)this.getColumn((int)n).iType));
            stringBuffer.append(',');
            ++n;
        }
        stringBuffer.setCharAt(stringBuffer.length() - 1, ')');
        return stringBuffer.toString();
    }

    String getName() {
        return this.sName;
    }

    abstract hNode getNewNode();

    Object[] getNewRow() {
        return new Object[this.iColumnCount];
    }

    hIndex getNextIndex(hIndex hIndex2) {
        int n = 0;
        if (hIndex2 != null) {
            while (n < this.iIndexCount && this.getIndex(n) != hIndex2) {
                ++n;
            }
            ++n;
        }
        if (n < this.iIndexCount) {
            return this.getIndex(n);
        }
        return null;
    }

    hIndex getPrimaryIndex() throws SQLException {
        hError.assert((this.iPrimaryKey != -1 ? 1 : 0) != 0, (String)"hTable.getAnyIndex");
        return this.getIndex(0);
    }

    int getType(int n) {
        return this.getColumn((int)n).iType;
    }

    void insert(hResult hResult2, hChannel hChannel2) throws SQLException {
        hRecord hRecord2 = hResult2.rRoot;
        int n = hResult2.getColumnCount();
        while (hRecord2 != null) {
            Object[] objectArray = this.getNewRow();
            int n2 = 0;
            while (n2 < n) {
                objectArray[n2] = hRecord2.data[n2];
                ++n2;
            }
            this.insert(objectArray, hChannel2);
            hRecord2 = hRecord2.next;
        }
    }

    void insert(Vector vector, int n, hChannel hChannel2) throws SQLException {
        if (n != this.iVisibleColumns) {
            throw hError.error((int)9, (int)n);
        }
        Object[] objectArray = new Object[this.iColumnCount];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = hColumn.convertString((String)((String)vector.elementAt(n2)), (int)this.getColumn((int)n2).iType);
            ++n2;
        }
        this.insertRaw(objectArray, hChannel2);
    }

    void insert(Vector vector, Vector vector2, int n, hChannel hChannel2) throws SQLException {
        Object[] objectArray = this.getNewRow();
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.getColumnNr((String)vector.elementAt(n2));
            objectArray[n3] = hColumn.convertString((String)((String)vector2.elementAt(n2)), (int)this.getColumn((int)n3).iType);
            ++n2;
        }
        this.insertRaw(objectArray, hChannel2);
    }

    void insert(Object[] objectArray, hChannel hChannel2) throws SQLException {
        this.insertRaw(objectArray, hChannel2);
    }

    abstract void insertData(Object[] var1) throws SQLException;

    private void insertRaw(Object[] objectArray, hChannel hChannel2) throws SQLException {
        if (this.iVisibleColumns < this.iColumnCount) {
            objectArray[this.iPrimaryKey] = new Integer(this.iRowId++);
        }
        int n = 0;
        while (n < this.iColumnCount) {
            if (objectArray[n] == null && !this.getColumn(n).isNullable()) {
                throw hError.error((int)11);
            }
            ++n;
        }
        this.insertData(objectArray);
        if (hChannel2 != null) {
            hChannel2.addTransactionInsert(this, objectArray);
        }
        if (this.dDatabase.isLog()) {
            this.dDatabase.writeLog(this.getInsertStatement(objectArray));
        }
    }

    abstract boolean isCached();

    int searchColumn(String string) {
        int n = 0;
        while (n < this.iColumnCount) {
            if (string.equals(((hColumn)this.vColumn.elementAt((int)n)).sName)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    abstract void setData(hNode var1, Object[] var2);
}

