/*
 * Decompiled with CFR 0.152.
 */
package hSql;

import hSql.hByteArray;
import hSql.hError;
import hSql.hRecord;
import hSql.hResult;
import hSql.hResultSetMetaData;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class hResultSet
implements ResultSet {
    private hResult rResult;
    private hRecord nCurrent;
    private int iCurrentRow;
    private int iUpdateCount;
    private boolean bInit;
    private int iColumnCount;
    private boolean bWasNull;
    static final int FETCH_FORWARD = 1000;
    static final int FETCH_REVERSE = 1001;
    static final int FETCH_UNKNOWN = 1002;
    static final int TYPE_FORWARD_ONLY = 1003;
    static final int TYPE_SCROLL_INSENSITIVE = 1004;
    static final int TYPE_SCROLL_SENSITIVE = 1005;
    static final int CONCUR_READ_ONLY = 1007;
    static final int CONCUR_UPDATABLE = 1008;

    public hResultSet(hResult hResult2) throws SQLException {
        if (hResult2.iMode == 0) {
            this.iUpdateCount = hResult2.iUpdateCount;
        } else {
            if (hResult2.iMode == 1) {
                throw new SQLException(hResult2.sError);
            }
            this.iUpdateCount = -1;
            this.rResult = hResult2;
            this.iColumnCount = hResult2.iType.length;
        }
        this.bWasNull = false;
    }

    public boolean absolute(int n) throws SQLException {
        this.trace("absolute: " + n);
        throw hError.error((int)21);
    }

    public void afterLast() throws SQLException {
        this.trace("afterLast");
        throw hError.error((int)21);
    }

    public void beforeFirst() throws SQLException {
        this.trace("beforeFirst");
        throw hError.error((int)21);
    }

    public void cancelRowUpdates() throws SQLException {
        this.trace("cancelRowUpdates");
    }

    private void checkColumn(int n) throws SQLException {
        if (this.rResult == null || !this.bInit || this.nCurrent == null) {
            throw hError.error((int)7, (int)n);
        }
        if (n < 0 || n >= this.iColumnCount) {
            throw hError.error((int)7, (int)n);
        }
    }

    private boolean checkNull(Object object) {
        if (object == null) {
            this.bWasNull = true;
            return true;
        }
        this.bWasNull = false;
        return false;
    }

    public void clearWarnings() {
        this.trace("clearWarnings");
    }

    public void close() {
        this.trace("close");
        this.iUpdateCount = -1;
        this.rResult = null;
    }

    public void deleteRow() throws SQLException {
        this.trace("deleteRow");
        throw hError.error((int)21);
    }

    public int findColumn(String string) throws SQLException {
        this.trace("findColumn: " + string);
        int n = 0;
        while (n < this.iColumnCount) {
            if (string.equals(this.rResult.sName[n])) {
                return n + 1;
            }
            ++n;
        }
        throw hError.error((int)7);
    }

    public boolean first() throws SQLException {
        this.trace("first");
        throw hError.error((int)21);
    }

    public Array getArray(int n) throws SQLException {
        this.trace("getArray: " + n);
        throw hError.error((int)21);
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        this.trace("getAsciiStream: " + n);
        throw hError.error((int)21);
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.getBigDecimal(n, 0);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.trace("getBigDecimal: " + n + "," + n2);
        this.checkColumn(--n);
        if (this.rResult.iType[n] != 3) {
            throw hError.error((int)4);
        }
        Object object = this.nCurrent.data[n];
        this.checkNull(object);
        return (BigDecimal)object;
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        this.trace("getBinaryStream: " + n);
        throw hError.error((int)21);
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public Blob getBlob(int n) throws SQLException {
        this.trace("getBlob: " + n);
        throw hError.error((int)21);
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public boolean getBoolean(int n) throws SQLException {
        this.trace("getBoolean: " + n);
        this.checkColumn(--n);
        hError.check((this.rResult.iType[n] == -7 ? 1 : 0) != 0, (int)4);
        Object object = this.nCurrent.data[n];
        if (this.checkNull(object)) {
            return false;
        }
        return (Boolean)object;
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(int n) throws SQLException {
        this.trace("getByte: " + n);
        throw hError.error((int)4);
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public byte[] getBytes(int n) throws SQLException {
        this.trace("getBytes: " + n);
        this.checkColumn(--n);
        switch (this.rResult.iType[n]) {
            default: {
                throw hError.error((int)4);
            }
            case -4: 
            case -3: 
            case -2: 
        }
        Object object = this.nCurrent.data[n];
        if (this.checkNull(object)) {
            return null;
        }
        return ((hByteArray)object).byteValue();
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Reader getCharacterStream(int n) throws SQLException {
        this.trace("getCharacterStream: " + n);
        throw hError.error((int)21);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public Clob getClob(int n) throws SQLException {
        this.trace("getClob: " + n);
        throw hError.error((int)21);
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public int getConcurrency() throws SQLException {
        this.trace("getConcurrency");
        return 1007;
    }

    public String getCursorName() {
        this.trace("getCursorName");
        return null;
    }

    public Date getDate(int n) throws SQLException {
        this.trace("getDate: " + n);
        this.checkColumn(--n);
        hError.check((this.rResult.iType[n] == 91 ? 1 : 0) != 0, (int)4);
        Object object = this.nCurrent.data[n];
        this.checkNull(object);
        return (Date)object;
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDate(n);
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public double getDouble(int n) throws SQLException {
        this.trace("getDouble: " + n);
        this.checkColumn(--n);
        int n2 = this.rResult.iType[n];
        if (n2 != 8 && n2 != 6) {
            throw hError.error((int)4);
        }
        Object object = this.nCurrent.data[n];
        if (this.checkNull(object)) {
            return 0.0;
        }
        return (Double)object;
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public int getFetchDirection() throws SQLException {
        this.trace("getFetchDirection");
        return 1000;
    }

    public int getFetchSize() throws SQLException {
        this.trace("getFetchSize");
        return 1;
    }

    public float getFloat(int n) throws SQLException {
        this.trace("getFloat: " + n);
        this.checkColumn(--n);
        hError.check((this.rResult.iType[n] != 7 ? 1 : 0) != 0, (int)4);
        Object object = this.nCurrent.data[n];
        if (this.checkNull(object)) {
            return 0.0f;
        }
        return ((Float)object).floatValue();
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public int getInt(int n) throws SQLException {
        this.trace("getInt: " + n);
        this.checkColumn(--n);
        if (this.rResult.iType[n] != 4) {
            throw hError.error((int)4);
        }
        Object object = this.nCurrent.data[n];
        if (this.checkNull(object)) {
            return 0;
        }
        return (Integer)object;
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(int n) throws SQLException {
        this.trace("getLong: " + n);
        this.checkColumn(--n);
        hError.check((this.rResult.iType[n] == -5 ? 1 : 0) != 0, (int)4);
        Object object = this.nCurrent.data[n];
        if (this.checkNull(object)) {
            return 0L;
        }
        return (Long)object;
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.trace("getMetaData");
        if (this.rResult == null) {
            return null;
        }
        return new hResultSetMetaData(this.rResult);
    }

    public Object getObject(int n) throws SQLException {
        this.trace("getObject: " + n);
        this.checkColumn(--n);
        Object object = this.nCurrent.data[n];
        this.checkNull(object);
        return object;
    }

    public Object getObject(int n, Map map) throws SQLException {
        return this.getObject(n);
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    public Ref getRef(int n) throws SQLException {
        this.trace("getRef: " + n);
        throw hError.error((int)21);
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    public int getRow() throws SQLException {
        this.trace("getRow");
        return this.iCurrentRow;
    }

    public int getRowCount() {
        this.trace("getRowCount");
        int n = 0;
        if (this.rResult == null) {
            return n;
        }
        hRecord hRecord2 = this.rResult.rRoot;
        while (hRecord2 != null) {
            ++n;
            hRecord2 = hRecord2.next;
        }
        return n;
    }

    public short getShort(int n) throws SQLException {
        this.trace("getShort: " + n);
        this.checkColumn(--n);
        int n2 = this.rResult.iType[n];
        if (n2 != -6 && n2 != 5) {
            throw hError.error((int)4);
        }
        Object object = this.nCurrent.data[n];
        if (this.checkNull(object)) {
            return 0;
        }
        return (Short)object;
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public Statement getStatement() throws SQLException {
        this.trace("getStatement");
        return null;
    }

    public String getString(int n) throws SQLException {
        this.trace("getString: " + n);
        this.checkColumn(--n);
        Object object = this.nCurrent.data[n];
        if (this.checkNull(object)) {
            return null;
        }
        int n2 = this.rResult.iType[n];
        return object.toString();
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public Time getTime(int n) throws SQLException {
        this.trace("getTime: " + n);
        this.checkColumn(--n);
        hError.check((this.rResult.iType[n] != 92 ? 1 : 0) != 0, (int)4);
        Object object = this.nCurrent.data[n];
        this.checkNull(object);
        return (Time)object;
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.getTime(n);
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        this.trace("getTimestamp: " + n);
        this.checkColumn(--n);
        if (this.rResult.iType[n] != 93) {
            throw hError.error((int)4);
        }
        Object object = this.nCurrent.data[n];
        this.checkNull(object);
        return (Timestamp)object;
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.getTimestamp(n);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public String getTitle(int n) throws SQLException {
        this.trace("getTitle: " + n);
        this.checkColumn(--n);
        return this.rResult.sLabel[n];
    }

    public int getType() throws SQLException {
        this.trace("getType");
        return 1003;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        this.trace("getUnicodeStream: " + n);
        throw hError.error((int)21);
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public int getUpdateCount() {
        this.trace("getUpdateCount");
        return this.iUpdateCount;
    }

    public SQLWarning getWarnings() {
        this.trace("getWarnings");
        return null;
    }

    public void insertRow() throws SQLException {
        this.trace("insertRow");
        throw hError.error((int)21);
    }

    public boolean isAfterLast() throws SQLException {
        this.trace("isAfterLast");
        if (!this.bInit) {
            return false;
        }
        return this.nCurrent == null;
    }

    public boolean isBeforeFirst() throws SQLException {
        this.trace("isBeforeFirst");
        return !this.bInit;
    }

    public boolean isFirst() throws SQLException {
        this.trace("isFirst");
        return this.iCurrentRow == 1;
    }

    public boolean isLast() throws SQLException {
        this.trace("isLast");
        throw hError.error((int)21);
    }

    public boolean isResult() {
        this.trace("isResult");
        return this.rResult != null;
    }

    public boolean last() throws SQLException {
        this.trace("last");
        throw hError.error((int)21);
    }

    public void moveToCurrentRow() throws SQLException {
        this.trace("moveToCurrentRow");
    }

    public void moveToInsertRow() throws SQLException {
        this.trace("moveToInsertRow");
        throw hError.error((int)21);
    }

    public boolean next() {
        this.trace("next");
        this.bWasNull = false;
        if (this.rResult == null) {
            return false;
        }
        if (!this.bInit) {
            this.nCurrent = this.rResult.rRoot;
            this.bInit = true;
            this.iCurrentRow = 1;
        } else {
            this.nCurrent = this.nCurrent.next;
            ++this.iCurrentRow;
        }
        if (this.nCurrent == null) {
            this.iCurrentRow = 0;
            return false;
        }
        return true;
    }

    public boolean previous() throws SQLException {
        this.trace("previous");
        throw hError.error((int)21);
    }

    public void refreshRow() throws SQLException {
        this.trace("refreshRow");
    }

    /*
     * Unable to fully structure code
     */
    public boolean relative(int var1_1) throws SQLException {
        this.trace("relative: " + var1_1);
        if (var1_1 >= 0) ** GOTO lbl6
        throw hError.error((int)21);
lbl-1000:
        // 1 sources

        {
            this.next();
lbl6:
            // 2 sources

            ** while (var1_1-- > 0)
        }
lbl7:
        // 1 sources

        return this.nCurrent != null;
    }

    public boolean rowDeleted() throws SQLException {
        this.trace("rowDeleted");
        return false;
    }

    public boolean rowInserted() throws SQLException {
        this.trace("rowInserted");
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        this.trace("rowUpdated");
        return false;
    }

    public void setFetchDirection(int n) throws SQLException {
        this.trace("setFetchDirection: " + n);
        if (n != 1000) {
            throw hError.error((int)21);
        }
    }

    public void setFetchSize(int n) throws SQLException {
        this.trace("setFetchSize: " + n);
    }

    private void trace(String string) {
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.trace("updateAsciiStream");
        throw hError.error((int)21);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.trace("updateBigDecimal");
        throw hError.error((int)21);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.trace("updateBinaryStream");
        throw hError.error((int)21);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.trace("updateBoolean");
        throw hError.error((int)21);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.trace("updateByte");
        throw hError.error((int)21);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.trace("updateBytes");
        throw hError.error((int)21);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.trace("updateCharacterStream");
        throw hError.error((int)21);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.trace("updateDate");
        throw hError.error((int)21);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.trace("updateDouble");
        throw hError.error((int)21);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.trace("updateFloat");
        throw hError.error((int)21);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.trace("updateInt");
        throw hError.error((int)21);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(int n, long l) throws SQLException {
        this.trace("updateLong");
        throw hError.error((int)21);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateNull(int n) throws SQLException {
        this.trace("updateNull: " + n);
        throw hError.error((int)21);
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.trace("updateObject");
        throw hError.error((int)21);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.trace("updateObject");
        throw hError.error((int)21);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateRow() throws SQLException {
        this.trace("updateRow");
        throw hError.error((int)21);
    }

    public void updateShort(int n, short s) throws SQLException {
        this.trace("updateShort");
        throw hError.error((int)21);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateString(int n, String string) throws SQLException {
        this.trace("updateString");
        throw hError.error((int)21);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.trace("updateTime");
        throw hError.error((int)21);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.trace("updateTimestamp");
        throw hError.error((int)21);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public boolean wasNull() {
        this.trace("wasNull");
        return this.bWasNull;
    }
}

