/*
 * Decompiled with CFR 0.152.
 */
package hSql;

import hSql.hChannel;
import hSql.hDatabase;
import hSql.hError;
import hSql.hIndex;
import hSql.hNode;
import hSql.hRecord;
import hSql.hResult;
import hSql.hTable;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Vector;

public class hFile {
    private hDatabase dDatabase;
    private hChannel cSystem;
    private String sFile;
    private DataOutputStream dLog;

    hFile(hDatabase hDatabase2, hChannel hChannel2, String string) {
        this.dDatabase = hDatabase2;
        this.cSystem = hChannel2;
        this.sFile = string;
    }

    synchronized void backup() throws SQLException {
        this.trace("backup");
        if (this.dLog != null) {
            this.backupDatabase();
        }
    }

    private void backupDatabase() throws SQLException {
        this.trace("backupDatabase");
        this.closeLog();
        try {
            Object object;
            this.trace("backupDatabase: create backup " + this.sFile);
            long l = System.currentTimeMillis();
            FileOutputStream fileOutputStream = new FileOutputStream(this.sFile);
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            hResult hResult2 = this.dDatabase.getScript(false, false, this.cSystem);
            hRecord hRecord2 = hResult2.rRoot;
            while (hRecord2 != null) {
                object = (String)hRecord2.data[0];
                if (object != null && !((String)object).equals("")) {
                    dataOutputStream.writeUTF((String)object);
                }
                hRecord2 = hRecord2.next;
            }
            object = this.dDatabase.getTables();
            int n = 0;
            while (n < ((Vector)object).size()) {
                hTable hTable2 = (hTable)((Vector)object).elementAt(n);
                hNode hNode2 = hTable2.getPrimaryIndex().first();
                while (hNode2 != null) {
                    dataOutputStream.writeUTF(hTable2.getInsertStatement(hTable2.getData(hNode2)));
                    hNode2 = hIndex.next((hNode)hNode2);
                }
                ++n;
            }
            dataOutputStream.flush();
            dataOutputStream.close();
            fileOutputStream.close();
            l = System.currentTimeMillis() - l;
            this.trace("backupDatabase: backup took " + l + " ms");
        }
        catch (IOException iOException) {
            hError.error((int)16, (String)(String.valueOf(this.sFile) + " " + iOException));
        }
        this.openLog();
        this.closeLog();
    }

    private void closeLog() throws SQLException {
        this.trace("closeLog");
        try {
            if (this.dLog != null) {
                this.dLog.close();
                this.dLog = null;
            }
        }
        catch (Exception exception) {
            hError.error((int)15, (String)(String.valueOf(this.sFile) + ".log"));
        }
    }

    boolean isLog() {
        return this.dLog != null;
    }

    private void openLog() throws SQLException {
        this.trace("openLog");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(this.sFile) + ".log");
            this.dLog = new DataOutputStream(fileOutputStream);
        }
        catch (Exception exception) {
            hError.error((int)15, (String)(String.valueOf(this.sFile) + ".log"));
        }
        this.trace("openLog");
    }

    synchronized void restore() throws SQLException {
        this.trace("restore");
        this.restoreDatabase();
    }

    private void restoreDatabase() throws SQLException {
        DataInputStream dataInputStream;
        BufferedInputStream bufferedInputStream;
        FileInputStream fileInputStream;
        this.trace("restoreDatabase");
        File file = new File(this.sFile);
        if (!file.exists()) {
            this.trace("restoreDatabase: creating new database");
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.sFile);
                DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
                dataOutputStream.writeUTF("");
                dataOutputStream.close();
                fileOutputStream.close();
                this.trace("restoreDatabase: created");
            }
            catch (IOException iOException) {
                hError.error((int)15, (String)(String.valueOf(this.sFile) + " " + iOException));
            }
        }
        try {
            this.trace("restoreDatabase: from " + this.sFile);
            long l = System.currentTimeMillis();
            fileInputStream = new FileInputStream(this.sFile);
            bufferedInputStream = new BufferedInputStream(fileInputStream, 10240);
            dataInputStream = new DataInputStream(bufferedInputStream);
            while (dataInputStream.available() != 0) {
                String string = dataInputStream.readUTF();
                this.dDatabase.execute(string, this.cSystem);
            }
            dataInputStream.close();
            bufferedInputStream.close();
            fileInputStream.close();
            l = System.currentTimeMillis() - l;
            this.trace("restoreDatabase: restored in " + l + " ms");
        }
        catch (IOException iOException) {
            hError.error((int)16, (String)(String.valueOf(this.sFile) + " " + iOException));
        }
        file = new File(String.valueOf(this.sFile) + ".log");
        if (file.exists()) {
            try {
                this.trace("restoreDatabase: recovering with log");
                long l = System.currentTimeMillis();
                fileInputStream = new FileInputStream(String.valueOf(this.sFile) + ".log");
                bufferedInputStream = new BufferedInputStream(fileInputStream, 10240);
                dataInputStream = new DataInputStream(bufferedInputStream);
                boolean bl = false;
                while (dataInputStream.available() != 0) {
                    String string = dataInputStream.readUTF();
                    if (!string.equals("")) {
                        bl = true;
                    }
                    this.dDatabase.execute(string, this.cSystem);
                }
                dataInputStream.close();
                bufferedInputStream.close();
                fileInputStream.close();
                dataInputStream = null;
                fileInputStream = null;
                l = System.currentTimeMillis() - l;
                this.trace("restoreDatabase: recovered in " + l + " ms");
                if (bl) {
                    this.backupDatabase();
                }
            }
            catch (IOException iOException) {
                hError.error((int)16, (String)(String.valueOf(this.sFile) + " " + iOException));
            }
        }
        this.openLog();
    }

    private void trace(String string) {
        DriverManager.println("hSql.hFile." + string);
    }

    void write(String string) throws SQLException {
        if (this.dLog == null || string == null || string.equals("")) {
            return;
        }
        try {
            this.dLog.writeUTF(string);
            this.dLog.flush();
        }
        catch (IOException iOException) {
            hError.error((int)15, (String)(String.valueOf(this.sFile) + ".log"));
        }
    }
}

