/*
 * Decompiled with CFR 0.152.
 */
package hSql;

import hSql.hAccess;
import hSql.hCache;
import hSql.hChannel;
import hSql.hColumn;
import hSql.hConditionParser;
import hSql.hDatabaseInformation;
import hSql.hError;
import hSql.hFile;
import hSql.hFormulaParser;
import hSql.hProducer;
import hSql.hRecord;
import hSql.hResult;
import hSql.hTable;
import hSql.hTableCached;
import hSql.hTableMemory;
import hSql.hTokenizer;
import hSql.hUser;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Vector;

public class hDatabase {
    hCache cCache;
    private hAccess aAccess;
    private Vector tTable = new Vector();
    private Vector cChannel = new Vector();
    private hFile fLog;
    private hDatabaseInformation dInfo;

    public hDatabase(String string) throws SQLException {
        this.aAccess = new hAccess();
        this.aAccess.createUser("sa", "", true);
        this.dInfo = new hDatabaseInformation(this, this.tTable, this.aAccess);
        if (string.equals(".")) {
            this.fLog = new hFile(this, null, null);
            this.trace("memory only mode");
        } else {
            this.cCache = new hCache(String.valueOf(string) + ".dat");
            this.fLog = new hFile(this, this.connect("sa", ""), string);
            this.fLog.restore();
        }
    }

    synchronized void backup() throws SQLException {
        this.fLog.backup();
    }

    public synchronized hChannel connect(String string, String string2) throws SQLException {
        hUser hUser2 = this.aAccess.getUser(string, string2);
        return new hChannel(hUser2, true);
    }

    private void dropTable(String string) throws SQLException {
        int n = 0;
        while (n < this.tTable.size()) {
            hTable hTable2 = (hTable)this.tTable.elementAt(n);
            if (hTable2.getName().equals(string)) {
                this.tTable.removeElementAt(n);
                return;
            }
            ++n;
        }
        throw hError.error((int)3, (String)string);
    }

    public synchronized hResult execute(String string, hChannel hChannel2) {
        hTokenizer hTokenizer2 = new hTokenizer(string);
        hResult hResult2 = new hResult();
        try {
            String string2;
            hError.check((hChannel2 != null ? 1 : 0) != 0, (int)29);
            while (true) {
                if ((string2 = hTokenizer2.getString()).equals("")) {
                    return hResult2;
                }
                if (string2.equals("SELECT")) {
                    hResult2 = this.processSelect(hTokenizer2, hChannel2);
                    continue;
                }
                if (string2.equals("INSERT")) {
                    hResult2 = this.processInsert(hTokenizer2, hChannel2);
                    continue;
                }
                if (string2.equals("UPDATE")) {
                    hResult2 = this.processUpdate(hTokenizer2, hChannel2);
                    continue;
                }
                if (string2.equals("DELETE")) {
                    hResult2 = this.processDelete(hTokenizer2, hChannel2);
                    continue;
                }
                if (string2.equals("CREATE")) {
                    hResult2 = this.processCreate(hTokenizer2, hChannel2);
                    continue;
                }
                if (string2.equals("DROP")) {
                    hResult2 = this.processDrop(hTokenizer2, hChannel2);
                    continue;
                }
                if (string2.equals("GRANT")) {
                    hResult2 = this.processGrantOrRevoke(hTokenizer2, hChannel2, true);
                    continue;
                }
                if (string2.equals("REVOKE")) {
                    hResult2 = this.processGrantOrRevoke(hTokenizer2, hChannel2, false);
                    continue;
                }
                if (string2.equals("CONNECT")) {
                    hResult2 = this.processConnect(hTokenizer2, hChannel2);
                    continue;
                }
                if (string2.equals("SET")) {
                    hResult2 = this.processSet(hTokenizer2, hChannel2);
                    continue;
                }
                if (string2.equals("SCRIPT")) {
                    hResult2 = this.getScript(true, true, hChannel2);
                    continue;
                }
                if (string2.equals("COMMIT")) {
                    hResult2 = this.processCommit(hTokenizer2, hChannel2);
                    continue;
                }
                if (string2.equals("ROLLBACK")) {
                    hResult2 = this.processRollback(hTokenizer2, hChannel2);
                    continue;
                }
                if (!string2.equals(";")) break;
            }
            throw hError.error((int)0, (String)string2);
        }
        catch (SQLException sQLException) {
            return new hResult(sQLException.getMessage());
        }
    }

    private void fillFieldName(hTokenizer hTokenizer2, String[] stringArray) {
        if (hTokenizer2.wasLongName()) {
            stringArray[0] = hTokenizer2.getLongNameFirst();
            stringArray[1] = hTokenizer2.getLongNameLast();
        } else {
            stringArray[1] = hTokenizer2.getCurrentToken();
        }
    }

    public byte[] getResult(String string) {
        int n = string.indexOf(124);
        int n2 = string.indexOf(124, n + 1);
        if (n < 0 || n2 <= n) {
            return new byte[0];
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, n2);
        string = string.substring(n2 + 1);
        hChannel hChannel2 = null;
        try {
            hChannel2 = this.connect(string2, string3);
        }
        catch (Exception exception) {
            return new byte[0];
        }
        hResult hResult2 = this.execute(string, hChannel2);
        if (hResult2 == null) {
            return new byte[0];
        }
        return hResult2.getBytes();
    }

    hResult getScript(boolean bl, boolean bl2, hChannel hChannel2) throws SQLException {
        return this.dInfo.getScript(bl, bl2, hChannel2);
    }

    private hTable getTable(String string, hChannel hChannel2) throws SQLException {
        hTable hTable2 = null;
        int n = 0;
        while (n < this.tTable.size()) {
            hTable2 = (hTable)this.tTable.elementAt(n);
            if (hTable2.getName().equals(string)) {
                return hTable2;
            }
            ++n;
        }
        hTable2 = this.dInfo.getSystemTable(string, hChannel2);
        if (hTable2 == null) {
            throw hError.error((int)3, (String)string);
        }
        return hTable2;
    }

    Vector getTables() {
        return this.tTable;
    }

    String getValue(hTokenizer hTokenizer2, hChannel hChannel2) throws SQLException {
        hFormulaParser hFormulaParser2 = new hFormulaParser(this, hTokenizer2, hChannel2);
        return hFormulaParser2.getValue();
    }

    boolean isLog() {
        return this.fLog.isLog();
    }

    private void linkTable(hTable hTable2) throws SQLException {
        String string = hTable2.getName();
        int n = 0;
        while (n < this.tTable.size()) {
            hTable hTable3 = (hTable)this.tTable.elementAt(n);
            if (hTable3.getName().equals(string)) {
                throw hError.error((int)2, (String)string);
            }
            ++n;
        }
        this.tTable.addElement(hTable2);
    }

    private hResult processCommit(hTokenizer hTokenizer2, hChannel hChannel2) throws SQLException {
        hChannel2.commit();
        return new hResult();
    }

    private hResult processConnect(hTokenizer hTokenizer2, hChannel hChannel2) throws SQLException {
        int n = hTokenizer2.getPosition();
        hTokenizer2.getThis("USER");
        String string = hTokenizer2.getStringToken();
        hTokenizer2.getThis("PASSWORD");
        String string2 = hTokenizer2.getStringToken();
        hUser hUser2 = this.aAccess.getUser(string, string2);
        hChannel2.commit();
        hChannel2.setUser(hUser2);
        int n2 = hTokenizer2.getPosition();
        this.fLog.write("CONNECT" + hTokenizer2.getPart(n, n2));
        return new hResult();
    }

    private hResult processCreate(hTokenizer hTokenizer2, hChannel hChannel2) throws SQLException {
        hChannel2.checkAdmin();
        int n = hTokenizer2.getPosition();
        String string = hTokenizer2.getString();
        if (string.equals("TABLE")) {
            this.processCreateTable(hTokenizer2, hChannel2, false);
        } else if (string.equals("MEMORY")) {
            hTokenizer2.getThis("TABLE");
            this.processCreateTable(hTokenizer2, hChannel2, false);
        } else if (string.equals("CACHED")) {
            hTokenizer2.getThis("TABLE");
            this.processCreateTable(hTokenizer2, hChannel2, true);
        } else if (string.equals("USER")) {
            String string2 = hTokenizer2.getStringToken();
            hTokenizer2.getThis("PASSWORD");
            String string3 = hTokenizer2.getStringToken();
            this.aAccess.createUser(string2, string3, false);
        } else {
            Vector<String> vector;
            hTable hTable2;
            String string4;
            boolean bl;
            block12: {
                bl = false;
                if (string.equals("UNIQUE")) {
                    bl = true;
                    string = hTokenizer2.getString();
                }
                if (!string.equals("INDEX")) {
                    throw hError.error((int)1, (String)string);
                }
                string4 = hTokenizer2.getName();
                hTokenizer2.getThis("ON");
                hTable2 = this.getTable(hTokenizer2.getString(), hChannel2);
                vector = new Vector<String>();
                hTokenizer2.getThis("(");
                do {
                    vector.addElement(hTokenizer2.getString());
                    string = hTokenizer2.getString();
                    if (string.equals(")")) break block12;
                } while (string.equals(","));
                throw hError.error((int)1, (String)string);
            }
            int n2 = vector.size();
            int[] nArray = new int[n2];
            int n3 = 0;
            while (n3 < n2) {
                nArray[n3] = hTable2.getColumnNr((String)vector.elementAt(n3));
                ++n3;
            }
            hChannel2.commit();
            hTable2.createIndex(nArray, string4, bl);
        }
        int n4 = hTokenizer2.getPosition();
        this.fLog.write("CREATE" + hTokenizer2.getPart(n, n4));
        return new hResult();
    }

    private void processCreateTable(hTokenizer hTokenizer2, hChannel hChannel2, boolean bl) throws SQLException {
        String string = hTokenizer2.getName();
        Object object = bl && this.cCache != null ? new hTableCached(this, string) : new hTableMemory(this, string);
        hTokenizer2.getThis("(");
        int n = -1;
        int n2 = 0;
        while (true) {
            String string2 = hTokenizer2.getName();
            int n3 = hColumn.getTypeNr((String)hTokenizer2.getString());
            boolean bl2 = false;
            string = hTokenizer2.getString();
            if (string.equals("(")) {
                while (!(string = hTokenizer2.getString()).equals(")")) {
                }
                string = hTokenizer2.getString();
            }
            boolean bl3 = true;
            if (string.equals("NULL")) {
                string = hTokenizer2.getString();
            } else if (string.equals("NOT")) {
                hTokenizer2.getThis("NULL");
                bl3 = false;
                string = hTokenizer2.getString();
            }
            if (string.equals("PRIMARY")) {
                hTokenizer2.getThis("KEY");
                if (n != -1) {
                    throw hError.error((int)8, (String)string2);
                }
                n = n2;
                string = hTokenizer2.getString();
            }
            object.addColumn(string2, n3, bl3);
            if (string.equals(")")) break;
            if (!string.equals(",")) {
                throw hError.error((int)1, (String)string);
            }
            ++n2;
        }
        if (n != -1) {
            object.createPrimaryKey(n);
        } else {
            object.createPrimaryKey();
        }
        hChannel2.commit();
        this.linkTable((hTable)object);
    }

    private hResult processDelete(hTokenizer hTokenizer2, hChannel hChannel2) throws SQLException {
        hResult hResult2;
        hTokenizer2.getThis("FROM");
        String string = hTokenizer2.getString();
        hChannel2.check(string, 2);
        hProducer hProducer2 = new hProducer(this.getTable(string, hChannel2), null, hChannel2);
        string = hTokenizer2.getString();
        if (string.equals("WHERE")) {
            hResult2 = new hConditionParser(this, hTokenizer2, hChannel2, hProducer2);
            string = hResult2.parseCondition();
        }
        hTokenizer2.back();
        hResult2 = new hResult();
        hResult2.iUpdateCount = hProducer2.delete();
        return hResult2;
    }

    private hResult processDrop(hTokenizer hTokenizer2, hChannel hChannel2) throws SQLException {
        hChannel2.checkAdmin();
        int n = hTokenizer2.getPosition();
        String string = hTokenizer2.getString();
        if (string.equals("TABLE")) {
            this.dropTable(hTokenizer2.getString());
        } else if (string.equals("USER")) {
            this.aAccess.dropUser(hTokenizer2.getStringToken());
        } else if (string.equals("INDEX")) {
            string = hTokenizer2.getString();
            if (!hTokenizer2.wasLongName()) {
                throw hError.error((int)1, (String)string);
            }
            hTable hTable2 = this.getTable(hTokenizer2.getLongNameFirst(), hChannel2);
            hChannel2.commit();
            hTable2.dropIndex(hTokenizer2.getLongNameLast());
        } else {
            throw hError.error((int)1, (String)string);
        }
        int n2 = hTokenizer2.getPosition();
        this.fLog.write("DROP" + hTokenizer2.getPart(n, n2));
        return new hResult();
    }

    private hResult processGrantOrRevoke(hTokenizer hTokenizer2, hChannel hChannel2, boolean bl) throws SQLException {
        String string;
        String string2;
        String string3;
        hChannel2.checkAdmin();
        int n = hTokenizer2.getPosition();
        int n2 = 0;
        do {
            string2 = hTokenizer2.getString();
            n2 |= hAccess.getRight((String)string2);
        } while ((string3 = hTokenizer2.getString()).equals(","));
        if (!string3.equals("ON")) {
            throw hError.error((int)1, (String)string3);
        }
        string2 = hTokenizer2.getString();
        this.getTable(string2, hChannel2);
        hTokenizer2.getThis("TO");
        String string4 = hTokenizer2.getStringToken();
        if (bl) {
            this.aAccess.grant(string4, string2, n2);
            string = "GRANT";
        } else {
            this.aAccess.revoke(string4, string2, n2);
            string = "REVOKE";
        }
        int n3 = hTokenizer2.getPosition();
        this.fLog.write(String.valueOf(string) + hTokenizer2.getPart(n, n3));
        return new hResult();
    }

    private hResult processInsert(hTokenizer hTokenizer2, hChannel hChannel2) throws SQLException {
        hResult hResult2;
        int n;
        hTokenizer2.getThis("INTO");
        String string = hTokenizer2.getString();
        hChannel2.check(string, 4);
        hTable hTable2 = this.getTable(string, hChannel2);
        string = hTokenizer2.getString();
        Vector<String> vector = null;
        if (string.equals("(")) {
            block13: {
                vector = new Vector<String>();
                n = 0;
                do {
                    vector.addElement(hTokenizer2.getString());
                    ++n;
                    string = hTokenizer2.getString();
                    if (string.equals(")")) break block13;
                } while (string.equals(","));
                throw hError.error((int)1, (String)string);
            }
            string = hTokenizer2.getString();
        }
        n = 0;
        if (string.equals("VALUES")) {
            int n2;
            block14: {
                hTokenizer2.getThis("(");
                hResult2 = new Vector();
                n2 = 0;
                do {
                    hResult2.addElement(this.getValue(hTokenizer2, hChannel2));
                    ++n2;
                    string = hTokenizer2.getString();
                    if (string.equals(")")) break block14;
                } while (string.equals(","));
                throw hError.error((int)1, (String)string);
            }
            if (vector == null) {
                hTable2.insert((Vector)hResult2, n2, hChannel2);
            } else {
                hTable2.insert(vector, (Vector)hResult2, n2, hChannel2);
            }
            ++n;
        } else if (string.equals("SELECT")) {
            hResult2 = this.processSelect(hTokenizer2, hChannel2);
            hRecord hRecord2 = hResult2.rRoot;
            int n3 = hResult2.getColumnCount();
            while (hRecord2 != null) {
                Vector<String> vector2 = new Vector<String>();
                int n4 = 0;
                while (n4 < n3) {
                    vector2.addElement(hColumn.convertObject((Object)hRecord2.data[n4]));
                    ++n4;
                }
                if (vector == null) {
                    hTable2.insert(vector2, n3, hChannel2);
                } else {
                    hTable2.insert(vector, vector2, n3, hChannel2);
                }
                ++n;
                hRecord2 = hRecord2.next;
            }
        } else {
            throw hError.error((int)1, (String)string);
        }
        hResult2 = new hResult();
        hResult2.iUpdateCount = n;
        return hResult2;
    }

    private hResult processRollback(hTokenizer hTokenizer2, hChannel hChannel2) throws SQLException {
        hChannel2.rollback();
        return new hResult();
    }

    hResult processSelect(hTokenizer hTokenizer2, hChannel hChannel2) throws SQLException {
        Object object;
        Vector vector = this.processSelectColumnList(hTokenizer2);
        hProducer[] hProducerArray = this.processSelectTableList(hTokenizer2, hChannel2);
        hConditionParser hConditionParser2 = new hConditionParser(this, hTokenizer2, hChannel2, hProducerArray);
        vector = hConditionParser2.expandColumnList(vector);
        String string = hTokenizer2.getString();
        if (string.equals("WHERE")) {
            string = hConditionParser2.parseCondition();
        }
        int[] nArray = null;
        int[] nArray2 = null;
        if (string.equals("ORDER")) {
            hTokenizer2.getThis("BY");
            object = new Vector();
            do {
                String string2 = null;
                String string3 = hTokenizer2.getString();
                if (hTokenizer2.wasLongName()) {
                    string2 = hTokenizer2.getLongNameFirst();
                    string3 = hTokenizer2.getLongNameLast();
                }
                ((Vector)object).addElement(string2);
                ((Vector)object).addElement(string3);
                string = hTokenizer2.getString();
                if (string.equals("DESC")) {
                    ((Vector)object).addElement(this);
                    string = hTokenizer2.getString();
                    continue;
                }
                if (string.equals("ASC")) {
                    ((Vector)object).addElement(null);
                    string = hTokenizer2.getString();
                    continue;
                }
                ((Vector)object).addElement(null);
            } while (string.equals(","));
            int n = ((Vector)object).size();
            nArray = new int[n / 3];
            nArray2 = new int[n / 3];
            int n2 = 0;
            while (n2 < n) {
                String string4 = (String)((Vector)object).elementAt(n2);
                String string5 = (String)((Vector)object).elementAt(n2 + 1);
                nArray[n2 / 3] = hConditionParser2.getProducerColumn(string4, string5);
                nArray2[n2 / 3] = ((Vector)object).elementAt(n2 + 2) == null ? 1 : -1;
                n2 += 3;
            }
        }
        object = hProducer.getResult((hProducer[])hProducerArray, nArray, nArray2, (Vector)vector);
        hTokenizer2.back();
        if (string.equals("UNION")) {
            hTokenizer2.getThis("UNION");
            hTokenizer2.getThis("SELECT");
            hResult hResult2 = this.processSelect(hTokenizer2, hChannel2);
            if (object.getColumnCount() != hResult2.getColumnCount()) {
                throw hError.error((int)31, (String)string);
            }
            hRecord hRecord2 = hResult2.rRoot;
            while (hRecord2 != null) {
                object.add(hRecord2.data);
                hRecord2 = hRecord2.next;
            }
        }
        return object;
    }

    private Vector processSelectColumnList(hTokenizer hTokenizer2) throws SQLException {
        String[] stringArray;
        String string;
        Vector<String[]> vector = new Vector<String[]>();
        int n = 0;
        do {
            stringArray = new String[4];
            string = hTokenizer2.getString();
            int n2 = hProducer.getFormulaNr((String)hTokenizer2.getCurrentToken());
            if (n2 != 0) {
                hTokenizer2.getThis("(");
                hTokenizer2.getString();
                this.fillFieldName(hTokenizer2, stringArray);
                hTokenizer2.getThis(")");
                stringArray[2] = string;
                stringArray[3] = String.valueOf(n2);
            } else if (hTokenizer2.wasLongName()) {
                stringArray[0] = hTokenizer2.getLongNameFirst();
                stringArray[1] = hTokenizer2.getLongNameLast();
            } else {
                stringArray[1] = string;
            }
            string = hTokenizer2.getString();
            if (string.equals("AS")) {
                stringArray[2] = hTokenizer2.getName();
                string = hTokenizer2.getString();
            } else if (hTokenizer2.wasName()) {
                stringArray[2] = string;
                string = hTokenizer2.getString();
            }
            vector.addElement(stringArray);
            ++n;
        } while (string.equals(","));
        if (!string.equals("FROM")) {
            throw hError.error((int)1, (String)string);
        }
        if (n == 1 && (stringArray = (String[])vector.elementAt(0))[1].equals("*") && stringArray[0] == null && stringArray[3] == null) {
            return null;
        }
        return vector;
    }

    private hProducer[] processSelectTableList(hTokenizer hTokenizer2, hChannel hChannel2) throws SQLException {
        hProducer[] hProducerArray;
        String string;
        Vector<hProducer> vector = new Vector<hProducer>();
        int n = 0;
        do {
            Object object;
            string = hTokenizer2.getString();
            hProducerArray = null;
            if (string.equals("(")) {
                hTokenizer2.getThis("SELECT");
                object = this.processSelect(hTokenizer2, hChannel2);
                hProducerArray = new hTableMemory(this, "SYSTEM_SUBQUERY" + n);
                hTokenizer2.getThis(")");
                hProducerArray.addColumns(object);
                hProducerArray.createPrimaryKey();
                hProducerArray.insert(object, hChannel2);
            } else {
                hChannel2.check(string, 1);
                hProducerArray = this.getTable(string, hChannel2);
            }
            object = null;
            string = hTokenizer2.getString();
            if (string.equals("AS")) {
                object = hTokenizer2.getName();
                string = hTokenizer2.getString();
            } else if (hTokenizer2.wasName()) {
                object = string;
                string = hTokenizer2.getString();
            }
            vector.addElement(new hProducer((hTable)hProducerArray, (String)object, hChannel2));
            ++n;
        } while (string.equals(","));
        hProducerArray = new hProducer[n];
        int n2 = 0;
        while (n2 < n) {
            hProducerArray[n2] = (hProducer)vector.elementAt(n2);
            ++n2;
        }
        hTokenizer2.back();
        return hProducerArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private hResult processSet(hTokenizer hTokenizer2, hChannel hChannel2) throws SQLException {
        int n = hTokenizer2.getPosition();
        String string = hTokenizer2.getString();
        if (string.equals("PASSWORD")) {
            hChannel2.setPassword(hTokenizer2.getStringToken());
        } else {
            if (!string.equals("AUTOCOMMIT")) throw hError.error((int)1, (String)string);
            string = hTokenizer2.getString();
            if (string.equals("TRUE")) {
                hChannel2.setAutoCommit(true);
            } else {
                if (!string.equals("FALSE")) throw hError.error((int)1, (String)string);
                hChannel2.setAutoCommit(false);
            }
        }
        int n2 = hTokenizer2.getPosition();
        this.fLog.write("SET" + hTokenizer2.getPart(n, n2));
        return new hResult();
    }

    private hResult processUpdate(hTokenizer hTokenizer2, hChannel hChannel2) throws SQLException {
        hResult hResult2;
        String string = hTokenizer2.getString();
        hChannel2.check(string, 8);
        hProducer hProducer2 = new hProducer(this.getTable(string, hChannel2), null, hChannel2);
        hTokenizer2.getThis("SET");
        Vector<String> vector = new Vector<String>();
        string = null;
        do {
            vector.addElement(hTokenizer2.getString());
            hTokenizer2.getThis("=");
            vector.addElement(this.getValue(hTokenizer2, hChannel2));
        } while ((string = hTokenizer2.getString()).equals(","));
        if (string.equals("WHERE")) {
            hResult2 = new hConditionParser(this, hTokenizer2, hChannel2, hProducer2);
            string = hResult2.parseCondition();
        }
        hTokenizer2.back();
        hResult2 = new hResult();
        hResult2.iUpdateCount = hProducer2.update(vector);
        return hResult2;
    }

    private void trace(String string) {
        DriverManager.println("hSql.hDatabase." + string);
    }

    void writeLog(String string) throws SQLException {
        this.fLog.write(string);
    }
}

