/*
 * Decompiled with CFR 0.152.
 */
package hSql;

import hSql.hCallableStatement;
import hSql.hDatabaseMetaData;
import hSql.hError;
import hSql.hPreparedStatement;
import hSql.hResultSet;
import hSql.hStatement;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;

abstract class hConnection
implements Connection {
    private boolean bClosed;
    private boolean bReadOnly;
    private boolean bEscape;
    private boolean bAutoCommit;
    protected String sDatabaseName;

    public hConnection(String string, String string2, String string3) throws SQLException {
        this.trace("hConnection: [" + string + "]");
        this.bAutoCommit = true;
        this.sDatabaseName = string;
        this.openConnection(string2, string3);
    }

    public void clearWarnings() {
        this.trace("clearWarnings");
    }

    public void close() throws SQLException {
        this.trace("close");
        this.closeConnection();
        this.bClosed = true;
    }

    abstract void closeConnection() throws SQLException;

    public void commit() throws SQLException {
        this.trace("commit");
        this.execute("COMMIT");
    }

    public Statement createStatement() {
        this.trace("createStatement");
        if (this.bClosed) {
            return null;
        }
        return new hStatement(this);
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        return this.createStatement();
    }

    public hResultSet execute(String string) throws SQLException {
        string = this.nativeSQL(string);
        this.trace("execute: [" + string + "]");
        if (this.bClosed) {
            throw hError.error((int)17);
        }
        return this.getResultset(string);
    }

    public boolean getAutoCommit() {
        this.trace("getAutoCommit");
        return this.bAutoCommit;
    }

    public String getCatalog() {
        this.trace("getCatalog");
        return null;
    }

    public DatabaseMetaData getMetaData() {
        this.trace("getMetaData");
        return new hDatabaseMetaData(this);
    }

    public String getName() {
        this.trace("getName");
        return this.sDatabaseName;
    }

    abstract hResultSet getResultset(String var1) throws SQLException;

    public int getTransactionIsolation() {
        this.trace("getTransactionIsolation");
        return 0;
    }

    public Map getTypeMap() throws SQLException {
        throw hError.error((int)21);
    }

    public SQLWarning getWarnings() {
        this.trace("getWarnings");
        return null;
    }

    public boolean isClosed() {
        this.trace("isClosed");
        return this.bClosed;
    }

    public boolean isReadOnly() {
        this.trace("isReadOnly");
        return false;
    }

    public String nativeSQL(String string) {
        if (string.indexOf(123) == -1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        boolean bl = false;
        int n = 0;
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            char c = cArray[n3];
            switch (n) {
                case 0: {
                    if (c == '\'') {
                        n = 1;
                        break;
                    }
                    if (c == '\"') {
                        n = 2;
                        break;
                    }
                    if (c != '{') break;
                    cArray[n3] = 32;
                    bl = true;
                    String string2 = string.substring(n3 + 1).toUpperCase();
                    if (string2.startsWith("?=")) {
                        n3 += 2;
                    } else if (string2.startsWith("CALL")) {
                        n3 += 4;
                    } else if (string2.startsWith("ESCAPE")) {
                        n3 += 6;
                    }
                    n = 3;
                    break;
                }
                case 1: 
                case 5: {
                    if (c != '\'') break;
                    --n;
                    break;
                }
                case 2: 
                case 6: {
                    if (c != '\"') break;
                    n -= 2;
                    break;
                }
                case 3: {
                    if (c == ' ') {
                        n = 4;
                        break;
                    }
                    cArray[n3] = 32;
                    bl = true;
                    break;
                }
                case 4: {
                    if (c == '\'') {
                        n = 5;
                        break;
                    }
                    if (c == '\"') {
                        n = 6;
                        break;
                    }
                    if (c != '}') break;
                    cArray[n3] = 32;
                    bl = true;
                    n = 0;
                }
            }
            ++n3;
        }
        if (bl) {
            string = new String(cArray);
        }
        return string;
    }

    abstract void openConnection(String var1, String var2) throws SQLException;

    public CallableStatement prepareCall(String string) {
        this.trace("prepareCall: [" + string + "]");
        if (this.bClosed) {
            return null;
        }
        return new hCallableStatement(this, string);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.prepareCall(string);
    }

    public PreparedStatement prepareStatement(String string) {
        this.trace("prepareStatement: [" + string + "]");
        if (this.bClosed) {
            return null;
        }
        return new hPreparedStatement(this, string);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.prepareStatement(string);
    }

    public void rollback() throws SQLException {
        this.trace("rollback");
        this.execute("ROLLBACK");
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.trace("setAutoCommit: " + bl);
        this.bAutoCommit = bl;
        this.execute("SET AUTOCOMMIT " + (this.bAutoCommit ? "TRUE" : "FALSE"));
    }

    public void setCatalog(String string) {
        this.trace("setCatalog: " + string);
    }

    public void setReadOnly(boolean bl) {
        this.trace("setReadOnly: " + bl);
    }

    public void setTransactionIsolation(int n) {
        this.trace("setTransactionIsolation: " + n);
    }

    public void setTypeMap(Map map) throws SQLException {
        throw hError.error((int)21);
    }

    protected void trace(String string) {
        DriverManager.println("hSql.hConnection." + string);
    }

    abstract boolean usesLocalFiles();
}

