/*
 * Decompiled with CFR 0.152.
 */
package hSql;

import hSql.hChannel;
import hSql.hColumn;
import hSql.hCondition;
import hSql.hDatabase;
import hSql.hError;
import hSql.hProducer;
import hSql.hRecord;
import hSql.hResult;
import hSql.hTokenizer;
import java.sql.SQLException;
import java.util.Vector;

class hConditionParser {
    private hTokenizer tTokenizer;
    private hChannel cChannel;
    private hDatabase dDatabase;
    private hProducer[] pProducer;
    private int iProducer;
    private String sToken;
    private Vector cList;
    private hCondition[] cFormula;
    private hCondition cCondition;
    private hCondition[] cAnd;
    private int iToken;
    private static final int CONDITION = 1;
    private static final int OR = 2;
    private static final int AND = 3;
    private static final int OPEN = 4;
    private static final int CLOSE = 5;
    private static final int NOT = 6;
    private static final int END = 7;

    public hConditionParser(hDatabase hDatabase2, hTokenizer hTokenizer2, hChannel hChannel2, hProducer hProducer2) {
        this.pProducer = new hProducer[1];
        this.pProducer[0] = hProducer2;
        this.init(hDatabase2, hTokenizer2, hChannel2, this.pProducer);
    }

    public hConditionParser(hDatabase hDatabase2, hTokenizer hTokenizer2, hChannel hChannel2, hProducer[] hProducerArray) {
        this.init(hDatabase2, hTokenizer2, hChannel2, hProducerArray);
    }

    private int copy(int n) {
        if (n < 0) {
            return n;
        }
        hCondition hCondition2 = this.cFormula[n];
        switch (hCondition2.getCompareType()) {
            case 8: {
                return this.copy(n - 1);
            }
            case 9: 
            case 10: {
                n = this.copy(n - 1);
                return this.copy(n);
            }
        }
        return n - 1;
    }

    public Vector expandColumnList(Vector vector) throws SQLException {
        if (vector == null) {
            return null;
        }
        Vector<Object> vector2 = new Vector<Object>();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            String[] stringArray = (String[])vector.elementAt(n2);
            if (stringArray[3] != null && stringArray[1].equals("*")) {
                vector2.addElement(new Integer(0));
                vector2.addElement(stringArray[2]);
                vector2.addElement(new Integer(stringArray[3]));
            } else if (stringArray[3] == null && stringArray[1].equals("*")) {
                if (stringArray[2] != null) {
                    throw hError.error((int)1, (String)stringArray[2]);
                }
                n3 = -1;
                if (stringArray[0] != null) {
                    n3 = this.getProducer(stringArray[0]);
                }
                int n4 = 0;
                int n5 = 0;
                while (n5 < this.iProducer) {
                    int n6 = this.pProducer[n5].getColumnCount();
                    while (n6 > 0) {
                        if (n3 == -1 || n5 == n3) {
                            vector2.addElement(new Integer(n4));
                            vector2.addElement(null);
                            vector2.addElement(null);
                        }
                        ++n4;
                        --n6;
                    }
                    ++n5;
                }
            } else {
                n3 = this.getProducerColumn(stringArray[0], stringArray[1]);
                vector2.addElement(new Integer(n3));
                vector2.addElement(stringArray[2]);
                if (stringArray[3] != null) {
                    vector2.addElement(new Integer(stringArray[3]));
                } else {
                    vector2.addElement(null);
                }
            }
            ++n2;
        }
        return vector2;
    }

    private int getProducer(String string) throws SQLException {
        int n = 0;
        while (n < this.iProducer) {
            if (string.equals(this.pProducer[n].getName())) {
                return n;
            }
            ++n;
        }
        throw hError.error((int)3, (String)string);
    }

    private int getProducerByColumnNr(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.iProducer) {
            if ((n2 += this.pProducer[n3].getColumnCount()) > n) {
                return n3;
            }
            ++n3;
        }
        return 0;
    }

    public int getProducerColumn(String string, String string2) throws SQLException {
        if (string != null) {
            int n = this.getProducer(string);
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                n2 += this.pProducer[n3].getColumnCount();
                ++n3;
            }
            int n4 = this.pProducer[n].searchColumn(string2);
            if (n4 != -1) {
                return n2 + n4;
            }
        } else {
            int n = 0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < this.iProducer) {
                int n7 = this.pProducer[n6].searchColumn(string2);
                if (n7 == -1) {
                    if (n5 == 0) {
                        n += this.pProducer[n6].getColumnCount();
                    }
                } else {
                    ++n5;
                    n += n7;
                }
                ++n6;
            }
            if (n5 == 1) {
                return n;
            }
        }
        throw hError.error((int)7, (String)string2);
    }

    private void init(hDatabase hDatabase2, hTokenizer hTokenizer2, hChannel hChannel2, hProducer[] hProducerArray) {
        this.cChannel = hChannel2;
        this.tTokenizer = hTokenizer2;
        this.pProducer = hProducerArray;
        this.iProducer = hProducerArray.length;
        this.cList = new Vector();
        this.dDatabase = hDatabase2;
    }

    private void optimize() {
        int n = this.cList.size();
        this.cFormula = new hCondition[n];
        int n2 = 0;
        while (n2 < n) {
            this.cFormula[n2] = (hCondition)this.cList.elementAt(n2);
            ++n2;
        }
        this.cList.removeAllElements();
        this.optimize(n - 1);
        int n3 = this.cList.size();
        this.cAnd = new hCondition[n3];
        int n4 = 0;
        while (n4 < n3) {
            this.cAnd[n4] = (hCondition)this.cList.elementAt(n4);
            ++n4;
        }
        block2: while (true) {
            boolean bl = false;
            int n5 = 0;
            while (n5 < n) {
                if (this.cFormula[n5] == null) {
                    bl = true;
                }
                ++n5;
            }
            if (!bl) break;
            hCondition[] hConditionArray = new hCondition[n];
            int n6 = 0;
            int n7 = 0;
            while (n7 < n) {
                hCondition hCondition2 = this.cFormula[n7];
                if (hCondition2 != null) {
                    hConditionArray[n6++] = hCondition2;
                } else {
                    int n8 = 1;
                    ++n7;
                    while (n7 < n) {
                        hCondition2 = this.cFormula[n7];
                        if (hCondition2 == null) {
                            ++n8;
                        } else {
                            int n9 = hCondition2.getType();
                            if (n8 <= 2 && n9 == 9) break;
                            n8 = n9 == 8 ? --n8 : (n9 == 10 || n9 == 9 ? (n8 -= 2) : ++n8);
                        }
                        hConditionArray[n6++] = hCondition2;
                        ++n7;
                    }
                }
                ++n7;
            }
            n = n6;
            this.cFormula = new hCondition[n];
            int n10 = 0;
            while (true) {
                if (n10 >= n) continue block2;
                this.cFormula[n10] = hConditionArray[n10];
                ++n10;
            }
            break;
        }
    }

    private int optimize(int n) {
        if (n < 0) {
            return n;
        }
        hCondition hCondition2 = this.cFormula[n];
        int n2 = hCondition2.getCompareType();
        switch (hCondition2.getCompareType()) {
            case 8: {
                return this.copy(n - 1);
            }
            case 10: {
                n = this.copy(n - 1);
                return this.copy(n);
            }
            case 9: {
                n = this.optimize(n - 1);
                return this.optimize(n);
            }
        }
        this.cList.addElement(hCondition2);
        this.cFormula[n] = null;
        return n - 1;
    }

    public String parseCondition() throws SQLException {
        this.read();
        this.readOr();
        this.optimize();
        int n = this.cAnd.length;
        int n2 = 0;
        while (n2 < n) {
            hCondition hCondition2 = this.cAnd[n2];
            hCondition2.getProducer().addCondition(hCondition2);
            ++n2;
        }
        int n3 = this.cFormula.length;
        int n4 = 0;
        while (n4 < n3) {
            hCondition hCondition3 = this.cFormula[n4];
            hProducer hProducer2 = hCondition3.getProducer();
            if (hProducer2 != null && hProducer2 != this.pProducer[this.iProducer - 1]) {
                int n5 = this.getProducer(hProducer2.getName());
                int n6 = hCondition3.getColumn();
                int n7 = 0;
                while (n7 < n5) {
                    n6 += this.pProducer[n7].getColumnCount();
                    ++n7;
                }
                hCondition3.setColumn(n6);
            }
            ++n4;
        }
        this.pProducer[this.iProducer - 1].setConditionFormula(this.cFormula);
        return this.sToken;
    }

    private void read() throws SQLException {
        String string;
        this.sToken = this.tTokenizer.getString();
        if (this.sToken.equals(";")) {
            this.iToken = 7;
            return;
        }
        if (this.sToken.equals("")) {
            this.iToken = 7;
            return;
        }
        if (this.sToken.equals("AND")) {
            this.iToken = 3;
            return;
        }
        if (this.sToken.equals("OR")) {
            this.iToken = 2;
            return;
        }
        if (this.sToken.equals("(")) {
            this.iToken = 4;
            return;
        }
        if (this.sToken.equals(")")) {
            this.iToken = 5;
            return;
        }
        if (this.sToken.equals("NOT")) {
            this.iToken = 6;
            return;
        }
        if (!this.tTokenizer.wasName() && !this.tTokenizer.wasLongName()) {
            this.iToken = 7;
            return;
        }
        this.iToken = 1;
        String string2 = null;
        String string3 = this.sToken;
        if (this.tTokenizer.wasLongName()) {
            string2 = this.tTokenizer.getLongNameFirst();
            string3 = this.tTokenizer.getLongNameLast();
        }
        int n = this.getProducerColumn(string2, string3);
        int n2 = this.getProducerByColumnNr(n);
        int n3 = hCondition.getCompareType((String)this.tTokenizer.getString());
        if (n3 == 11) {
            String string4;
            Vector<String> vector;
            block23: {
                this.tTokenizer.getThis("(");
                vector = new Vector<String>();
                this.sToken = this.tTokenizer.getString();
                if (this.tTokenizer.wasName() && this.sToken.equals("SELECT")) {
                    string4 = this.dDatabase.processSelect(this.tTokenizer, this.cChannel);
                    this.tTokenizer.getThis(")");
                    hError.check((string4.getColumnCount() == 1 ? 1 : 0) != 0, (int)31);
                    hRecord hRecord2 = ((hResult)string4).rRoot;
                    while (hRecord2 != null) {
                        vector.addElement(hColumn.convertObject((Object)hRecord2.data[0]));
                        hRecord2 = hRecord2.next;
                    }
                } else {
                    this.tTokenizer.back();
                    do {
                        string4 = this.dDatabase.getValue(this.tTokenizer, this.cChannel);
                        vector.addElement(string4);
                        this.sToken = this.tTokenizer.getString();
                        if (this.sToken.equals(")")) break block23;
                    } while (this.sToken.equals(","));
                    throw hError.error((int)1, (String)this.sToken);
                }
            }
            string4 = this.pProducer[n2].getTable();
            int n4 = string4.getColumnNr(string3);
            this.cCondition = new hCondition(this.pProducer[n2], n4, n3, vector);
            return;
        }
        this.sToken = this.tTokenizer.getString();
        if (this.tTokenizer.wasLongName() || this.tTokenizer.wasName()) {
            int n5;
            int n6;
            string = null;
            String string5 = this.sToken;
            if (this.tTokenizer.wasLongName()) {
                string = this.tTokenizer.getLongNameFirst();
                string5 = this.tTokenizer.getLongNameLast();
            }
            if (n2 == (n6 = this.getProducerByColumnNr(n5 = this.getProducerColumn(string, string5)))) {
                throw hError.error((int)5, (String)string2);
            }
            if (n2 < n6) {
                n5 = n;
                n2 = n6;
                string3 = string5;
                n3 = hCondition.getSwapType((int)n3);
            }
            int n7 = this.pProducer[n2].getTable().getColumnNr(string3);
            this.cCondition = new hCondition(this.pProducer[n2], n7, n3, n5);
        } else {
            this.tTokenizer.back();
            this.sToken = this.dDatabase.getValue(this.tTokenizer, this.cChannel);
            string = this.pProducer[n2].getTable();
            int n8 = string.getColumnNr(string3);
            this.cCondition = new hCondition(this.pProducer[n2], n8, n3, this.sToken);
        }
        if (n3 == 7) {
            this.sToken = this.tTokenizer.getString();
            if (this.sToken.equals("ESCAPE")) {
                string = this.tTokenizer.getStringToken();
                if (string.length() != 1) {
                    throw hError.error((int)32, (String)string);
                }
                this.cCondition.setEscape(string.charAt(0));
            } else {
                this.tTokenizer.back();
            }
        }
    }

    private void readAnd() throws SQLException {
        this.readCondition();
        while (this.iToken == 3) {
            this.read();
            this.readCondition();
            this.cCondition = new hCondition(9);
            this.cList.addElement(this.cCondition);
        }
    }

    private void readCondition() throws SQLException {
        if (this.iToken == 6) {
            this.read();
            this.readCondition();
            this.cCondition = new hCondition(8);
            this.cList.addElement(this.cCondition);
            return;
        }
        if (this.iToken == 4) {
            this.read();
            this.readOr();
            if (this.iToken != 5) {
                throw hError.error((int)1, (String)this.sToken);
            }
            this.read();
            return;
        }
        if (this.iToken != 1) {
            throw hError.error((int)1, (String)this.sToken);
        }
        this.cList.addElement(this.cCondition);
        this.read();
    }

    private void readOr() throws SQLException {
        this.readAnd();
        while (this.iToken == 2) {
            this.read();
            this.readAnd();
            this.cCondition = new hCondition(10);
            this.cList.addElement(this.cCondition);
        }
    }
}

