/*
 * Decompiled with CFR 0.152.
 */
package hSql;

import hSql.hColumn;
import hSql.hError;
import hSql.hLike;
import hSql.hProducer;
import hSql.hTable;
import java.sql.SQLException;
import java.util.Vector;

class hCondition {
    public static final int EQUAL = 1;
    public static final int BIGGER_EQUAL = 0;
    public static final int BIGGER = 2;
    public static final int SMALLER = 4;
    public static final int SMALLER_EQUAL = 5;
    public static final int NOT_EQUAL = 6;
    public static final int LIKE = 7;
    public static final int NOT = 8;
    public static final int AND = 9;
    public static final int OR = 10;
    public static final int IN = 11;
    private Object oValue;
    private int iDataType;
    private int iJoinWith;
    private hProducer pProducer;
    private boolean bJoin;
    private int iCompareType;
    private hLike lLike;
    private int iColumn;
    private Vector vValues;

    public hCondition(int n) {
        this.iCompareType = n;
    }

    public hCondition(hProducer hProducer2, int n, int n2, int n3) throws SQLException {
        this.init(hProducer2, n, n2);
        this.bJoin = true;
        this.iJoinWith = n3;
    }

    public hCondition(hProducer hProducer2, int n, int n2, String string) throws SQLException {
        this.init(hProducer2, n, n2);
        this.oValue = hColumn.convertString((String)string, (int)this.iDataType);
        if (this.iCompareType == 7) {
            this.lLike = new hLike(string);
        }
    }

    public hCondition(hProducer hProducer2, int n, int n2, Vector vector) throws SQLException {
        this.init(hProducer2, n, n2);
        hError.assert((n2 == 11 ? 1 : 0) != 0, (String)"hCondition,Vector");
        this.vValues = new Vector();
        int n3 = 0;
        while (n3 < vector.size()) {
            String string = (String)vector.elementAt(n3);
            this.vValues.addElement(hColumn.convertString((String)string, (int)this.iDataType));
            ++n3;
        }
    }

    public int getColumn() {
        return this.iColumn;
    }

    public int getCompareType() {
        return this.iCompareType;
    }

    public static int getCompareType(String string) throws SQLException {
        if (string.equals("=")) {
            return 1;
        }
        if (string.equals("IS")) {
            return 1;
        }
        if (string.equals(">=")) {
            return 0;
        }
        if (string.equals(">")) {
            return 2;
        }
        if (string.equals("<")) {
            return 4;
        }
        if (string.equals("<=")) {
            return 5;
        }
        if (string.equals("!=")) {
            return 6;
        }
        if (string.equals("<>")) {
            return 6;
        }
        if (string.equals("LIKE")) {
            return 7;
        }
        if (string.equals("IN")) {
            return 11;
        }
        throw hError.error((int)0, (String)string);
    }

    public int getJoinWith() {
        return this.iJoinWith;
    }

    public hProducer getProducer() {
        return this.pProducer;
    }

    public static int getSwapType(int n) {
        switch (n) {
            case 0: {
                return 5;
            }
            case 2: {
                return 4;
            }
            case 5: {
                return 0;
            }
        }
        return n;
    }

    public int getType() {
        return this.iCompareType;
    }

    public Object getValue() {
        return this.oValue;
    }

    private void init(hProducer hProducer2, int n, int n2) throws SQLException {
        this.pProducer = hProducer2;
        hTable hTable2 = hProducer2.getTable();
        this.iColumn = n;
        this.iDataType = hTable2.getType(this.iColumn);
        this.iCompareType = n2;
    }

    public boolean isJoin() {
        return this.bJoin;
    }

    public void setColumn(int n) {
        this.iColumn = n;
    }

    public void setEscape(char c) {
        this.lLike = new hLike((String)this.oValue, c);
    }

    public void setJoinValue(Object object) throws SQLException {
        hError.assert((boolean)this.bJoin, (String)"setJoinValue");
        this.oValue = hColumn.convertObject((Object)object, (int)this.iDataType);
    }

    public boolean test(Object object) {
        switch (this.iCompareType) {
            case 7: {
                return this.lLike.compare(object);
            }
            case 11: {
                int n = 0;
                while (n < this.vValues.size()) {
                    if (hColumn.compare(this.vValues.elementAt(n), (Object)object, (int)this.iDataType) == 0) {
                        return true;
                    }
                    ++n;
                }
                return false;
            }
        }
        int n = hColumn.compare((Object)this.oValue, (Object)object, (int)this.iDataType);
        switch (this.iCompareType) {
            case 1: {
                return n == 0;
            }
            case 2: {
                return n < 0;
            }
            case 0: {
                return n <= 0;
            }
            case 5: {
                return n >= 0;
            }
            case 4: {
                return n > 0;
            }
            case 6: {
                return n != 0;
            }
        }
        return false;
    }

    public String trace() {
        String string = " type=" + this.iCompareType;
        string = this.bJoin ? String.valueOf(string) + " joinwith=" + this.iJoinWith : String.valueOf(string) + " value=" + this.oValue;
        string = String.valueOf(string) + " column=" + this.iColumn;
        return string;
    }
}

