/*
 * Decompiled with CFR 0.152.
 */
package org.hsql;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.hsql.ByteArray;
import org.hsql.Column;
import org.hsql.Record;
import org.hsql.Result;
import org.hsql.Trace;

public class jdbcResultSet
implements ResultSet,
ResultSetMetaData {
    private Result rResult;
    private Record nCurrent;
    private int iCurrentRow;
    private int iUpdateCount;
    private boolean bInit;
    private int iColumnCount;
    private boolean bWasNull;

    public boolean next() throws SQLException {
        this.bWasNull = false;
        if (this.rResult == null) {
            return false;
        }
        if (!this.bInit) {
            this.nCurrent = this.rResult.rRoot;
            this.bInit = true;
            this.iCurrentRow = 1;
        } else {
            if (this.nCurrent == null) {
                return false;
            }
            this.nCurrent = this.nCurrent.next;
            ++this.iCurrentRow;
        }
        if (this.nCurrent == null) {
            this.iCurrentRow = 0;
            return false;
        }
        return true;
    }

    public void close() {
        this.iUpdateCount = -1;
        this.rResult = null;
    }

    public boolean wasNull() {
        return this.bWasNull;
    }

    public int findColumn(String string) throws SQLException {
        int n = 0;
        while (n < this.iColumnCount) {
            if (string.equalsIgnoreCase(this.rResult.sLabel[n])) {
                return n + 1;
            }
            ++n;
        }
        throw Trace.error(27);
    }

    public String getString(int n) throws SQLException {
        this.checkColumn(--n);
        this.checkAvailable();
        Object object = this.nCurrent.data[n];
        this.checkNull(object);
        return object == null ? null : object.toString();
    }

    public boolean getBoolean(int n) throws SQLException {
        Object object;
        return (object = this.getColumnInType(--n, -7)) == null ? false : (Boolean)object;
    }

    public byte getByte(int n) throws SQLException {
        return (byte)this.getShort(n);
    }

    public short getShort(int n) throws SQLException {
        Object object;
        return (object = this.getColumnInType(--n, 5)) == null ? (short)0 : (Short)object;
    }

    public int getInt(int n) throws SQLException {
        Object object;
        return (object = this.getColumnInType(--n, 4)) == null ? 0 : (Integer)object;
    }

    public long getLong(int n) throws SQLException {
        Object object;
        return (object = this.getColumnInType(--n, -5)) == null ? 0L : (Long)object;
    }

    public float getFloat(int n) throws SQLException {
        Object object;
        return (object = this.getColumnInType(--n, 7)) == null ? 0.0f : ((Float)object).floatValue();
    }

    public double getDouble(int n) throws SQLException {
        Object object;
        return (object = this.getColumnInType(--n, 8)) == null ? 0.0 : (Double)object;
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return (BigDecimal)this.getColumnInType(--n, 3);
    }

    public byte[] getBytes(int n) throws SQLException {
        Object object;
        return (object = this.getColumnInType(--n, -2)) == null ? null : ((ByteArray)object).byteValue();
    }

    public Date getDate(int n) throws SQLException {
        return (Date)this.getColumnInType(--n, 91);
    }

    public Time getTime(int n) throws SQLException {
        return (Time)this.getColumnInType(--n, 92);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return (Timestamp)this.getColumnInType(--n, 93);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        return this.getUnicodeStream(n);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        return new ByteArrayInputStream(this.getBytes(n));
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        return new ByteArrayInputStream(this.getBytes(n));
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() {
        return null;
    }

    public void clearWarnings() {
    }

    public String getCursorName() throws SQLException {
        throw Trace.error(19);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this;
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public Object getObject(int n) throws SQLException {
        this.checkColumn(--n);
        this.checkAvailable();
        Object object = this.nCurrent.data[n];
        this.checkNull(object);
        if (object == null) {
            return null;
        }
        if (this.rResult.iType[n] == 1111) {
            object = ((ByteArray)object).deserialize();
        } else if (object instanceof ByteArray) {
            object = ((ByteArray)object).byteValue();
        }
        return object == null ? null : object;
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.getBigDecimal(n, 0);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public boolean isBeforeFirst() {
        return !this.bInit;
    }

    public boolean isAfterLast() {
        if (!this.bInit) {
            return false;
        }
        return this.nCurrent == null;
    }

    public boolean isFirst() {
        return this.iCurrentRow == 1;
    }

    public boolean isLast() throws SQLException {
        throw Trace.error(19);
    }

    public void beforeFirst() throws SQLException {
        throw Trace.error(19);
    }

    public void afterLast() throws SQLException {
        throw Trace.error(19);
    }

    public boolean first() throws SQLException {
        throw Trace.error(19);
    }

    public boolean last() throws SQLException {
        throw Trace.error(19);
    }

    public int getRow() {
        return this.iCurrentRow;
    }

    public boolean absolute(int n) throws SQLException {
        throw Trace.error(19);
    }

    /*
     * Unable to fully structure code
     */
    public boolean relative(int var1_1) throws SQLException {
        if (var1_1 >= 0) ** GOTO lbl5
        throw Trace.error(19);
lbl-1000:
        // 1 sources

        {
            this.next();
lbl5:
            // 2 sources

            ** while (var1_1-- > 0)
        }
lbl6:
        // 1 sources

        return this.nCurrent != null;
    }

    public boolean previous() throws SQLException {
        throw Trace.error(19);
    }

    public void setFetchDirection(int n) throws SQLException {
        if (n != 1000) {
            throw Trace.error(19);
        }
    }

    public int getFetchDirection() {
        return 1000;
    }

    public void setFetchSize(int n) throws SQLException {
    }

    public int getFetchSize() {
        return 1;
    }

    public int getType() {
        return 1003;
    }

    public int getConcurrency() {
        return 1007;
    }

    public boolean rowUpdated() {
        return false;
    }

    public boolean rowInserted() {
        return false;
    }

    public boolean rowDeleted() {
        return false;
    }

    public void updateNull(int n) throws SQLException {
        throw Trace.error(19);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw Trace.error(19);
    }

    public void updateByte(int n, byte by) throws SQLException {
        throw Trace.error(19);
    }

    public void updateShort(int n, short s) throws SQLException {
        throw Trace.error(19);
    }

    public void updateInt(int n, int n2) throws SQLException {
        throw Trace.error(19);
    }

    public void updateLong(int n, long l) throws SQLException {
        throw Trace.error(19);
    }

    public void updateFloat(int n, float f) throws SQLException {
        throw Trace.error(19);
    }

    public void updateDouble(int n, double d) throws SQLException {
        throw Trace.error(19);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw Trace.error(19);
    }

    public void updateString(int n, String string) throws SQLException {
        throw Trace.error(19);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw Trace.error(19);
    }

    public void updateDate(int n, Date date) throws SQLException {
        throw Trace.error(19);
    }

    public void updateTime(int n, Time time) throws SQLException {
        throw Trace.error(19);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw Trace.error(19);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw Trace.error(19);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw Trace.error(19);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw Trace.error(19);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw Trace.error(19);
    }

    public void updateObject(int n, Object object) throws SQLException {
        throw Trace.error(19);
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void insertRow() throws SQLException {
        throw Trace.error(19);
    }

    public void updateRow() throws SQLException {
        throw Trace.error(19);
    }

    public void deleteRow() throws SQLException {
        throw Trace.error(19);
    }

    public void refreshRow() throws SQLException {
    }

    public void cancelRowUpdates() throws SQLException {
    }

    public void moveToInsertRow() throws SQLException {
        throw Trace.error(19);
    }

    public void moveToCurrentRow() throws SQLException {
    }

    public Statement getStatement() throws SQLException {
        return null;
    }

    public Object getObject(int n, Map map) throws SQLException {
        return this.getObject(n);
    }

    public Ref getRef(int n) throws SQLException {
        throw Trace.error(19);
    }

    public Blob getBlob(int n) throws SQLException {
        throw Trace.error(19);
    }

    public Clob getClob(int n) throws SQLException {
        throw Trace.error(19);
    }

    public Array getArray(int n) throws SQLException {
        throw Trace.error(19);
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDate(n);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.getTime(n);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.getTimestamp(n);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public Reader getCharacterStream(int n) throws SQLException {
        throw Trace.error(19);
    }

    int getUpdateCount() {
        return this.iUpdateCount;
    }

    boolean isResult() {
        return this.rResult != null;
    }

    private void checkColumn(int n) throws SQLException {
        if (n < 0 || n >= this.iColumnCount) {
            Trace.error(27, n);
        }
    }

    private void checkAvailable() throws SQLException {
        if (this.rResult == null || !this.bInit || this.nCurrent == null) {
            Trace.error(33);
        }
    }

    private Object getColumnInType(int n, int n2) throws SQLException {
        this.checkColumn(n);
        this.checkAvailable();
        int n3 = this.rResult.iType[n];
        Object object = this.nCurrent.data[n];
        this.checkNull(object);
        if (n2 == n3) {
            return object;
        }
        try {
            return Column.convertObject(object, n2);
        }
        catch (Exception exception) {
            String string = "type: " + Column.getType(n3) + " (" + n3 + ") expected: " + Column.getType(n2) + " value: " + object.toString();
            throw Trace.error(15, string);
        }
    }

    private void checkNull(Object object) {
        this.bWasNull = object == null;
    }

    public int getColumnCount() {
        return this.iColumnCount;
    }

    public boolean isAutoIncrement(int n) {
        return false;
    }

    public boolean isCaseSensitive(int n) {
        return true;
    }

    public boolean isSearchable(int n) {
        return true;
    }

    public boolean isCurrency(int n) {
        return false;
    }

    public int isNullable(int n) {
        return 1;
    }

    public boolean isSigned(int n) {
        return true;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        this.checkColumn(--n);
        return 0;
    }

    public String getColumnLabel(int n) throws SQLException {
        this.checkColumn(--n);
        return this.rResult.sLabel[n];
    }

    public String getColumnName(int n) throws SQLException {
        this.checkColumn(--n);
        return this.rResult.sName[n];
    }

    public String getSchemaName(int n) {
        return "";
    }

    public int getPrecision(int n) {
        return 0;
    }

    public int getScale(int n) {
        return 0;
    }

    public String getTableName(int n) throws SQLException {
        this.checkColumn(--n);
        return this.rResult.sTable[n];
    }

    public String getCatalogName(int n) {
        return "";
    }

    public int getColumnType(int n) throws SQLException {
        this.checkColumn(--n);
        return this.rResult.iType[n];
    }

    public String getColumnTypeName(int n) throws SQLException {
        this.checkColumn(--n);
        return Column.getType(this.rResult.iType[n]);
    }

    public boolean isReadOnly(int n) {
        return false;
    }

    public boolean isWritable(int n) {
        return true;
    }

    public boolean isDefinitelyWritable(int n) {
        return true;
    }

    public String getColumnClassName(int n) throws SQLException {
        throw Trace.error(19);
    }

    jdbcResultSet(Result result) throws SQLException {
        if (result.iMode == 0) {
            this.iUpdateCount = result.iUpdateCount;
        } else {
            if (result.iMode == 1) {
                throw Trace.getError(result.sError);
            }
            this.iUpdateCount = -1;
            this.rResult = result;
            this.iColumnCount = result.getColumnCount();
        }
        this.bWasNull = false;
    }
}

