#!/bin/bash

. ./.functions

START="`/bin/date --date="$4" +"%s"`"
END="`/bin/date --date="$5" +"%s"`"

#echo $4 $START
#echo $5 $END

MAX=MAX

MAX=MAX

color='#0000ff'
in=in
if [ "$2" = "out" ]; then
 in=out 
 color='#ff9900'
fi





SIZE="-h 150 -w 600"
if [ "$SMALL" = "1" ]; then
SIZE=
fi

DIR=`dirname $0`

cd $DIR

CONFIG=/ips/setup/.config

. $CONFIG

RRDTOOL=/usr/bin/rrdtool

STEP=60

if [ "$1" != ""  ]; then
      ALL="$1"
else
   ALL="$ALL all"
fi

SE=$7
if [ "$SE" != "" -a ! -d "$SE" ]; then
   mkdir "$SE"
fi

for I in $ALL; do

FILENAME=$I.rrd
PNG=h${in}.$I.$6.png

if [ "$SE" != "" -a -d "$SE" ]; then
PNG=$SE/$PNG
fi


if [ "$I" = "all" ]; then
 IP="$SUBNET"'*'
else
 IP="$SUBNET$I"
fi


MAP=$IP
if [ "$3" != "" ]; then
      MAP=$3
fi


echo -n "creating $PNG from $FILENAME ... "

if [ "$I" = "all" ]; then
  OGR="LINE2:mode#00ff00:`xlang _ALI`"
else
  OGR="LINE2:mode#ff0000:`xlang _LIM`"
fi

if [ 0 = 1 ]; then

$RRDTOOL graph $PNG --title=" "  --imgformat PNG  \
-M \
-v "`xlang _LOAD_KBS`" \
-b 1024 \
${SIZE} \
-s $START \
-e $END \
-u 2 -l 0 \
DEF:ave=$I.rrd:${in}_ave10:$MAX \
DEF:peek=$I.rrd:${in}_peek10:$MAX \
DEF:mode=$I.rrd:${in}_mode:$MAX \
LINE2:peek#ffff00:"`xlang _PEE`" \
AREA:ave${color}:"`xlang _AVE`" \
$OGR \

else

$RRDTOOL graph $PNG --title=" "  --imgformat PNG  \
-M \
-v "`xlang _LOAD_KBS`" \
-b 1024 \
${SIZE} \
-s $START \
-e $END \
-u 2 -l 0 \
DEF:ave=$I.rrd:${in}_ave10:$MAX \
DEF:peek=$I.rrd:${in}_peek10:$MAX \
DEF:mode=$I.rrd:${in}_mode:$MAX \
DEF:bytes=$I.rrd:${in}_bytes:AVERAGE \
VDEF:total=bytes,TOTAL \
LINE2:peek#ffff00:"`xlang _PEE`" \
AREA:ave${color}:"`xlang _AVE`" \
$OGR \
GPRINT:total:"`xlang _TOT` %.2lf %SB" \


fi


if [ $? = 0 ]; then
  echo done
else
  echo failed
fi

done

  
