#!/bin/bash

. ./.functions

MAX=MAX

# default
MINUTES=60

if [ "$3" != "" ]; then
MINUTES=$3
fi

color='#0000ff'
in=in
if [ "$2" = "out" ]; then
 in=out 
 color='#ff9900'
fi

if [ "$in" = "in"  ]; then
WHAT="`xlang _LOAD_IN`"
else
WHAT="`xlang _LOAD_OUT`"
fi


PERIOD="-6000"
if [ "$MINUTES" != "" ]; then
PERIOD=$[ MINUTES * -60 ]
fi

#SIZE="-h 150 -w 600"
SIZE=

DIR=`dirname $0`
cd $DIR

CONFIG=/ips/setup/.config

. $CONFIG

RRDTOOL=/usr/bin/rrdtool

STEP=60

if [ "$1" != ""  ]; then
      ALL="$1"
else
   ALL="$ALL all"
fi

SE=$5
if [ "$SE" != "" -a ! -d "$SE" ]; then
   mkdir "$SE"
fi


for I in $ALL; do

FILENAME=$I.rrd
PNG=${in}.$I.${MINUTES}.png

if [ "$SE" != "" -a -d "$SE" ]; then
PNG=$SE/$PNG
fi

if [ "$I" = "all" ]; then
 IP="$SUBNET"'*'
else
 IP="$SUBNET$I"
fi


MAP=$IP
if [ "$4" != "" ]; then
      MAP=$4
fi

echo -n "creating $PNG from $FILENAME ... "

if [ "$I" = "all" ]; then
  OGR="LINE2:mode#00ff00:`xlang _ALI`"
else
  OGR="LINE2:mode#ff0000:`xlang _LIM`"
fi

$RRDTOOL graph $PNG --title="$MAP"  --imgformat PNG  \
-M \
-v "`xlang _LOAD_KBS`" \
-b 1024 \
${SIZE} \
-s $PERIOD \
-u 2 -l 0 \
DEF:ave=$I.rrd:${in}_ave10:$MAX \
DEF:peek=$I.rrd:${in}_peek10:$MAX \
DEF:mode=$I.rrd:${in}_mode:$MAX \
LINE2:peek#ffff00:"`xlang _PEE`" \
AREA:ave${color}:"`xlang _AVE`" \
$OGR

if [ $? = 0 ]; then
  echo done
else
  echo failed
fi

done

 
