#!/bin/bash

. ./.functions

MAX=MAX

MINUTES=60

if [ "$3" != "" ]; then
MINUTES=$3
fi


color='#0000ff'
in=in
if [ "$2" = "out" ]; then
 in=out 
color='#ff9900'
fi

PERIOD="-6000"
if [ "$MINUTES" != "" ]; then
PERIOD=$[ MINUTES * -60 ]
#PER=$[ MINUTES * 60 ]
fi

SIZE="-h 150 -w 600"
if [ "$SMALL" = "1" ]; then
SIZE=
fi

DIR=`dirname $0`

cd $DIR

CONFIG=/ips/setup/.config

. $CONFIG

RRDTOOL=/usr/bin/rrdtool

STEP=60

if [ "$1" != ""  ]; then
      ALL="$1"
else
   ALL="$ALL all"
fi

SE=$5
if [ "$SE" != "" -a ! -d "$SE" ]; then
   mkdir "$SE"
fi


for I in $ALL; do

FILENAME=$I.rrd
PNG=${in}.$I.${MINUTES}.png

if [ "$SE" != "" -a -d "$SE" ]; then
PNG=$SE/$PNG
fi



if [ "$I" = "all" ]; then
 IP="$SUBNET"'*'
else
 IP="$SUBNET$I"
fi


MAP=$IP
if [ "$4" != "" ]; then
      MAP=$4
fi

echo -n "creating $PNG from $FILENAME ... "

if [ "$I" = "all" ]; then
  OGR="LINE2:mode#00ff00:`xlang _ALI`"
else
  OGR="LINE2:mode#ff0000:`xlang _LIM`"
fi


if [ 0 = 1 ]; then

$RRDTOOL graph $PNG --title=" "  --imgformat PNG  \
-M \
-v "`xlang _LOAD_KBS`" \
-b 1024 \
${SIZE} \
-s $PERIOD \
-u 2 -l 0 \
DEF:ave=$I.rrd:${in}_ave10:$MAX \
DEF:peek=$I.rrd:${in}_peek10:$MAX \
DEF:mode=$I.rrd:${in}_mode:$MAX \
LINE2:peek#ffff00:"`xlang _PEE`" \
AREA:ave${color}:"`xlang _AVE`" \
$OGR \

#GPRINT:bytes:AVERAGE:"total %.2lf %SB" \

else


$RRDTOOL graph $PNG --title=" "  --imgformat PNG  \
-M \
-v "`xlang _LOAD_KBS`" \
-b 1024 \
${SIZE} \
-s $PERIOD \
-u 2 -l 0 \
DEF:ave=$I.rrd:${in}_ave10:$MAX \
DEF:peek=$I.rrd:${in}_peek10:$MAX \
DEF:mode=$I.rrd:${in}_mode:$MAX \
DEF:bytes=$I.rrd:${in}_bytes:AVERAGE \
VDEF:total=bytes,TOTAL \
LINE2:peek#ffff00:"`xlang _PEE`" \
AREA:ave${color}:"`xlang _AVE`" \
$OGR \
GPRINT:total:"`xlang _TOT` %.2lf %SB" \


fi



if [ $? = 0 ]; then
  echo done
else
  echo failed
fi

done

  
