#!/bin/bash

. ./.functions

START="`/bin/date --date="$4" +"%s"`"
END="`/bin/date --date="$5" +"%s"`"

#echo $4 $START
#echo $5 $END

MAX=MAX

SIZE="-h 150 -w 600"
if [ "$SMALL" = "1" ]; then
SIZE=
fi


colorin='#0000ff'
colorout='#ff9900'

DIR=`dirname $0`

cd $DIR

CONFIG=/ips/setup/.config

. $CONFIG

RRDTOOL=/usr/bin/rrdtool

STEP=60

if [ "$1" != ""  ]; then
      ALL="$1"
else
   ALL="$ALL all"
fi

SE=$7
if [ "$SE" != "" -a ! -d "$SE" ]; then
   mkdir "$SE"
fi

for I in $ALL; do

FILENAME=$I.rrd
PNG=h.$I.$6.png

if [ "$SE" != "" -a -d "$SE" ]; then
PNG=$SE/$PNG
fi


if [ "$I" = "all" ]; then
 IP="$SUBNET"'*'
else
 IP="$SUBNET$I"
fi


echo -n "creating $PNG from $FILENAME ... "

MAP=$IP
if [ "$3" != "" ]; then
      MAP=$3
fi

$RRDTOOL graph $PNG --title=" "  --imgformat PNG  \
-M \
-v "`xlang _LOAD_KBS`" \
${SIZE} \
-s $START \
-e $END \
-u 2 -l 0 \
-b 1024 \
DEF:avein=$I.rrd:in_ave10:$MAX \
DEF:aveout=$I.rrd:out_ave10:$MAX \
CDEF:aveinout=avein,aveout,+ \
AREA:aveinout${colorout}:"`xlang _LOAD_AVOUT`" \
AREA:avein${colorin}:"`xlang _LOAD_AVIN`" \

if [ $? = 0 ]; then
  echo done
else
  echo failed
fi

done

  
