#!/bin/bash

. ./.functions

MINUTES=10

MINUTES=60

if [ "$3" != "" ]; then
MINUTES=$3
fi

PERIOD="-6000"
if [ "$MINUTES" != "" ]; then
PERIOD=$[ MINUTES * -60 ]
fi

MAX=MAX

SIZE="-h 150 -w 600"
if [ "$SMALL" = "1" ]; then
SIZE=
fi


colorin='#0000ff'
colorout='#ff9900'

DIR=`dirname $0`

cd $DIR

CONFIG=/ips/setup/.config

. $CONFIG

RRDTOOL=/usr/bin/rrdtool

STEP=60

if [ "$1" != ""  ]; then
      ALL="$1"
else
   ALL="$ALL all"
fi

SE=$5
if [ "$SE" != "" -a ! -d "$SE" ]; then
   mkdir "$SE"
fi


for I in $ALL; do

FILENAME=$I.rrd
PNG=$I.${MINUTES}.png

if [ "$SE" != "" -a -d "$SE" ]; then
PNG=$SE/$PNG
fi

if [ "$I" = "all" ]; then
 IP="$SUBNET"'*'
else
 IP="$SUBNET$I"
fi


echo -n "creating $PNG from $FILENAME ... "

MAP=$IP
if [ "$4" != "" ]; then
      MAP=$4
fi

$RRDTOOL graph $PNG --title=" "  --imgformat PNG  \
-M \
-v "`xlang _LOAD_KBS`" \
${SIZE} \
-s $PERIOD \
-u 2 -l 0 \
-b 1024 \
DEF:avein=$I.rrd:in_ave10:$MAX \
DEF:aveout=$I.rrd:out_ave10:$MAX \
CDEF:aveinout=avein,aveout,+ \
AREA:aveinout${colorout}:"`xlang _LOAD_AVOUT`" \
AREA:avein${colorin}:"`xlang _LOAD_AVIN`" 

if [ $? = 0 ]; then
  echo done
else
  echo failed
fi

done

  
