#!/bin/bash

. ./.functions


DIR=`dirname $0`

cd $DIR

CONFIG=/ips/setup/.config

. $CONFIG

RRDTOOL=/usr/bin/rrdtool


function a0 {

IALL=$1

STEP=1
HEARTBEAT=$[ STEP + STEP ]

# 1 secs in an hour
HOU1=3600
HOU2=600

for I in $IALL; do

if [ "$I" = "x55"  ]; then
  continue
fi 

FILENAME=a$I.rrd


# 
#peek, ave10, est, peek10, ave60, peek60, aqos->mode 

$RRDTOOL create $FILENAME --step $STEP \
DS:out_mode:GAUGE:${HEARTBEAT}:U:U \
DS:out_ave10:GAUGE:${HEARTBEAT}:0:U  \
DS:out_peek10:GAUGE:${HEARTBEAT}:0:U  \
DS:in_mode:GAUGE:${HEARTBEAT}:U:U \
DS:in_ave10:GAUGE:${HEARTBEAT}:0:U  \
DS:in_peek10:GAUGE:${HEARTBEAT}:0:U  \
DS:on_mode:GAUGE:${HEARTBEAT}:U:U \
RRA:MAX:0.5:1:${HOU1}  \
DS:out_bytes:ABSOLUTE:${HEARTBEAT}:0:U  \
DS:in_bytes:ABSOLUTE:${HEARTBEAT}:0:U  \
RRA:AVERAGE:0.5:6:${HOU2}  \


done

  
}


function a1 {

XLOG=/tmp/arrd

JALL=$1

while [ 0 ] ; do
 
BDATE=`date`
echo $BDATE 

echo -n > $XLOG 
echo -n  $BDATE ... > $XLOG-

for I in $JALL; do

#if [ -f /ips/ips/$I-n ]; then
#   continue
#fi

FILENAME=a$I.rrd

if [ ! -f $FILENAME ]; then

  a0 $I >> $XLOG 2>> $XLOG-

fi

values=`/ips/qos/arrd $I`

echo -n "updating $FILENAME with $values ... "

$RRDTOOL update $FILENAME ${values} >> $XLOG 2>> $XLOG-

if [ $? = 0 ]; then
   echo ok
else
   echo failed
fi

done

cat $XLOG 

EDATE=`date`
echo $EDATE 

echo " $EDATE" >> $XLOG-

break

done  

}



MAX=MAX

MINUTES=60

if [ "$3" != "" ]; then
MINUTES=$3
fi


color='#0000ff'
in=in
if [ "$2" = "out" ]; then
 in=out 
color='#ff9900'
fi

PERIOD="-6000"
if [ "$MINUTES" != "" ]; then
PERIOD=$[ MINUTES * -60 ]
#PER=$[ MINUTES * 60 ]
fi

SIZE="-h 150 -w 600"
if [ "$SMALL" = "1" ]; then
SIZE=
fi



if [ "$1" != ""  ]; then
      ALL="$1"
else
   ALL="$ALL all"
   exit
fi

   a1 $1 2> /tmp/a1- > /tmp/a1


SE=$5
if [ "$SE" != "" -a ! -d "$SE" ]; then
   mkdir "$SE"
fi


for I in $ALL; do

FILENAME=a$I.rrd
PNG=a.${in}.$I.${MINUTES}.png

if [ "$SE" != "" -a -d "$SE" ]; then
PNG=$SE/$PNG
fi



if [ "$I" = "all" ]; then
 IP="$SUBNET"'*'
else
 IP="$SUBNET$I"
fi


MAP=$IP
if [ "$4" != "" ]; then
      MAP=$4
fi

echo -n "creating $PNG from $FILENAME ... "

if [ "$I" = "all" ]; then
  OGR= 
else
  OGR="LINE2:mode#ff0000:`xlang _LIM`"
fi
  ON="LINE2:on#00ff00:`xlang _ALI`"


#echo
 $RRDTOOL graph $PNG --title=" "  --imgformat PNG  \
-M \
-v "`xlang _LOAD_KBS`" \
-b 1024 \
${SIZE} \
-s $PERIOD \
-u 2 -l 0 \
DEF:ave=a$I.rrd:${in}_ave10:$MAX \
DEF:peek=a$I.rrd:${in}_peek10:$MAX \
DEF:mode=a$I.rrd:${in}_mode:$MAX \
DEF:bytes=a$I.rrd:${in}_bytes:AVERAGE \
DEF:onmode=a$I.rrd:on_mode:$MAX \
VDEF:total=bytes,TOTAL \
LINE2:peek#ffff00:"`xlang _PEE`" \
AREA:ave${color}:"`xlang _AVE`" \
$OGR \
LINE2:onmode#00ff00:"`xlang _REJ `" \
GPRINT:total:"`xlang _TOT` %.2lf %SB" 


if [ $? = 0 ]; then
  echo done
else
  echo failed
fi

done

  
