#!/bin/bash

. /ips/setup/.version
if [ "$KERLOG" = "" ]; then
  KERLOG=kernel
fi


LPRED=`date +"%x"`
OLDLANG=$LANG
LANG=en
PRED=`date | cut -b5-10`
LANG=$OLDLANG
#echo $PRED ; exit

. ./.functions
export O3=1

export ISHTML=1
export SECS=60

DIR=`dirname $0`

cd $DIR

CONFIG=./config
. $CONFIG

DEV=$ANYDEV
if [ "$DEV" = "ppp+" ]; then
       DEV="ppp"
fi

export DSTIP=$2
export SRCIP=$3

################################################################################

INIP="${SUBNET}${ADR}"
if [ "$ANYIP" = "" ]; then
       ANYIP=`cat /ip2/IP1 2> /dev/null`
fi

ANYIPS=`cat /ip2/ANYIPS 2> /dev/null`
#echo $ANYIPS; exit

if [ "$SRCIP" = "$INIP" ]; then
     export SRCIP=$ANYIP
fi

if [ "$DSTIP" = "$INIP" ]; then
   export DSTIP=$ANYIP
fi

################################################################################

if [ "$DSTIP" = "$ANYIP" ]; then
   export DSTIPS="$ANYIPS"
fi

if [ "$SRCIP" = "$ANYIP" ]; then
     export SRCIPS="$ANYIPS"
fi

################################################################################

FROM=
TO=
if [ "$SRCIP" != "" ]; then

   ip=$SRCIP
   i=`echo $ip | cut -f4-4 -d "."`
   if [ "${SUBNET}$i" = "$ip" ]; then
 
     maybeali $i
     if [ "$ALIIP" != ""  ]; then
       SRCIP=$ALIIP
     fi
  
   fi

   FROM=" `xlang _FROM` $SRCIP"
fi
if [ "$DSTIP" != "" ]; then

   ip=$DSTIP
   i=`echo $ip | cut -f4-4 -d "."`
         
   if [ "${SUBNET}$i" = "$ip" ]; then
 
     maybeali $i
     if [ "$ALIIP" != ""  ]; then
       DSTIP=$ALIIP
     fi
  
   fi

   TO=" `xlang _TO` $DSTIP"
fi


TXT="in / out"
export DEVIN=
export DEVOUT=

OP=
# in
if [ "$1" = "-i" ]; then
      export DEVIN=$DEV
      TXT="`xlang _TRAF_IN`"
      OP=i
fi
# out
if [ "$1" = "-o" ]; then
      export DEVOUT=$DEV
      TXT="`xlang _TRAF_OUT`"
      OP=o
fi

D=`date  +"%Y.%m.%d"`
export DATE=$D

D=`date  +"%Y.%m.%d-%H"`
export DATEH=$D

LOG="/var/log/ips/$DATEH"
if [ ! -f $LOG ]; then
   LOG="/var/log/ips/$DATE"
fi
if [ ! -f $LOG ]; then
   LOG="/var/log/$KERLOG"
fi
if [ ! -f $LOG ]; then
   LOG="/var/log/messages"
fi

export START="$PRED `date +"%H:%M:%S" --date "1 minutes ago"`"
#export META=`date +"%H:%M:%S"`
export META="$PRED `date +"%H:%M:%S" --date "1 seconds ago"`"


#echo " `date +"${_DATE_TIME}"` - `xlang _MIN` ($START - $META) - <b>$TXT</b>$FROM$TO"  
echo " `date +"${_DATE_TIME}"` - `xlang _LAST_MIN` - <b>$TXT</b>$FROM$TO"  

OPT="-M"
if [ "$DSTIP" = "" -a "$SRCIP" = "" ]; then
OPT=-
OPT="-T"
fi


# not ip
if [ "$FQNAMES" = "1" ]; then
OP="${OP}N"
fi


#./qos2 $OPT$OP $LOG  2>  $0-
./qos2 $OPT$OP $LOG  2> /dev/null

if [ "$QOS_WHAT_LOG" = "1" ]; then
   echo "<br> $LOG"
fi  

  
