#!/bin/bash

. /ips/setup/.version
if [ "$KERLOG" = "" ]; then
  KERLOG=kernel
fi


. ./.functions
export O3=1

export ISHTML=1

# $6
if [ "$6" = "" ]; then
  ADATE=`date +"%Y-%m-%d"`
else
  ADATE="$6"
fi

# $4
if [ "$4" = "" ]; then
  START=`date +"%H:%M:%S" --date "10 minutes ago"`
else
  START="$4"
fi




# $5
if [ "$5" = "" ]; then
#  export META=`date +"%Y-%m-%d %H:%M:%S" --date "1 seconds ago"`
#  export META=`date +"%H:%M:%S" --date "1 seconds ago"`
   META=`date +"%H:%M:%S"`
else
   META="$5"
fi


# arithmetic
if [ "$7" = "-10" ]; then

   XDATE=`date  --date="$ADATE $START 10 minutes ago" +"%Y-%m-%d %H:%M:%S"`
   ADATE=`date  --date="$XDATE" +"%Y-%m-%d"`
   META=`date  --date="$META 10 minutes ago" +"%H:%M:%S"`
   START=`date  --date="$START 10 minutes ago" +"%H:%M:%S"`

   HM=`echo $META | cut -f1-1 -d ":"`
   HS=`echo $START | cut -f1-1 -d ":"`

   if [ "$HS" = "23" -a "$HM" = "00"  ]; then
      META="23:59:59"    
   fi


elif [ "$7" = "10" ]; then

   XDATE=`date  --date="$ADATE $META 10 minutes" +"%Y-%m-%d %H:%M:%S"`
   ADATE=`date  --date="$XDATE" +"%Y-%m-%d"`
   META=`date  --date="$META 10 minutes" +"%H:%M:%S"`
   START=`date  --date="$START 10 minutes" +"%H:%M:%S"`

   HM=`echo $META | cut -f1-1 -d ":"`
   HS=`echo $START | cut -f1-1 -d ":"`

   if [ "$HS" = "23" -a "$HM" = "00"  ]; then
      START="00:00:00"    
   fi

fi

META="$ADATE $META"
START="$ADATE $START"

SM=`date  --date="$META" +%s`
SS=`date  --date="$START" +%s`

#SECS=$[ SM - SS + 1 ]
SECS=$[ SM - SS ]

DSMETA=`date  --date="$META" +"%Y.%m.%d"`
DSTART=`date  --date="$START" +"%Y.%m.%d"`

DSTARTH=`date  --date="$START" +"%Y.%m.%d-%H"`

#EDSTART=`date  --date="$START"`
#echo $EDSTART; exit

OLDLANG=$LANG
LANG=en
PRED=`date --date="$START" | cut -b5-10`
LANG=$OLDLANG
#echo $PRED ; exit


META=`date  --date="$META" +"%H:%M:%S"`
START=`date  --date="$START" +"%H:%M:%S"`

export SECS META START

DIR=`dirname $0`

cd $DIR

CONFIG=./config
. $CONFIG

DEV=$ANYDEV
if [ "$DEV" = "ppp+" ]; then
       DEV="ppp"
fi

export DSTIP=$2
export SRCIP=$3

################################################################################

INIP="${SUBNET}${ADR}"
if [ "$ANYIP" = "" ]; then
       ANYIP=`cat /ip2/IP1 2> /dev/null`
fi

ANYIPS=`cat /ip2/ANYIPS 2> /dev/null`
#echo $ANYIPS; exit

if [ "$SRCIP" = "$INIP" ]; then
     export SRCIP=$ANYIP
fi

if [ "$DSTIP" = "$INIP" ]; then
   export DSTIP=$ANYIP
fi

################################################################################

if [ "$DSTIP" = "$ANYIP" ]; then
   export DSTIPS="$ANYIPS"
fi

if [ "$SRCIP" = "$ANYIP" ]; then
     export SRCIPS="$ANYIPS"
fi

################################################################################

################################################################################

FROM=
TO=
if [ "$SRCIP" != "" ]; then

   ip=$SRCIP
   i=`echo $ip | cut -f4-4 -d "."`
   if [ "${SUBNET}$i" = "$ip" ]; then
 
     maybeali $i
     if [ "$ALIIP" != ""  ]; then
       SRCIP=$ALIIP
     fi
  
   fi

   FROM=" `xlang _FROM` $SRCIP"
fi
if [ "$DSTIP" != "" ]; then

   ip=$DSTIP
   i=`echo $ip | cut -f4-4 -d "."`
         
   if [ "${SUBNET}$i" = "$ip" ]; then
 
     maybeali $i
     if [ "$ALIIP" != ""  ]; then
       DSTIP=$ALIIP
     fi
  
   fi

   TO=" `xlang _TO` $DSTIP"
fi


TXT="in / out"
export DEVIN=
export DEVOUT=

OP=
# in
if [ "$1" = "-i" ]; then
      export DEVIN=$DEV
      TXT="`xlang _TRAF_IN`"
      OP=i
fi
# out
if [ "$1" = "-o" ]; then
      export DEVOUT=$DEV
      TXT="`xlang _TRAF_OUT`"
      OP=o
fi

export DATE=$DSTART
export DATEH=$DSTARTH
# { 4.03.2008
DATEH2=
DMETAH=`date  --date="$META" +"%Y.%m.%d-%H"`
if [ "$DSTARTH" != "$DMETAH" ]; then
   DATEH2=$DMETAH
fi
# } 4.03.2008


YE=`echo $DATE | cut -f1-1 -d "."`
MO=`echo $DATE | cut -f2-2 -d "."`
DA=`echo $DATE | cut -f3-3 -d "."`

#YEAR

echo "<table valign=center align=center cellspacing=0 cellpadding=0 border=0><tr>"

echo "<td class=table11c align=center nowrap>"

echo "<br>&nbsp;&nbsp;&nbsp;<a href=\"javascript:go('-10')\"><img border=0 src=\"gi/gtk-go-back.gif\" title='`xlang _SHOW_PREV_10`'></a>"

echo "</td>"

echo "<td class=table11c align=center nowrap>"

echo "<br>&nbsp;&nbsp;&nbsp;<a href=\"javascript:go('10')\"><img border=0 src=\"gi/gtk-go-forward.gif\" title='`xlang _SHOW_NEXT_10`'></a>"

echo "</td>"


echo "<td width=15>"

echo "&nbsp;"

echo "</td>"


echo "<td class=table11c align=center nowrap>"
echo "`xlang _YYYY`<br>`xlang _DAY` <select class=table11 name=\"Year\"><option>$[YE - 1]</option><option selected>$YE</option></select>."
echo "</td>"

#MONTH

echo "<td class=table11c align=center nowrap>"
echo "`xlang _MM`<br><select class=table11 name=Month>"

for I in 01 02 03 04 05 06 07 08 09 10 11 12 ; do

  if [ $I = $MO ]; then
    echo "<option selected>"
  else    
    echo "<option>"
  fi    

  echo "$I</option>"

done
echo "</select>."
echo "</td>"

#DAY

echo "<td class=table11c align=center nowrap>"
echo "`xlang _DD`<br><select class=table11 name=Day>"

for I in 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 ; do

  if [ $I = $DA ]; then
    echo "<option selected>"
  else    
    echo "<option>"
  fi    

  echo "$I</option>"

done
echo "</select>"
echo "</td>"

echo "<td class=table11c width=10>"
echo "</td>"

#HOUR

echo "<td class=table11c align=right nowrap>"

echo "<br>"
echo "`xlang _SINCE` &nbsp; "

echo "<br>"
echo " `xlang _TILL` &nbsp; "

echo "</td>"

echo "<td class=table11c align=center nowrap>"

HO=`echo $START | cut -f1-1 -d ":"`
echo "`xlang _hh`<br>  <select class=table11 name=StartH>"

for I in 00 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20 21 22 23; do

  if [ $I = $HO ]; then
    echo "<option selected>"
  else    
    echo "<option>"
  fi    

  echo "$I</option>"

done
echo "</select>:"

echo "<br>"

HO=`echo $META | cut -f1-1 -d ":"`
echo "  <select class=table11 name=MetaH>"

for I in 00 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20 21 22 23; do

  if [ $I = $HO ]; then
    echo "<option selected>"
  else    
    echo "<option>"
  fi    

  echo "$I</option>"

done
echo "</select>:"

echo "</td>"

#MI

echo "<td class=table11c align=center nowrap>"

MI=`echo $START | cut -f2-2 -d ":"`
echo "`xlang _mm`<br><select class=table11 name=StartM>"

for I in 00 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 ; do

  if [ $I = $MI ]; then
    echo "<option selected>"
  else    
    echo "<option>"
  fi    

  echo "$I</option>"

done
echo "</select>:"

echo "<br>"

MI=`echo $META | cut -f2-2 -d ":"`
echo "<select class=table11 name=MetaM>"

for I in 00 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 ; do

  if [ $I = $MI ]; then
    echo "<option selected>"
  else    
    echo "<option>"
  fi    

  echo "$I</option>"

done
echo "</select>:"

echo "</td>"

echo "<td class=table11c align=center nowrap>"

SE=`echo $START | cut -f3-3 -d ":"`
echo "`xlang _ss`<br><select class=table11 name=StartS>"

for I in 00 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 ; do

  if [ $I = $SE ]; then
    echo "<option selected>"
  else    
    echo "<option>"
  fi    

  echo "$I</option>"

done
echo "</select>"


echo "<br>"

SE=`echo $META | cut -f3-3 -d ":"`
echo "<select class=table11 name=MetaS>"

for I in 00 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 ; do

  if [ $I = $SE ]; then
    echo "<option selected>"
  else    
    echo "<option>"
  fi    

  echo "$I</option>"

done
echo "</select>"

echo "</td>"

echo "<td class=table11c align=center nowrap>"

echo "<br>&nbsp;&nbsp;&nbsp;<a href=\"javascript:go()\"><img border=0 src=\"gi/gtk-refresh.gif\" title='`xlang _SHOW`'></a>"

echo "</td>"

echo "</tr></table>"

echo "<br>"

echo "`xlang _PER` `date --date=\"$YE-$MO-$DA\"   +\"${_DATE}\"` ($START - $META) - <b>$TXT</b>$FROM$TO"  



LOG="/var/log/ips/$DATEH"
if [ "$DATEH2" != "" ]; then
   LOG2="/var/log/ips/$DATEH2"
   if [ ! -f $LOG2 ]; then
      LOG2=
   fi
fi
if [ ! -f $LOG ]; then
   LOG="/var/log/ips/$DATE"
   LOG2=
fi
if [ ! -f $LOG ]; then
   LOG="/var/log/$KERLOG"
   LOG2=
fi
if [ ! -f $LOG ]; then
   LOG="/var/log/messages"
   LOG2=
fi

OPT="-M"
if [ "$DSTIP" = "" -a "$SRCIP" = "" ]; then
OPT=-
OPT=-T
fi


# not ip
if [ "$FQNAMES" = "1" ]; then
OP="${OP}N"
fi





export START="$PRED $START"
export META="$PRED $META"


#./qos2 $OPT$OP $LOG  2>  $0-
./qos2 $OPT$OP $LOG $LOG2 2> /dev/null

if [ "$QOS_WHAT_LOG" = "1" ]; then
   echo "<br> $LOG"
   if [ "$LOG2" != "" ]; then
     echo "<br> $LOG2"
   fi
fi  
  
