#!/bin/bash


function rule {

if [ "$DOIT" != "1" ]; then
    echo "dry run : $1"
    return 
fi

echo -n "executing : $1 ... "

$1 > /dev/null  2> /dev/null

if [ $? = 0 ]; then
  echo ok
else
  echo failed
fi


}

# one dir prefix
function onep {

  dir="/ips/$1"

  if [ "$2" != "" ]; then
     pre="$2-"
  else
     pre=
  fi          

  src=$dir/$pre$S
  dst=$dir/$pre$D

  if [ -f $src ]; then
     rule "cp -pv $src $dst"
  else      
     rule "rm -f $dst 2> /dev/null"
  fi

}



# one dir suffix
function ones {

  dir="/ips/$1"

  if [ "$2" = "+" ]; then
     suf="+"
  elif [ "$2" != "" ]; then
     suf="-$2"
  else
     suf=
  fi          

  src=$dir/$S$suf
  dst=$dir/$D$suf

  if [ -f $src ]; then
     rule "cp -pv $src $dst"
  else      
     rule "rm -f $dst 2> /dev/null"
  fi

}


if [ "$1" = "-d" -o  "$1" = "--doit" ]; then
   DOIT=1
  S=$2
  D=$3
else
  DOIT=
  S=$1
  D=$2
fi


if [ "$1" = "-h" -o  "$1" = "--help" -o "$S" = "" -o "$D" = "" ]; then
 
  echo "usage : $0 -h | --help"
  echo "usage : $0 [-d | --doit] src_computer_number dst_computer_number"
  exit 1
  
fi


ones ads 
ones ads2 

ones ali dev
ones ali ip

ones con.in 
ones con.in l
ones con.in u

ones con.out 
ones con.out l
ones con.out u

onep gro c
onep gro s

ones imq 

ones ind 

ones ips 
ones ips l 
ones ips n 
ones ips r 
ones ips w

ones lan

ones noa

ones pri

ones pts 
ones pts2 
ones pus 
ones pus2 

ones qos.in 
ones qos.in "+"

ones qos.out
ones qos.out "+"

ones soq 

exit 0





