#!/bin/bash

#  run hourly

DIR="/var/log"

cd $DIR

DI=/var/log/ips

. /ips/setup/.config
. /ips/setup/.version

if [ "$KERLOG" = "" ]; then
  KERLOG=kern
fi

if [ ! -d $DI ]; then
   echo creating $DI
   mkdir $DI
fi 

if [ ! -d $DI ]; then
   echo "problem with $DI"
   exit 1
fi 

cd $DI

if [ "$IPS_DAYS" != ""  ]; then
  echo "looking for old logs ..." 

  DATES=`date +"%Y.%m.%d"`

  X=0
  while [ 0 ]; do

    X=$[ X + 1 ] 
    E=$[ X >= IPS_DAYS ]
    
    if [ $E = 1 ]; then
       break
    fi

    DATE=`date --date=" $X days ago" +"%Y.%m.%d"`
    DATES="$DATES $DATE"

  done
  
  echo $DATES allowed

  for FH in 20*; do 

      F=`echo $FH | cut -f1-1 -d "-"` 
   
      ok=
      for D in $DATES ; do 

          if [ "$D" = "$F" ]; then
	     ok=1
	     break
	  fi
      done
      if [ "$ok" = "1" ]; then

         echo "$FH is ok"
      
      else
         echo -n "$FH too old, deleting ... "
         rm -f $FH ; echo done
         #echo failed
      
      fi
  
  done


fi


FILE=$DI/`date +"%Y.%m.%d-%H"`
#FILE=$DI/`date +"%Y.%m.%d"`


if [  -f $FILE ]; then
   echo "$FILE exists, ok"
   exit 0
fi

   echo creating $FILE
touch $FILE
if [ ! -f $FILE ]; then
   echo "problem with $FILE"
   exit 1
fi


# /etc/rc.d/rc.syslog stop


NG=
#NG=`ps ax |  grep syslog-ng | grep -v grep 2> /dev/null`
if [ -d /etc/syslog-ng ]; then
   NG=1
fi

if [ "$SYSLOG" = ""  ]; then
 SYSLOG=rc.syslog
fi

if [ "$SYSLOG_NG" = ""  ]; then
 SYSLOG_NG=rc.syslog-ng
fi


if [ "$NG" = "" ]; then
 /etc/rc.d/$SYSLOG stop
else
 /etc/rc.d/$SYSLOG_NG stop
fi

  rm -f -v /var/log/$KERLOG

 ln -v -s $FILE /var/log/$KERLOG

 sleep 1

if [ "$NG" = "" ]; then
 /etc/rc.d/$SYSLOG start
else
 /etc/rc.d/$SYSLOG_NG start
fi

