#!/bin/bash

#exit

DIR=`dirname $0`

cd $DIR


if [ "$1" != ""  ]; then
      ALL="$1"
else
   echo use $0 nr   e.g. $0 112
   exit
fi

RRDTOOL=/usr/bin/rrdtool

STEP=10
HEARTBEAT=$[ STEP + STEP ]

# 10 secs in one day
DAY1=8640
# not used

# minutes in a week 
WEEK6=10080
# 10 secs in a week 
WEEK6=60480


# 10 mins in 31 days
MONTH60=4464
# mins in 31 days
MONTH60=44640


#  hours in 366 days 
YEAR360=8784
#  10 mins in 366 days 
YEAR360=52704

#ALL=55

for I in $ALL; do

if [ "$I" = "x55"  ]; then
  continue
fi 

FILENAME=$I.rrd

echo -n "creating $FILENAME ... "

# 
#peek, ave10, est, peek10, ave60, peek60, aqos->mode 

$RRDTOOL create $FILENAME --step $STEP \
DS:out_mode:GAUGE:${HEARTBEAT}:U:U \
DS:out_ave10:GAUGE:${HEARTBEAT}:0:U  \
DS:out_peek10:GAUGE:${HEARTBEAT}:0:U  \
DS:in_mode:GAUGE:${HEARTBEAT}:U:U \
DS:in_ave10:GAUGE:${HEARTBEAT}:0:U  \
DS:in_peek10:GAUGE:${HEARTBEAT}:0:U  \
RRA:MAX:0.5:1:${WEEK6}  \
DS:out_bytes:ABSOLUTE:${HEARTBEAT}:0:U  \
DS:in_bytes:ABSOLUTE:${HEARTBEAT}:0:U  \
RRA:AVERAGE:0.5:6:${MONTH60}  \
RRA:AVERAGE:0.5:60:${YEAR360}  \
RRA:MAX:0.5:6:${MONTH60}  \
RRA:MAX:0.5:60:${YEAR360}  \

if [ $? = 0 ]; then
  echo done
else
  echo failed
fi

done

  
