/*
 * Decompiled with CFR 0.152.
 */
package es.jlg.crypt.gui.wizard;

import es.jlg.crypt.gui.CryptMain;
import es.jlg.crypt.utils.Messages;
import es.jlg.crypt.utils.PropertiesManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class MailAndCDataPage
extends WizardPage {
    private Text toDirText;
    private Text fromDirText;
    private Text subjectText;
    private Text mailLoginText;
    private Text mailPasswordText;
    private Text serverHostText;
    private Text portText;
    private Text loginText;
    private Text passwordText;
    private Text keyText;
    private Text keyValidationText;
    private Combo comboAlg;
    private Button buttonCBEncode;
    private ISelection selection;

    public MailAndCDataPage(ISelection selection) {
        super("wizardPage");
        this.setTitle(Messages.getString("MailDataPage.SendMail"));
        this.setDescription(Messages.getString("MailDataPage.IntroduceTextTS"));
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout(layout);
        layout.numColumns = 2;
        layout.verticalSpacing = 1;
        this.setMailData(container);
        this.createLine(container, layout.numColumns);
        this.setEncodeData(container, layout);
        this.setControl(container);
    }

    private void setEncodeData(Composite container, GridLayout layout) {
        Label label8 = new Label(container, 0);
        label8.setText(Messages.getString("MailDataPage.EncodeTE"));
        this.buttonCBEncode = new Button(container, 32);
        GridData gd = new GridData(768);
        this.buttonCBEncode.setLayoutData(gd);
        this.buttonCBEncode.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                if (MailAndCDataPage.this.buttonCBEncode.getSelection()) {
                    MailAndCDataPage.this.keyText.setEnabled(true);
                    MailAndCDataPage.this.keyValidationText.setEnabled(true);
                    MailAndCDataPage.this.comboAlg.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Label label9 = new Label(container, 0);
        label9.setText(Messages.getString("KeyPage.Key"));
        this.keyText = new Text(container, 0x400800);
        gd = new GridData(768);
        this.keyText.setLayoutData(gd);
        this.keyText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MailAndCDataPage.this.dialogChanged();
            }
        });
        Label label10 = new Label(container, 0);
        label10.setText(Messages.getString("KeyPage.KeyValidation"));
        this.keyValidationText = new Text(container, 0x400800);
        gd = new GridData(768);
        this.keyValidationText.setLayoutData(gd);
        this.keyValidationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MailAndCDataPage.this.dialogChanged();
            }
        });
        Label label11 = new Label(container, 0);
        label11.setText(Messages.getString("KeyPage.SelectAlgorithm"));
        this.comboAlg = new Combo(container, 4);
        this.comboAlg.add(Messages.getString("KeyPage.DES"));
        this.comboAlg.add(Messages.getString("KeyPage.Blowfish"));
        this.comboAlg.select(0);
        gd = new GridData(768);
        this.comboAlg.setLayoutData(gd);
        try {
            if (CryptMain.getUser() != null && PropertiesManager.getProperty("GeneralPrefPage.loginPassword").equals("true")) {
                this.keyText.setText(CryptMain.getUser().getPassword());
                this.keyValidationText.setText(CryptMain.getUser().getPassword());
            }
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.keyText.setEnabled(false);
        this.keyValidationText.setEnabled(false);
        this.comboAlg.setEnabled(false);
    }

    private void setMailServerData(Composite container) {
        Label label = new Label(container, 0);
        label.setText(Messages.getString("MailDataPage.ServerHost"));
        this.serverHostText = new Text(container, 2048);
        this.serverHostText.setEnabled(false);
        GridData gd = new GridData(768);
        this.serverHostText.setLayoutData(gd);
        this.serverHostText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MailAndCDataPage.this.dialogChanged();
            }
        });
        Label label5 = new Label(container, 0);
        label5.setText(Messages.getString("MailDataPage.Port"));
        this.portText = new Text(container, 2048);
        this.portText.setEnabled(false);
        gd = new GridData(768);
        this.portText.setLayoutData(gd);
        this.portText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MailAndCDataPage.this.dialogChanged();
            }
        });
    }

    private void setMailData(Composite container) {
        Label label2 = new Label(container, 0);
        label2.setText(Messages.getString("MailDataPage.ReceiverDirection"));
        this.toDirText = new Text(container, 2048);
        GridData gd = new GridData(768);
        this.toDirText.setLayoutData(gd);
        this.toDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MailAndCDataPage.this.dialogChanged();
            }
        });
        Label label3 = new Label(container, 0);
        label3.setText(Messages.getString("MailDataPage.SenderDirection"));
        this.fromDirText = new Text(container, 2048);
        gd = new GridData(768);
        this.fromDirText.setLayoutData(gd);
        this.fromDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MailAndCDataPage.this.dialogChanged();
            }
        });
        Label label4 = new Label(container, 0);
        label4.setText(Messages.getString("MailDataPage.Subjet"));
        this.subjectText = new Text(container, 2048);
        gd = new GridData(768);
        this.subjectText.setLayoutData(gd);
        this.subjectText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MailAndCDataPage.this.dialogChanged();
            }
        });
        Label label13 = new Label(container, 0);
        label13.setText(Messages.getString("MailAccounPage.login"));
        this.mailLoginText = new Text(container, 2048);
        gd = new GridData(768);
        this.mailLoginText.setLayoutData(gd);
        this.mailLoginText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MailAndCDataPage.this.dialogChanged();
            }
        });
        Label label12 = new Label(container, 0);
        label12.setText(Messages.getString("MailAccounPage.password"));
        this.mailPasswordText = new Text(container, 0x400800);
        gd = new GridData(768);
        this.mailPasswordText.setLayoutData(gd);
        this.mailPasswordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MailAndCDataPage.this.dialogChanged();
            }
        });
        try {
            this.toDirText.setText(PropertiesManager.getProperty("MailPrefPage.toDirection"));
            this.fromDirText.setText(PropertiesManager.getProperty("MailPrefPage.forDirection"));
            this.subjectText.setText(PropertiesManager.getProperty("MailPrefPage.subjet"));
            this.mailLoginText.setText(PropertiesManager.getProperty("MailAccounPage.login"));
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private void dialogChanged() {
        if (this.getToDirText().getText().length() == 0) {
            this.updateStatus(Messages.getString("MailDataPage.Error1"));
            return;
        }
        if (this.buttonCBEncode != null && this.buttonCBEncode.getSelection()) {
            if (this.getKeyText().getText().length() != 8) {
                this.updateStatus(Messages.getString("KeyPage.Error1"));
                return;
            }
            if (this.getKeyValidationText().getText().length() != 8) {
                this.updateStatus(Messages.getString("KeyPage.Error2"));
                return;
            }
            if (!this.getKeyValidationText().getText().trim().equals(this.getKeyText().getText().trim())) {
                this.updateStatus(Messages.getString("KeyPage.Error1"));
                return;
            }
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    private void createLine(Composite parent, int ncol) {
        Label line = new Label(parent, 259);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = ncol;
        line.setLayoutData(gridData);
    }

    public Text getFromDirText() {
        return this.fromDirText;
    }

    public void setFromDirText(Text fromDirText) {
        this.fromDirText = fromDirText;
    }

    public Text getServerHostText() {
        return this.serverHostText;
    }

    public void setServerHostText(Text serverHostText) {
        this.serverHostText = serverHostText;
    }

    public Text getToDirText() {
        return this.toDirText;
    }

    public void setToDirText(Text toDirText) {
        this.toDirText = toDirText;
    }

    public Text getSubjectText() {
        return this.subjectText;
    }

    public Text getLoginText() {
        return this.loginText;
    }

    public void setLoginText(Text loginText) {
        this.loginText = loginText;
    }

    public Text getPasswordText() {
        return this.passwordText;
    }

    public void setPasswordText(Text passwordText) {
        this.passwordText = passwordText;
    }

    public Text getPortText() {
        return this.portText;
    }

    public void setPortText(Text portText) {
        this.portText = portText;
    }

    public void setSubjectText(Text subjectText) {
        this.subjectText = subjectText;
    }

    public Button getButtonCBEncode() {
        return this.buttonCBEncode;
    }

    public void setButtonCBEncode(Button buttonCBEncode) {
        this.buttonCBEncode = buttonCBEncode;
    }

    public Combo getComboAlg() {
        return this.comboAlg;
    }

    public void setComboAlg(Combo comboAlg) {
        this.comboAlg = comboAlg;
    }

    public Text getKeyText() {
        return this.keyText;
    }

    public void setKeyText(Text keyText) {
        this.keyText = keyText;
    }

    public Text getMailPasswordText() {
        return this.mailPasswordText;
    }

    public void setMailPasswordText(Text mailPasswordText) {
        this.mailPasswordText = mailPasswordText;
    }

    public Text getKeyValidationText() {
        return this.keyValidationText;
    }

    public void setKeyValidationText(Text keyValidationText) {
        this.keyValidationText = keyValidationText;
    }
}

