/*
 * Decompiled with CFR 0.152.
 */
package es.jlg.crypt.gui.wizard;

import es.jlg.crypt.gui.CryptMain;
import es.jlg.crypt.gui.wizard.FileDataPage;
import es.jlg.crypt.utils.Messages;
import es.jlg.crypt.utils.PropertiesManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class KeyPage
extends WizardPage {
    private Text keyText;
    private Text keyValidationText;
    private Combo comboAlg;
    private Button buttonCBDeleteSource;
    private Button buttonCBzipFile;
    private Label labelZip;
    private boolean crypting;
    private ISelection selection;

    public KeyPage(ISelection selection, boolean crypting) {
        super("wizardPage");
        this.setTitle(Messages.getString("KeyPage.IntroduceKey"));
        this.setDescription(Messages.getString("KeyPage.IntroduceKey"));
        this.selection = selection;
        this.crypting = crypting;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout(layout);
        layout.numColumns = 2;
        layout.verticalSpacing = 1;
        Label label = new Label(container, 0);
        label.setText(Messages.getString("KeyPage.Key"));
        this.keyText = new Text(container, 0x400800);
        GridData gd = new GridData(768);
        this.keyText.setLayoutData(gd);
        this.keyText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                KeyPage.this.dialogChanged();
            }
        });
        Label label2 = new Label(container, 0);
        label2.setText(Messages.getString("KeyPage.KeyValidation"));
        this.keyValidationText = new Text(container, 0x400800);
        gd = new GridData(768);
        this.keyValidationText.setLayoutData(gd);
        this.keyValidationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                KeyPage.this.dialogChanged();
            }
        });
        this.createLine(container, layout.numColumns);
        Label label3 = new Label(container, 0);
        label3.setText(Messages.getString("KeyPage.SelectAlgorithm"));
        this.comboAlg = new Combo(container, 4);
        this.comboAlg.add(Messages.getString("KeyPage.DES"));
        this.comboAlg.add(Messages.getString("KeyPage.Blowfish"));
        this.comboAlg.select(0);
        gd = new GridData(768);
        this.comboAlg.setLayoutData(gd);
        try {
            if (CryptMain.getUser() != null && PropertiesManager.getProperty("GeneralPrefPage.loginPassword").equals("true")) {
                this.keyText.setText(CryptMain.getUser().getPassword());
                this.keyValidationText.setText(CryptMain.getUser().getPassword());
            }
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.setControl(container);
    }

    public void update() {
        if (this.buttonCBDeleteSource != null) {
            this.buttonCBDeleteSource.update();
        }
        if (((FileDataPage)this.getPreviousPage()).getUrlText().getText().indexOf(".zip.") == -1 && !this.crypting) {
            if (this.buttonCBzipFile != null) {
                this.buttonCBzipFile.setEnabled(false);
                this.buttonCBzipFile.setSelection(false);
            }
        } else if (this.buttonCBzipFile != null) {
            this.buttonCBzipFile.setEnabled(true);
        }
    }

    private void dialogChanged() {
        if (this.getKeyText().getText().length() != 8) {
            this.updateStatus(Messages.getString("KeyPage.Error1"));
            return;
        }
        if (this.getKeyValidationText().getText().length() != 8) {
            this.updateStatus(Messages.getString("KeyPage.Error2"));
            return;
        }
        if (!this.getKeyValidationText().getText().trim().equals(this.getKeyText().getText().trim())) {
            this.updateStatus(Messages.getString("KeyPage.Error1"));
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    private void createLine(Composite parent, int ncol) {
        Label line = new Label(parent, 259);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = ncol;
        line.setLayoutData(gridData);
    }

    public Text getKeyText() {
        return this.keyText;
    }

    public Text getKeyValidationText() {
        return this.keyValidationText;
    }

    public void setKeyValidationText(Text keyValidationText) {
        this.keyValidationText = keyValidationText;
    }

    public Combo getComboAlg() {
        return this.comboAlg;
    }

    public void setComboAlg(Combo comboAlg) {
        this.comboAlg = comboAlg;
    }

    public Button getButtonCBDeleteSource() {
        return this.buttonCBDeleteSource;
    }

    public void setButtonCBDeleteSource(Button buttonCBDeleteSource) {
        this.buttonCBDeleteSource = buttonCBDeleteSource;
    }

    public Button getButtonCBzipFile() {
        return this.buttonCBzipFile;
    }

    public void setButtonCBzipFile(Button buttonCBzipFile) {
        this.buttonCBzipFile = buttonCBzipFile;
    }
}

