/*
 * Decompiled with CFR 0.152.
 */
package es.jlg.crypt.gui.wizard;

import es.jlg.crypt.gui.menubar.SelectDirctoryAction;
import es.jlg.crypt.gui.menubar.SelectFileAction;
import es.jlg.crypt.gui.wizard.KeyPage;
import es.jlg.crypt.utils.Messages;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class FileDataPage
extends WizardPage {
    private Text urlText;
    private ISelection selection;
    private boolean isDirectory;

    public FileDataPage(ISelection selection, boolean isDirectory) {
        super("wizardPage");
        if (!isDirectory) {
            this.setTitle(Messages.getString("FileDataPage.SelectFile"));
            this.setDescription(Messages.getString("FileDataPage.SelectFile"));
        } else {
            this.setTitle(Messages.getString("FileDataPage.SelectDirectory"));
            this.setDescription(Messages.getString("FileDataPage.SelectDirectory"));
        }
        this.selection = selection;
        this.isDirectory = isDirectory;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout(layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 1;
        Label label = new Label(container, 0);
        if (!this.isDirectory) {
            label.setText(Messages.getString("FileDataPage.UrlFile"));
        } else {
            label.setText(Messages.getString("FileDataPage.UrlDirectory"));
        }
        this.urlText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.urlText.setLayoutData(gd);
        this.urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FileDataPage.this.dialogChanged();
            }
        });
        Button buttonFile = new Button(container, 0);
        if (!this.isDirectory) {
            buttonFile.setText(Messages.getString("FileDataPage.File"));
        } else {
            buttonFile.setText(Messages.getString("FileDataPage.Directory"));
        }
        gd = new GridData(768);
        buttonFile.setLayoutData(gd);
        buttonFile.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                if (!FileDataPage.this.isDirectory) {
                    SelectFileAction fileAction = new SelectFileAction();
                    FileDataPage.this.urlText.setText(fileAction.getFilePath());
                } else {
                    SelectDirctoryAction dirctoryAction = new SelectDirctoryAction();
                    FileDataPage.this.urlText.setText(dirctoryAction.getFilePath());
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.dialogChanged();
        this.setControl(container);
    }

    private void dialogChanged() {
        if (this.getUrlText().getText().length() == 0) {
            if (!this.isDirectory) {
                this.updateStatus(Messages.getString("FileDataPage.UrlToFileMustBeSpecified"));
            } else {
                this.updateStatus(Messages.getString("FileDataPage.UrlToDirectoryMustBeSpecified"));
            }
            return;
        }
        ((KeyPage)this.getNextPage()).update();
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    private void createLine(Composite parent, int ncol) {
        Label line = new Label(parent, 259);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = ncol;
        line.setLayoutData(gridData);
    }

    public Text getUrlText() {
        return this.urlText;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }
}

