/*
 * Decompiled with CFR 0.152.
 */
package es.jlg.crypt.gui.wizard;

import es.jlg.crypt.data.Operation;
import es.jlg.crypt.gui.CryptMain;
import es.jlg.crypt.gui.MessageWindow;
import es.jlg.crypt.gui.wizard.FileDataPage;
import es.jlg.crypt.gui.wizard.KeyPage;
import es.jlg.crypt.logic.BlowfishEncrypter;
import es.jlg.crypt.logic.DesEncrypter;
import es.jlg.crypt.utils.Messages;
import es.jlg.crypt.utils.Zipper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Date;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;

public class CWizard
extends Wizard {
    public static final String ENCODE_KIND = "E";
    public static final String ENCODE_EXTENSION = ".cp";
    private static final String ENCODE_TOOL_SUCCESSFUL_MESSAGE = Messages.getString("CWizard.EncodeSuccessful");
    private FileDataPage fileDataPage;
    private KeyPage keyPage;
    private ISelection selection;
    private boolean isRemoved = false;

    public CWizard() {
        this.setNeedsProgressMonitor(true);
        ImageDescriptor imageDesc = ImageDescriptor.createFromFile(null, "img/new_wiz.gif");
        this.setDefaultPageImageDescriptor(imageDesc);
        this.setWindowTitle(Messages.getString("EncrypFileAction.EncrypText"));
    }

    public void addPages() {
        if (this.fileDataPage == null) {
            this.fileDataPage = new FileDataPage(this.selection, false);
            this.addPage(this.fileDataPage);
        }
        if (this.keyPage == null) {
            this.keyPage = new KeyPage(this.selection, true);
            this.addPage(this.keyPage);
        }
    }

    public boolean performFinish() {
        try {
            SecretKeySpec desKey;
            String p = this.fileDataPage.getUrlText().getText();
            p = p.replace('\\', '/');
            p = this.zipOutputFile(p);
            FileInputStream fileInputStream = new FileInputStream(p);
            if (this.keyPage.getComboAlg().getText().equals("DES")) {
                desKey = new SecretKeySpec(this.keyPage.getKeyText().getText().getBytes(), this.keyPage.getComboAlg().getText());
                DesEncrypter encrypter = new DesEncrypter(desKey);
                encrypter.encrypt(fileInputStream, new FileOutputStream(String.valueOf(p) + ENCODE_EXTENSION));
            } else if (this.keyPage.getComboAlg().getText().equals("Blowfish")) {
                desKey = new SecretKeySpec(this.keyPage.getKeyText().getText().getBytes(), this.keyPage.getComboAlg().getText());
                BlowfishEncrypter encrypter = new BlowfishEncrypter(desKey);
                encrypter.encrypt(fileInputStream, new FileOutputStream(String.valueOf(p) + ENCODE_EXTENSION));
            }
            MessageWindow progressBarWindow = new MessageWindow(Messages.getString("MessageWindow.PleaseWait"));
            progressBarWindow.open();
            if (CryptMain.getUser() == null) {
                CryptMain.getOperationManager().store(Operation.valueOf(p, String.valueOf(p) + ENCODE_EXTENSION, ENCODE_KIND, this.keyPage.getComboAlg().getText(), new Date(), "---"));
            } else {
                CryptMain.getOperationManager().store(Operation.valueOf(p, String.valueOf(p) + ENCODE_EXTENSION, ENCODE_KIND, this.keyPage.getComboAlg().getText(), new Date(), CryptMain.getUser().getLogin()));
            }
            progressBarWindow.close();
            this.removeSourceFile(p);
            CryptMain.addTableItem(p, String.valueOf(p) + ENCODE_EXTENSION, ENCODE_KIND, this.keyPage.getComboAlg().getText(), new Date());
            CryptMain.setStatusMessage(ENCODE_TOOL_SUCCESSFUL_MESSAGE);
        }
        catch (FileNotFoundException e) {
            MessageDialog.openError(Display.getCurrent().getActiveShell(), Messages.getString("CWizard.Error"), e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            MessageDialog.openError(Display.getCurrent().getActiveShell(), Messages.getString("CWizard.Error"), e.getMessage());
            e.printStackTrace();
        }
        return true;
    }

    private String zipOutputFile(String p) {
        String outFileName = p;
        if (this.keyPage.getButtonCBzipFile().getSelection()) {
            outFileName = String.valueOf(outFileName) + ".zip";
            Zipper.zip(new String[]{p}, outFileName);
        }
        return outFileName;
    }

    private void removeSourceFile(String p) {
        if (this.keyPage.getButtonCBDeleteSource().getSelection()) {
            File inputFile = new File(p);
            if (!inputFile.delete()) {
                MessageDialog.openError(Display.getCurrent().getActiveShell(), Messages.getString("DWizard.ErrorDeleteFile"), String.valueOf(Messages.getString("DWizard.ErrorDeleteFile")) + ": " + p);
            }
            if (this.keyPage.getButtonCBzipFile().getSelection() && !this.isRemoved) {
                this.isRemoved = true;
                this.removeSourceFile(p.substring(0, p.length() - 4));
            }
        }
    }
}

