/*
 * Decompiled with CFR 0.152.
 */
package es.jlg.crypt.gui.wizard;

import com.sun.net.ssl.internal.ssl.Provider;
import es.jlg.crypt.data.Operation;
import es.jlg.crypt.gui.CryptMain;
import es.jlg.crypt.gui.MessageWindow;
import es.jlg.crypt.gui.wizard.FileDataPage;
import es.jlg.crypt.gui.wizard.KeyPage;
import es.jlg.crypt.gui.wizard.MailDataPage;
import es.jlg.crypt.logic.BlowfishEncrypter;
import es.jlg.crypt.logic.DesEncrypter;
import es.jlg.crypt.logic.MailSender;
import es.jlg.crypt.utils.Messages;
import es.jlg.crypt.utils.PropertiesManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Security;
import java.util.Date;
import javax.crypto.spec.SecretKeySpec;
import javax.mail.MessagingException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;

public class CAndMailWizard
extends Wizard {
    public static final String ENCODE_KIND = "E";
    public static final String ENCODE_EXTENSION = ".cp";
    private static final String ENCODE_TOOL_SUCCESSFUL_MESSAGE = Messages.getString("CWizard.EncodeSuccessful");
    private FileDataPage fileDataPage;
    private KeyPage keyPage;
    private MailDataPage dataPage;
    private ISelection selection;

    public CAndMailWizard() {
        this.setNeedsProgressMonitor(true);
        ImageDescriptor imageDesc = ImageDescriptor.createFromFile(null, "img/new_wiz.gif");
        this.setDefaultPageImageDescriptor(imageDesc);
        this.setWindowTitle(Messages.getString("EncrypFileAction.EncrypText"));
    }

    public void addPages() {
        if (this.fileDataPage == null) {
            this.fileDataPage = new FileDataPage(this.selection, false);
            this.addPage(this.fileDataPage);
        }
        if (this.keyPage == null) {
            this.keyPage = new KeyPage(this.selection, true);
            this.addPage(this.keyPage);
        }
        if (this.dataPage == null) {
            this.dataPage = new MailDataPage(this.selection);
            this.addPage(this.dataPage);
        }
    }

    public boolean performFinish() {
        try {
            SecretKeySpec desKey;
            String p = this.fileDataPage.getUrlText().getText();
            p = p.replace('\\', '/');
            if (this.keyPage.getComboAlg().getText().equals("DES")) {
                desKey = new SecretKeySpec(this.keyPage.getKeyText().getText().getBytes(), this.keyPage.getComboAlg().getText());
                DesEncrypter encrypter = new DesEncrypter(desKey);
                encrypter.encrypt(new FileInputStream(p), new FileOutputStream(String.valueOf(p) + ENCODE_EXTENSION));
            } else if (this.keyPage.getComboAlg().getText().equals("Blowfish")) {
                desKey = new SecretKeySpec(this.keyPage.getKeyText().getText().getBytes(), this.keyPage.getComboAlg().getText());
                BlowfishEncrypter encrypter = new BlowfishEncrypter(desKey);
                encrypter.encrypt(new FileInputStream(p), new FileOutputStream(String.valueOf(p) + ENCODE_EXTENSION));
            }
            MessageWindow progressBarWindow = new MessageWindow(Messages.getString("MessageWindow.PleaseWait"));
            progressBarWindow.open();
            if (CryptMain.getUser() == null) {
                CryptMain.getOperationManager().store(Operation.valueOf(String.valueOf(p) + " & Mail", String.valueOf(p) + ENCODE_EXTENSION, ENCODE_KIND, this.keyPage.getComboAlg().getText(), new Date(), "---"));
            } else {
                CryptMain.getOperationManager().store(Operation.valueOf(String.valueOf(p) + " & Mail", String.valueOf(p) + ENCODE_EXTENSION, ENCODE_KIND, this.keyPage.getComboAlg().getText(), new Date(), CryptMain.getUser().getLogin()));
            }
            progressBarWindow.close();
            this.removeSourceFile(p);
            if (CryptMain.getUser() != null) {
                CryptMain.loadData(CryptMain.getOperationManager().listOperations(CryptMain.getUser().getLogin()));
            }
            if (this.dataPage.getButtonCBSendMail().getSelection()) {
                this.sendMail(p);
            }
            CryptMain.addTableItem(p, String.valueOf(p) + ENCODE_EXTENSION, ENCODE_KIND, this.keyPage.getComboAlg().getText(), new Date());
            CryptMain.setStatusMessage(ENCODE_TOOL_SUCCESSFUL_MESSAGE);
        }
        catch (FileNotFoundException e) {
            MessageDialog.openError(Display.getCurrent().getActiveShell(), Messages.getString("CWizard.Error"), e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            MessageDialog.openError(Display.getCurrent().getActiveShell(), Messages.getString("CWizard.Error"), e.getMessage());
            e.printStackTrace();
        }
        return true;
    }

    private void sendMail(String p) {
        try {
            String host = PropertiesManager.getProperty("MailServerPrefPage.server");
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        String from = this.dataPage.getFromDirText().getText();
        String[] to = new String[]{this.dataPage.getToDirText().getText()};
        Security.addProvider((java.security.Provider)new Provider());
        try {
            MailSender.sendSSLMessage(to, this.dataPage.getSubjectText().getText(), String.valueOf(p) + ENCODE_EXTENSION, from, this.dataPage.getPasswordText().getText());
        }
        catch (MessagingException e) {
            MessageDialog.openError(Display.getCurrent().getActiveShell(), Messages.getString("MailWizard.Error"), e.getMessage());
            e.printStackTrace();
        }
    }

    private void removeSourceFile(String p) {
        File inputFile;
        if (this.keyPage.getButtonCBDeleteSource().getSelection() && !(inputFile = new File(p)).delete()) {
            MessageDialog.openError(Display.getCurrent().getActiveShell(), Messages.getString("DWizard.ErrorDeleteFile"), String.valueOf(Messages.getString("DWizard.ErrorDeleteFile")) + ": " + p);
        }
    }
}

