/*
 * Decompiled with CFR 0.152.
 */
package es.jlg.crypt.gui;

import es.jlg.crypt.data.Operation;
import es.jlg.crypt.data.User;
import es.jlg.crypt.gui.CryptMain;
import es.jlg.crypt.gui.FileWindow;
import es.jlg.crypt.gui.MessageWindow;
import es.jlg.crypt.logic.PasswordService;
import es.jlg.crypt.utils.Messages;
import es.jlg.crypt.utils.PropertiesManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LoginWindow
extends Dialog {
    private static final String LOGIN_OK = Messages.getString("LoginWindow.LoginOK");
    protected static final String LOGIN_ERROR = Messages.getString("LoginWindow.LonginError");
    private static LoginWindow app;
    private Text loginText;
    private Text passwordText;
    static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        logger = null;
    }

    public LoginWindow(Shell s) {
        super(s);
    }

    protected Control createContents(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString("LoginWindow.Login"));
        shell.setSize(165, 120);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout(layout);
        layout.numColumns = 2;
        layout.verticalSpacing = 3;
        Label labelIF = new Label(container, 0);
        labelIF.setText(Messages.getString("LoginWindow.Login"));
        this.loginText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.loginText.setLayoutData(gd);
        Label labelOF = new Label(container, 0);
        labelOF.setText(Messages.getString("LoginWindow.Password"));
        this.passwordText = new Text(container, 0x400800);
        gd = new GridData(768);
        this.passwordText.setLayoutData(gd);
        Button buttonLogin = new Button(container, 0);
        buttonLogin.setText(Messages.getString("LoginWindow.Login"));
        gd = new GridData(768);
        buttonLogin.setLayoutData(gd);
        buttonLogin.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                MessageWindow progressBarWindow = new MessageWindow(Messages.getString("MessageWindow.PleaseWait"));
                progressBarWindow.open();
                if (CryptMain.getUserManager().isUser(LoginWindow.this.loginText.getText(), PasswordService.getInstance().encrypt(LoginWindow.this.passwordText.getText()))) {
                    LoginWindow.getLogger().debug((Object)("The user: " + LoginWindow.this.loginText.getText() + " in the data base"));
                    CryptMain.setUser(User.valueOf(LoginWindow.this.loginText.getText(), LoginWindow.this.passwordText.getText()));
                    LoginWindow.this.getShell().close();
                    CryptMain.loadData(CryptMain.getOperationManager().listOperations(CryptMain.getUser().getLogin()));
                    CryptMain.setStatusMessage(LOGIN_OK);
                    LoginWindow.this.showAlarms();
                } else {
                    LoginWindow.this.passwordText.setText("");
                    CryptMain.setStatusMessage(LOGIN_ERROR);
                    LoginWindow.getLogger().debug((Object)("The user: " + LoginWindow.this.loginText.getText() + " in NOT on the data base"));
                }
                progressBarWindow.close();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Button buttonCreateUser = new Button(container, 0);
        buttonCreateUser.setText(Messages.getString("LoginWindow.CreateUser"));
        gd = new GridData(768);
        buttonCreateUser.setLayoutData(gd);
        buttonCreateUser.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                MessageWindow progressBarWindow = new MessageWindow(Messages.getString("MessageWindow.PleaseWait"));
                progressBarWindow.open();
                User user = User.valueOf(LoginWindow.this.loginText.getText(), PasswordService.getInstance().encrypt(LoginWindow.this.passwordText.getText()));
                CryptMain.getUserManager().store(user);
                CryptMain.setUser(User.valueOf(LoginWindow.this.loginText.getText(), PasswordService.getInstance().encrypt(LoginWindow.this.passwordText.getText())));
                LoginWindow.this.getShell().close();
                CryptMain.setStatusMessage(Messages.getString("LoginWindow.UserCreated"));
                progressBarWindow.close();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        return container;
    }

    public static void main(String[] args) {
        app.setBlockOnOpen(true);
        app.open();
        Display.getCurrent().dispose();
    }

    public static Logger getLogger() {
        if (logger == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("es.jlg.crypt.gui.LoginWindow");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger = Logger.getLogger((Class)clazz);
            PropertyConfigurator.configure((String)"log4j.cryptLog.properties");
        }
        return logger;
    }

    private void showAlarms() {
        List operations = null;
        operations = CryptMain.getOperationManager().listOperationsFor("", "", "Both", Messages.getString("FileWindow.alarm"), new Date(), CryptMain.getUser().getLogin());
        Iterator iter = operations.iterator();
        while (iter.hasNext()) {
            Operation element = (Operation)iter.next();
            try {
                if (element.getDate().compareTo(new Date(new Date().getTime() + 86400000L * Long.parseLong(PropertiesManager.getProperty("GeneralPrefPage.alarmTime")))) > 0 || element.getDate().compareTo(new Date(new Date().getTime())) <= 0) continue;
                FileWindow fileWindow = new FileWindow(element, false);
                fileWindow.open();
            }
            catch (NumberFormatException e1) {
                e1.printStackTrace();
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }
}

