/*
 * Decompiled with CFR 0.152.
 */
package org.vafada.swtcalendar;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.IdentityHashMap;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;
import org.vafada.swtcalendar.RepeatingButton;

public class Spinner
extends Composite
implements FocusListener {
    private static final int BUTTON_WIDTH = 16;
    private IdentityHashMap selectionListeners = new IdentityHashMap(3);
    private int minimum;
    private int maximum;
    private boolean cyclic;
    private NumberFormat numberFormat = new DecimalFormat("0");
    private boolean settingValue;
    private boolean inFocus;
    private Text text;
    private RepeatingButton upButton;
    private RepeatingButton downButton;

    public Spinner(Composite composite, int n) {
        super(composite, n);
        this.setFont(composite.getFont());
        this.minimum = 0;
        this.maximum = 9;
        this.setBackground(this.getDisplay().getSystemColor(1));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.text = new Text((Composite)this, 131072);
        this.text.setFont(this.getFont());
        GridData gridData = new GridData(768);
        this.text.setLayoutData((Object)gridData);
        this.text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent verifyEvent) {
                Spinner.this.verify(verifyEvent);
            }
        });
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                Spinner.this.traverse(traverseEvent);
            }
        });
        this.text.addFocusListener((FocusListener)this);
        gridData = new Composite((Composite)this, 524288);
        gridData.setFont(this.getFont());
        GridData gridData2 = new GridData(1296);
        gridData2.widthHint = 16;
        gridData.setLayoutData((Object)gridData2);
        gridData.setLayout((Layout)new FillLayout(512));
        this.upButton = new RepeatingButton((Composite)gridData, 17301636);
        this.upButton.setFont(this.getFont());
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Spinner.this.upInternal();
                Spinner.this.text.setFocus();
            }
        });
        this.downButton = new RepeatingButton((Composite)gridData, 17302532);
        this.downButton.setFont(this.getFont());
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Spinner.this.downInternal();
                Spinner.this.text.setFocus();
            }
        });
        this.setTabList(new Control[]{this.text});
        this.setValueInternal(this.minimum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void up() {
        this.settingValue = true;
        try {
            this.upInternal();
            Object var2_1 = null;
            this.settingValue = false;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.settingValue = false;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void down() {
        this.settingValue = true;
        try {
            this.downInternal();
            Object var2_1 = null;
            this.settingValue = false;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.settingValue = false;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(int n) {
        this.settingValue = true;
        try {
            this.setValueInternal(n);
            Object var3_2 = null;
            this.settingValue = false;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.settingValue = false;
            throw throwable;
        }
    }

    public int getValue() {
        try {
            return this.numberFormat.parse(this.text.getText()).intValue();
        }
        catch (ParseException parseException) {
            return this.minimum;
        }
    }

    public void setMaximum(int n) {
        this.maximum = n;
        this.setValue(this.getValue());
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMinimum(int n) {
        this.minimum = n;
        this.setValue(this.getValue());
    }

    public int getMinimum() {
        return this.minimum;
    }

    public boolean isCyclic() {
        return this.cyclic;
    }

    public void setCyclic(boolean bl) {
        this.cyclic = bl;
    }

    public void setRange(int n, int n2, boolean bl) {
        this.minimum = n;
        this.maximum = n2;
        this.cyclic = bl;
        this.setValueInternal(this.getValue());
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        int n = this.getValue();
        this.numberFormat = numberFormat;
        this.setValue(n);
    }

    public int getInitialRepeatDelay() {
        return this.upButton.getInitialRepeatDelay();
    }

    public void setInitialRepeatDelay(int n) {
        this.upButton.setInitialRepeatDelay(n);
        this.downButton.setInitialRepeatDelay(n);
    }

    public int getRepeatDelay() {
        return this.upButton.getRepeatDelay();
    }

    public void setRepeatDelay(int n) {
        this.upButton.setRepeatDelay(n);
        this.downButton.setRepeatDelay(n);
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.text != null) {
            this.text.setFont(font);
        }
    }

    public boolean isSettingValue() {
        return this.settingValue;
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.text.addModifyListener(modifyListener);
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.text.removeModifyListener(modifyListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        if (selectionListener == null) {
            throw new SWTError(4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)selectionListener);
        this.selectionListeners.put(selectionListener, typedListener);
        this.addListener(13, (Listener)typedListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        if (selectionListener == null) {
            throw new SWTError(4);
        }
        TypedListener typedListener = (TypedListener)this.selectionListeners.remove(selectionListener);
        if (typedListener != null) {
            this.removeListener(13, (Listener)typedListener);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        GC gC;
        if (n == -1) {
            gC = new GC((Drawable)this.text);
            n = Math.max(gC.textExtent((String)this.numberFormat.format((long)((long)this.maximum))).x, gC.textExtent((String)this.numberFormat.format((long)((long)this.maximum))).x);
            gC.dispose();
        }
        gC = this.text.computeSize(n, n2, bl);
        gC.x += 16;
        if ((this.getStyle() & 0x800) != 0) {
            int n3 = this.getBorderWidth();
            gC.x += n3 * 2;
            gC.y += n3 * 2 + 3;
        }
        gC.y = gC.y + 1 & 0xFFFFFFFE;
        return gC;
    }

    protected void upInternal() {
        int n = this.getValue();
        if (++n > this.maximum) {
            n = this.cyclic ? this.minimum : this.maximum;
        }
        this.setValueInternal(n);
        this.notifyListeners(13, new Event());
    }

    protected void downInternal() {
        int n = this.getValue();
        if (--n < this.minimum) {
            n = this.cyclic ? this.maximum : this.minimum;
        }
        this.setValueInternal(n);
        this.notifyListeners(13, new Event());
    }

    protected void setValueInternal(int n) {
        if (n < this.minimum) {
            n = this.minimum;
        } else if (n > this.maximum) {
            n = this.maximum;
        }
        String string = this.numberFormat.format(n);
        if (!string.equals(this.text.getText())) {
            this.text.setText(string);
        }
    }

    private void verify(VerifyEvent verifyEvent) {
        int n = 0;
        while (n < verifyEvent.text.length()) {
            char c = verifyEvent.text.charAt(n);
            if (!(Character.isDigit(c) || this.minimum < 0 && c == '-' && n == 0 && verifyEvent.start == 0 || this.numberFormat.format(this.minimum).indexOf(c) >= 0)) {
                verifyEvent.doit = false;
                break;
            }
            ++n;
        }
    }

    private void traverse(TraverseEvent traverseEvent) {
        switch (traverseEvent.detail) {
            case 32: {
                if (traverseEvent.keyCode != 0x1000001) break;
                traverseEvent.doit = true;
                traverseEvent.detail = 0;
                this.upInternal();
                break;
            }
            case 64: {
                if (traverseEvent.keyCode != 0x1000002) break;
                traverseEvent.doit = true;
                traverseEvent.detail = 0;
                this.downInternal();
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (!this.inFocus) {
            this.inFocus = true;
            Event event = new Event();
            event.time = focusEvent.time;
            this.notifyListeners(15, event);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!this.isFocusControl()) {
            this.inFocus = false;
            Event event = new Event();
            event.time = focusEvent.time;
            this.notifyListeners(16, event);
        }
    }

    public boolean isFocusControl() {
        Control control = this.getDisplay().getFocusControl();
        return control == this || control == this.text;
    }
}

