/*
 * Decompiled with CFR 0.152.
 */
package org.vafada.swtcalendar;

import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.vafada.swtcalendar.SWTDayChooser;

public class SWTMonthChooser
extends Composite {
    private SWTDayChooser dayChooser;
    private Combo comboBox;
    private Locale locale = Locale.getDefault();

    public SWTMonthChooser(Composite composite) {
        super(composite, 0);
        this.setLayout((Layout)new FillLayout());
        this.comboBox = new Combo((Composite)this, 12);
        this.initNames();
        this.setMonth(Calendar.getInstance().get(2));
        this.setFont(composite.getFont());
    }

    private void initNames() {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.locale);
        String[] stringArray = dateFormatSymbols.getMonths();
        int n = this.comboBox.getSelectionIndex();
        if (this.comboBox.getItemCount() > 0) {
            this.comboBox.removeAll();
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = stringArray[n2];
            if (string.length() > 0) {
                this.comboBox.add(string);
            }
            ++n2;
        }
        if (n < 0) {
            n = 0;
        } else if (n >= this.comboBox.getItemCount()) {
            n = this.comboBox.getItemCount() - 1;
        }
        this.comboBox.select(n);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.comboBox.addSelectionListener(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.comboBox.removeSelectionListener(selectionListener);
    }

    public void setMonth(int n) {
        this.comboBox.select(n);
    }

    public int getMonth() {
        return this.comboBox.getSelectionIndex();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.initNames();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.comboBox.setFont(this.getFont());
    }
}

