/*
 * Decompiled with CFR 0.152.
 */
package org.vafada.swtcalendar;

import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.vafada.swtcalendar.SWTCalendarEvent;
import org.vafada.swtcalendar.SWTCalendarListener;

public class SWTDayChooser
extends Composite
implements MouseListener,
FocusListener,
TraverseListener,
KeyListener {
    public static final int RED_SUNDAY = 0x1000000;
    public static final int RED_SATURDAY = 0x10000000;
    public static final int RED_WEEKEND = 0x11000000;
    private Label[] dayTitles;
    private DayControl[] days;
    private int dayOffset;
    private Color activeSelectionBackground;
    private Color inactiveSelectionBackground;
    private Color activeSelectionForeground;
    private Color inactiveSelectionForeground;
    private Color otherMonthColor;
    private Calendar calendar;
    private Calendar today;
    private Locale locale;
    private List listeners;
    private int style;

    public SWTDayChooser(Composite composite, int n) {
        super(composite, n & 0xEEFFFFFF);
        Composite composite2;
        this.style = n;
        this.listeners = new ArrayList(3);
        this.setBackground(this.getDisplay().getSystemColor(1));
        this.otherMonthColor = new Color((Device)this.getDisplay(), 128, 128, 128);
        this.activeSelectionBackground = this.getDisplay().getSystemColor(26);
        this.inactiveSelectionBackground = this.getDisplay().getSystemColor(15);
        this.activeSelectionForeground = this.getDisplay().getSystemColor(27);
        this.inactiveSelectionForeground = this.getForeground();
        this.locale = Locale.getDefault();
        GridLayout gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.numColumns = 7;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.dayTitles = new Label[7];
        int n2 = 0;
        while (n2 < this.dayTitles.length) {
            composite2 = new Label((Composite)this, 0x1000000);
            this.dayTitles[n2] = composite2;
            composite2.setLayoutData((Object)new GridData(256));
            composite2.addMouseListener((MouseListener)this);
            ++n2;
        }
        composite2 = new Composite((Composite)this, 524288);
        composite2.setBackground(this.getBackground());
        Object object = new GridData(768);
        object.heightHint = 2;
        object.horizontalSpan = 7;
        composite2.setLayoutData(object);
        composite2.setLayout((Layout)new GridLayout());
        composite2.addMouseListener((MouseListener)this);
        composite2 = new Label((Composite)this, 258);
        object = new GridData(768);
        object.horizontalSpan = 7;
        composite2.setLayoutData(object);
        this.days = new DayControl[42];
        int n3 = 0;
        while (n3 < this.days.length) {
            object = new DayControl(this);
            this.days[n3] = object;
            object.setLayoutData((Object)new GridData(272));
            object.addMouseListener((MouseListener)this);
            ++n3;
        }
        this.setTabList(new Control[0]);
        this.setFont(composite.getFont());
        this.init();
        this.addMouseListener(this);
        this.addFocusListener(this);
        this.addTraverseListener(this);
        this.addKeyListener(this);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                SWTDayChooser.this.otherMonthColor.dispose();
            }
        });
    }

    protected void init() {
        int n;
        this.calendar = Calendar.getInstance(this.locale);
        this.calendar.setLenient(true);
        this.today = (Calendar)this.calendar.clone();
        int n2 = this.calendar.getFirstDayOfWeek();
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.locale);
        String[] stringArray = dateFormatSymbols.getShortWeekdays();
        int n3 = Integer.MAX_VALUE;
        int n4 = 0;
        while (n4 < stringArray.length) {
            n = stringArray[n4].length();
            if (n > 0 && n < n3) {
                n3 = n;
            }
            ++n4;
        }
        if (n3 > 2) {
            n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].length() > 0) {
                    stringArray[n] = stringArray[n].substring(0, 1);
                }
                ++n;
            }
        }
        n = n2;
        int n5 = 0;
        while (n5 < this.dayTitles.length) {
            Label label = this.dayTitles[n5];
            label.setText(stringArray[n]);
            label.setBackground(this.getBackground());
            if (n == 1 && (this.style & 0x1000000) != 0 || n == 7 && (this.style & 0x10000000) != 0) {
                label.setForeground(this.getDisplay().getSystemColor(4));
            } else {
                label.setForeground(this.getForeground());
            }
            if (++n > this.dayTitles.length) {
                n -= this.dayTitles.length;
            }
            ++n5;
        }
        this.drawDays();
    }

    protected void drawDays() {
        this.calendar.get(6);
        Calendar calendar = (Calendar)this.calendar.clone();
        int n = calendar.getFirstDayOfWeek();
        calendar.set(5, 1);
        this.dayOffset = n - calendar.get(7);
        if (this.dayOffset >= 0) {
            this.dayOffset -= 7;
        }
        calendar.add(5, this.dayOffset);
        Color color = this.getForeground();
        int n2 = 0;
        while (n2 < this.days.length) {
            DayControl dayControl = this.days[n2++];
            dayControl.setText(Integer.toString(calendar.get(5)));
            if (SWTDayChooser.isSameDay(calendar, this.today)) {
                dayControl.setBorderColor(this.getDisplay().getSystemColor(2));
            } else {
                dayControl.setBorderColor(this.getBackground());
            }
            if (SWTDayChooser.isSameMonth(calendar, this.calendar)) {
                int n3 = calendar.get(7);
                if (n3 == 1 && (this.style & 0x1000000) != 0 || n3 == 7 && (this.style & 0x10000000) != 0) {
                    dayControl.setForeground(this.getDisplay().getSystemColor(4));
                } else {
                    dayControl.setForeground(color);
                }
            } else {
                dayControl.setForeground(this.otherMonthColor);
            }
            if (SWTDayChooser.isSameDay(calendar, this.calendar)) {
                dayControl.setBackground(this.getSelectionBackgroundColor());
                dayControl.setForeground(this.getSelectionForegroundColor());
            } else {
                dayControl.setBackground(this.getBackground());
            }
            calendar.add(5, 1);
        }
    }

    private static boolean isSameDay(Calendar calendar, Calendar calendar2) {
        return calendar.get(6) == calendar2.get(6) && calendar.get(1) == calendar2.get(1);
    }

    private static boolean isSameMonth(Calendar calendar, Calendar calendar2) {
        return calendar.get(2) == calendar2.get(2) && calendar.get(1) == calendar2.get(1);
    }

    public void setMonth(int n) {
        this.calendar.set(2, n);
        this.drawDays();
        this.dateChanged();
    }

    public void setYear(int n) {
        this.calendar.set(1, n);
        this.drawDays();
        this.dateChanged();
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = (Calendar)calendar.clone();
        this.calendar.setLenient(true);
        this.drawDays();
        this.dateChanged();
    }

    public void mouseDown(MouseEvent mouseEvent) {
        if (mouseEvent.button == 1) {
            this.setFocus();
            if (mouseEvent.widget instanceof DayControl) {
                int n = this.findDay(mouseEvent.widget);
                this.selectDay(n + 1 + this.dayOffset);
            }
        }
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
    }

    public void mouseUp(MouseEvent mouseEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        DayControl dayControl = this.getSelectedDayControl();
        dayControl.setBackground(this.getSelectionBackgroundColor());
        dayControl.setForeground(this.getSelectionForegroundColor());
    }

    public void focusLost(FocusEvent focusEvent) {
        DayControl dayControl = this.getSelectedDayControl();
        dayControl.setBackground(this.getSelectionBackgroundColor());
        dayControl.setForeground(this.getSelectionForegroundColor());
    }

    public void keyTraversed(TraverseEvent traverseEvent) {
        switch (traverseEvent.detail) {
            case 32: 
            case 64: 
            case 256: 
            case 512: {
                traverseEvent.doit = false;
                break;
            }
            case 8: 
            case 16: {
                traverseEvent.doit = true;
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.keyCode) {
            case 0x1000003: {
                this.selectDay(this.calendar.get(5) - 1);
                break;
            }
            case 0x1000004: {
                this.selectDay(this.calendar.get(5) + 1);
                break;
            }
            case 0x1000001: {
                this.selectDay(this.calendar.get(5) - 7);
                break;
            }
            case 0x1000002: {
                this.selectDay(this.calendar.get(5) + 7);
                break;
            }
            case 0x1000005: {
                this.setMonth(this.calendar.get(2) - 1);
                break;
            }
            case 0x1000006: {
                this.setMonth(this.calendar.get(2) + 1);
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    private int findDay(Widget widget) {
        int n = 0;
        while (n < this.days.length) {
            if (this.days[n] == widget) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void selectDay(int n) {
        this.calendar.get(6);
        if (n >= this.calendar.getActualMinimum(5) && n <= this.calendar.getActualMaximum(5)) {
            int n2 = this.calendar.get(7);
            DayControl dayControl = this.getSelectedDayControl();
            dayControl.setBackground(this.getBackground());
            if (n2 == 1) {
                dayControl.setForeground(this.getDisplay().getSystemColor(4));
            } else {
                dayControl.setForeground(this.getForeground());
            }
            this.calendar.set(5, n);
            dayControl = this.getSelectedDayControl();
            dayControl.setBackground(this.getSelectionBackgroundColor());
            dayControl.setForeground(this.getSelectionForegroundColor());
        } else {
            this.calendar.set(5, n);
            this.drawDays();
        }
        this.dateChanged();
    }

    private DayControl getSelectedDayControl() {
        return this.days[this.calendar.get(5) - 1 - this.dayOffset];
    }

    private Color getSelectionBackgroundColor() {
        return this.isFocusControl() ? this.activeSelectionBackground : this.inactiveSelectionBackground;
    }

    private Color getSelectionForegroundColor() {
        return this.isFocusControl() ? this.activeSelectionForeground : this.inactiveSelectionForeground;
    }

    public boolean isFocusControl() {
        Control control = this.getDisplay().getFocusControl();
        while (control != null) {
            if (control == this) {
                return true;
            }
            control = control.getParent();
        }
        return false;
    }

    public void addSWTCalendarListener(SWTCalendarListener sWTCalendarListener) {
        this.listeners.add(sWTCalendarListener);
    }

    public void removeSWTCalendarListener(SWTCalendarListener sWTCalendarListener) {
        this.listeners.remove(sWTCalendarListener);
    }

    private void dateChanged() {
        if (!this.listeners.isEmpty()) {
            SWTCalendarListener[] sWTCalendarListenerArray = new SWTCalendarListener[this.listeners.size()];
            this.listeners.toArray(sWTCalendarListenerArray);
            int n = 0;
            while (n < sWTCalendarListenerArray.length) {
                Event event = new Event();
                event.widget = this;
                event.display = this.getDisplay();
                event.time = (int)System.currentTimeMillis();
                event.data = this.calendar.clone();
                sWTCalendarListenerArray[n].dateChanged(new SWTCalendarEvent(event));
                ++n;
            }
        }
    }

    public Calendar getCalendar() {
        return (Calendar)this.calendar.clone();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.init();
    }

    public void setFont(Font font) {
        super.setFont(font);
        int n = 0;
        while (n < this.dayTitles.length) {
            this.dayTitles[n].setFont(font);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.days.length) {
            this.days[n2].setFont(font);
            ++n2;
        }
    }

    private static class DayLabel
    extends Label {
        public DayLabel(Composite composite, int n) {
            super(composite, n);
        }

        public Point computeSize(int n, int n2, boolean bl) {
            if (n == -1) {
                GC gC = new GC((Drawable)this);
                n = gC.textExtent((String)"22").x;
                gC.dispose();
            }
            return super.computeSize(n, n2, bl);
        }

        protected void checkSubclass() {
        }
    }

    private static class DayControl
    extends Composite
    implements Listener {
        private Composite filler;
        private Label label;

        public DayControl(Composite composite) {
            super(composite, 524288);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginWidth = 1;
            gridLayout.marginHeight = 1;
            this.setLayout((Layout)gridLayout);
            this.filler = new Composite((Composite)this, 524288);
            this.filler.setLayoutData((Object)new GridData(1808));
            gridLayout = new GridLayout();
            gridLayout.marginWidth = 2;
            gridLayout.marginHeight = 0;
            this.filler.setLayout((Layout)gridLayout);
            this.filler.addListener(3, (Listener)this);
            this.filler.addListener(4, (Listener)this);
            this.filler.addListener(8, (Listener)this);
            this.label = new DayLabel(this.filler, 655360);
            this.label.setLayoutData((Object)new GridData(576));
            this.label.addListener(3, (Listener)this);
            this.label.addListener(4, (Listener)this);
            this.label.addListener(8, (Listener)this);
            this.setBorderColor(composite.getBackground());
            this.setBackground(composite.getBackground());
            this.setFont(composite.getFont());
        }

        public void setText(String string) {
            this.label.setText(string);
        }

        public String getText() {
            return this.label.getText();
        }

        public void setFont(Font font) {
            super.setFont(font);
            this.filler.setFont(font);
            this.label.setFont(font);
        }

        public void setBackground(Color color) {
            this.filler.setBackground(color);
            this.label.setBackground(color);
        }

        public void setForeground(Color color) {
            this.label.setForeground(color);
        }

        public void setBorderColor(Color color) {
            super.setBackground(color);
        }

        public void handleEvent(Event event) {
            this.notifyListeners(event.type, event);
        }
    }
}

