/*
 * Decompiled with CFR 0.152.
 */
package org.vafada.swtcalendar;

import java.util.Calendar;
import java.util.Locale;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.vafada.swtcalendar.SWTCalendarEvent;
import org.vafada.swtcalendar.SWTCalendarListener;
import org.vafada.swtcalendar.SWTDayChooser;
import org.vafada.swtcalendar.SWTMonthChooser;
import org.vafada.swtcalendar.Spinner;

public class SWTCalendar
extends Composite {
    public static final int RED_SUNDAY = 0x1000000;
    public static final int RED_WEEKEND = 0x11000000;
    private boolean settingDate;
    private Spinner yearChooser;
    private SWTMonthChooser monthChooser;
    private SWTDayChooser dayChooser;
    private boolean settingYearMonth;

    public SWTCalendar(Composite composite, int n) {
        super(composite, n & 0xEE7FFFFF);
        Calendar calendar = Calendar.getInstance();
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 2;
        gridLayout.verticalSpacing = 2;
        this.setLayout((Layout)gridLayout);
        gridLayout = new Composite((Composite)this, 0);
        GridData gridData = new GridData(768);
        gridLayout.setLayoutData((Object)gridData);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 3;
        gridLayout2.marginWidth = 0;
        gridLayout2.marginHeight = 0;
        gridLayout.setLayout((Layout)gridLayout2);
        gridData = new Button((Composite)gridLayout, 0x1004004 | n & 0x800000);
        gridData.setLayoutData((Object)new GridData(16));
        gridData.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SWTCalendar.this.previousMonth();
            }
        });
        gridLayout2 = new Composite((Composite)gridLayout, 0);
        gridLayout2.setLayoutData((Object)new GridData(576));
        GridLayout gridLayout3 = new GridLayout();
        gridLayout3.numColumns = 2;
        gridLayout3.marginWidth = 0;
        gridLayout3.marginHeight = 0;
        gridLayout2.setLayout((Layout)gridLayout3);
        gridLayout.setTabList(new Control[]{gridLayout2});
        this.monthChooser = new SWTMonthChooser((Composite)gridLayout2);
        this.monthChooser.setLayoutData(new GridData(1040));
        this.monthChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!SWTCalendar.this.settingYearMonth) {
                    SWTCalendar.this.dayChooser.setMonth(SWTCalendar.this.monthChooser.getMonth());
                }
            }
        });
        this.yearChooser = new Spinner((Composite)gridLayout2, 2048);
        this.yearChooser.setLayoutData(new GridData(16));
        this.yearChooser.setMinimum(1);
        this.yearChooser.setMaximum(9999);
        this.yearChooser.setValue(calendar.get(1));
        this.yearChooser.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (!SWTCalendar.this.settingYearMonth) {
                    SWTCalendar.this.dayChooser.setYear(SWTCalendar.this.yearChooser.getValue());
                }
            }
        });
        gridLayout3 = new Button((Composite)gridLayout, 0x1020004 | n & 0x800000);
        gridLayout3.setLayoutData((Object)new GridData(16));
        gridLayout3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SWTCalendar.this.nextMonth();
            }
        });
        this.dayChooser = new SWTDayChooser(this, 0x800 | n & 0x11000000);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.dayChooser.setLayoutData(gridData);
        this.dayChooser.addSWTCalendarListener(new SWTCalendarListener(){

            public void dateChanged(SWTCalendarEvent sWTCalendarEvent) {
                SWTCalendar.this.refreshYearMonth(sWTCalendarEvent.getCalendar());
            }
        });
        this.setTabList(new Control[]{gridLayout, this.dayChooser});
        this.setFont(composite.getFont());
    }

    public SWTCalendar(Composite composite) {
        this(composite, 0x800000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCalendar(Calendar calendar) {
        this.settingDate = true;
        try {
            this.refreshYearMonth(calendar);
            this.dayChooser.setCalendar(calendar);
            Object var3_2 = null;
            this.settingDate = false;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.settingDate = false;
            throw throwable;
        }
    }

    private void refreshYearMonth(Calendar calendar) {
        this.settingYearMonth = true;
        this.yearChooser.setValue(calendar.get(1));
        this.monthChooser.setMonth(calendar.get(2));
        this.settingYearMonth = false;
    }

    public void nextMonth() {
        Calendar calendar = this.dayChooser.getCalendar();
        calendar.add(2, 1);
        this.refreshYearMonth(calendar);
        this.dayChooser.setCalendar(calendar);
    }

    public void previousMonth() {
        Calendar calendar = this.dayChooser.getCalendar();
        calendar.add(2, -1);
        this.refreshYearMonth(calendar);
        this.dayChooser.setCalendar(calendar);
    }

    public Calendar getCalendar() {
        return this.dayChooser.getCalendar();
    }

    public void addSWTCalendarListener(SWTCalendarListener sWTCalendarListener) {
        this.dayChooser.addSWTCalendarListener(sWTCalendarListener);
    }

    public void removeSWTCalendarListener(SWTCalendarListener sWTCalendarListener) {
        this.dayChooser.removeSWTCalendarListener(sWTCalendarListener);
    }

    public void setLocale(Locale locale) {
        this.monthChooser.setLocale(locale);
        this.dayChooser.setLocale(locale);
        this.yearChooser.setValue(this.getCalendar().get(1));
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.monthChooser.setFont(font);
        this.yearChooser.setFont(font);
        this.dayChooser.setFont(font);
    }

    public boolean isSettingDate() {
        return this.settingDate;
    }
}

