/*
 * Decompiled with CFR 0.152.
 */
package org.vafada.swtcalendar;

import java.util.ArrayList;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

public class RepeatingButton
extends Button {
    public static final int DEFAULT_INITIAL_REPEAT_DELAY = 200;
    public static final int DEFAULT_REPEAT_DELAY = 50;
    private int initialRepeatDelay = 200;
    private int repeatDelay = 50;
    private ArrayList selectionListeners = new ArrayList(3);
    private Repeater repeater;

    public RepeatingButton(Composite composite, int n) {
        super(composite, n);
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                RepeatingButton.this.cancelRepeater();
                if (mouseEvent.button == 1) {
                    RepeatingButton.this.buttonPressed(mouseEvent.stateMask, mouseEvent.time);
                    RepeatingButton.this.repeater = new Repeater(mouseEvent.stateMask);
                    RepeatingButton.this.getDisplay().timerExec(RepeatingButton.this.initialRepeatDelay, (Runnable)RepeatingButton.this.repeater);
                }
            }

            public void mouseUp(MouseEvent mouseEvent) {
                if (mouseEvent.button == 1) {
                    RepeatingButton.this.cancelRepeater();
                }
            }
        });
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent mouseEvent) {
                RepeatingButton.this.cancelRepeater();
            }
        });
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.selectionListeners.add(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.selectionListeners.remove(selectionListener);
    }

    public int getInitialRepeatDelay() {
        return this.initialRepeatDelay;
    }

    public void setInitialRepeatDelay(int n) {
        this.initialRepeatDelay = n;
    }

    public int getRepeatDelay() {
        return this.repeatDelay;
    }

    public void setRepeatDelay(int n) {
        this.repeatDelay = n;
    }

    private void buttonPressed(int n, int n2) {
        SelectionListener[] selectionListenerArray = new SelectionListener[this.selectionListeners.size()];
        this.selectionListeners.toArray(selectionListenerArray);
        int n3 = 0;
        while (n3 < selectionListenerArray.length) {
            SelectionListener selectionListener = selectionListenerArray[n3];
            Event event = new Event();
            event.type = 13;
            event.display = this.getDisplay();
            event.widget = this;
            event.stateMask = n;
            event.time = n2;
            selectionListener.widgetSelected(new SelectionEvent(event));
            ++n3;
        }
    }

    private void cancelRepeater() {
        if (this.repeater != null) {
            this.repeater.cancel();
            this.repeater = null;
        }
    }

    protected void checkSubclass() {
    }

    private class Repeater
    implements Runnable {
        private boolean canceled;
        private int stateMask;

        public Repeater(int n) {
            this.stateMask = n;
        }

        public void run() {
            if (!this.canceled) {
                RepeatingButton.this.buttonPressed(this.stateMask, (int)System.currentTimeMillis());
                RepeatingButton.this.getDisplay().timerExec(RepeatingButton.this.repeatDelay, (Runnable)this);
            }
        }

        public void cancel() {
            this.canceled = true;
        }
    }
}

