/*
 * Decompiled with CFR 0.152.
 */
package es.jlg.crypt.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Zipper {
    public static void zip(String[] filenames, String outFileName) {
        byte[] buf = new byte[1024];
        try {
            String outFilename = outFileName;
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outFilename));
            int i = 0;
            while (i < filenames.length) {
                int len;
                FileInputStream in = new FileInputStream(filenames[i]);
                out.putNextEntry(new ZipEntry(filenames[i]));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                in.close();
                ++i;
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void unzip(String inFilename) {
        try {
            ZipFile zf = new ZipFile(inFilename);
            ZipInputStream in = new ZipInputStream(new FileInputStream(inFilename));
            Enumeration<? extends ZipEntry> entries = zf.entries();
            Zipper.createDirectories(entries);
            entries = zf.entries();
            while (entries.hasMoreElements()) {
                int len;
                String outFilename = entries.nextElement().getName();
                ZipEntry entry = in.getNextEntry();
                FileOutputStream out = new FileOutputStream(outFilename);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((OutputStream)out).close();
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void createDirectories(Enumeration entries) {
        while (entries.hasMoreElements()) {
            ZipEntry entry = (ZipEntry)entries.nextElement();
            Zipper.createDir(entry.getName(), true);
        }
    }

    private static void createDir(String path, boolean first) {
        File file = new File(path);
        int lastIndex = path.lastIndexOf("\\");
        if (path.lastIndexOf("\\") > 0) {
            Zipper.createDir(path.substring(0, path.lastIndexOf("\\")), false);
        }
        if (!file.isDirectory() && !first) {
            file.mkdir();
        }
    }

    public static void zipADir(String inDirName) {
        try {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(String.valueOf(inDirName) + ".zip"));
            Zipper.zipDir(inDirName, zos);
            zos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String[] filenames = new String[]{"c:/EmailOnDeliveryLog.txt", "c:/EmailOnDeliveryLog.txt.cp"};
        Zipper.unzip("c:/carpetaEje.zip");
    }

    private static void zipDir(String dir2zip, ZipOutputStream zos) {
        try {
            File zipDir = new File(dir2zip);
            String[] dirList = zipDir.list();
            byte[] readBuffer = new byte[2156];
            int bytesIn = 0;
            int i = 0;
            while (i < dirList.length) {
                File f = new File(zipDir, dirList[i]);
                if (f.isDirectory()) {
                    String filePath = f.getPath();
                    Zipper.zipDir(filePath, zos);
                }
                FileInputStream fis = new FileInputStream(f);
                ZipEntry anEntry = new ZipEntry(f.getPath());
                zos.putNextEntry(anEntry);
                while ((bytesIn = fis.read(readBuffer)) != -1) {
                    zos.write(readBuffer, 0, bytesIn);
                }
                fis.close();
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

