/*
 * Decompiled with CFR 0.152.
 */
package es.jlg.crypt.gui.wizard;

import com.sun.net.ssl.internal.ssl.Provider;
import es.jlg.crypt.data.Operation;
import es.jlg.crypt.gui.CryptMain;
import es.jlg.crypt.gui.wizard.FileDataPage;
import es.jlg.crypt.gui.wizard.KeyPage;
import es.jlg.crypt.gui.wizard.MailAndCDataPage;
import es.jlg.crypt.gui.wizard.TextPage;
import es.jlg.crypt.logic.BlowfishEncrypter;
import es.jlg.crypt.logic.DesEncrypter;
import es.jlg.crypt.logic.StringDesEncrypter;
import es.jlg.crypt.utils.Messages;
import es.jlg.crypt.utils.PropertiesManager;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Security;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.crypto.spec.SecretKeySpec;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;

public class MailWizard
extends Wizard {
    private static final String MAIL = "Mail";
    private static final String SUCCESSFULL_MESSAGE = "Mail has successfully sent  ";
    private FileDataPage fileDataPage;
    private KeyPage keyPage;
    private TextPage textPage;
    private MailAndCDataPage dataPage;
    private static final String emailMsgTxt = "Test Message Contents";
    private static final String emailSubjectTxt = "A test from gmail";
    private static final String emailFromAddress = "gnomobueno@gmail.com";
    private static final String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";
    private ISelection selection;
    private static String resultFileName = "";

    public MailWizard() {
        this.setNeedsProgressMonitor(true);
        ImageDescriptor imageDesc = ImageDescriptor.createFromFile(null, "img/new_wiz.gif");
        this.setDefaultPageImageDescriptor(imageDesc);
        this.setWindowTitle(Messages.getString("MailAndCDataPage.SendMail"));
    }

    public void addPages() {
        if (this.textPage == null) {
            this.textPage = new TextPage(this.selection);
            this.addPage(this.textPage);
        }
        if (this.dataPage == null) {
            this.dataPage = new MailAndCDataPage(this.selection);
            this.addPage(this.dataPage);
        }
    }

    public boolean performFinish() {
        String from = this.dataPage.getFromDirText().getText();
        String[] to = new String[]{this.dataPage.getToDirText().getText()};
        Security.addProvider((java.security.Provider)new Provider());
        try {
            this.sendSSLMessage(to, this.dataPage.getSubjectText().getText(), this.textPage.getTextText().getText(), from);
        }
        catch (MessagingException e) {
            MessageDialog.openError(Display.getCurrent().getActiveShell(), Messages.getString("MailWizard.Error"), e.getMessage());
            e.printStackTrace();
        }
        CryptMain.setStatusMessage(Messages.getString("MailWizard.SuccessfullySent"));
        return true;
    }

    public void sendSSLMessage(String[] recipients, String subject, String message, String from) throws MessagingException {
        boolean debug = true;
        Properties props = new Properties();
        try {
            props.put("mail.smtp.port", PropertiesManager.getProperty("MailServerPrefPage.port"));
            props.put("mail.smtp.socketFactory.port", PropertiesManager.getProperty("MailServerPrefPage.port"));
            props.put("mail.smtp.host", PropertiesManager.getProperty("MailServerPrefPage.server"));
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        props.put("mail.smtp.auth", "true");
        props.put("mail.debug", "true");
        props.put("mail.smtp.socketFactory.class", SSL_FACTORY);
        props.put("mail.smtp.socketFactory.fallback", "false");
        Session session = Session.getDefaultInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                PasswordAuthentication passwordAuthentication = null;
                try {
                    passwordAuthentication = new PasswordAuthentication(PropertiesManager.getProperty("MailAccounPage.login"), StringDesEncrypter.decryptString(PropertiesManager.getProperty("MailAccounPage.password")));
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return passwordAuthentication;
            }
        });
        session.setDebug(debug);
        MimeMessage msg = new MimeMessage(session);
        InternetAddress addressFrom = new InternetAddress(from);
        msg.setFrom((Address)addressFrom);
        InternetAddress[] addressTo = new InternetAddress[recipients.length];
        int i = 0;
        while (i < recipients.length) {
            addressTo[i] = new InternetAddress(recipients[i]);
            ++i;
        }
        msg.setRecipients(Message.RecipientType.TO, (Address[])addressTo);
        msg.setSubject(subject);
        if (!this.dataPage.getButtonCBEncode().getSelection()) {
            msg.setContent((Object)message, "text/plain");
        } else {
            resultFileName = this.encodeMail();
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setText(Messages.getString("MailWizard.MailText"));
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)messageBodyPart);
            messageBodyPart = new MimeBodyPart();
            FileDataSource source = new FileDataSource(resultFileName);
            messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
            messageBodyPart.setFileName(resultFileName);
            multipart.addBodyPart((BodyPart)messageBodyPart);
            msg.setContent((Multipart)multipart);
        }
        Transport.send((Message)msg);
    }

    private String encodeMail() {
        String outputFileName = "data/" + new Date().getTime() + ".cp";
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.textPage.getTextText().getText().getBytes());
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(outputFileName);
            if (this.dataPage.getComboAlg().getText().equals("DES")) {
                SecretKeySpec desKey = new SecretKeySpec(this.dataPage.getKeyText().getText().getBytes(), this.dataPage.getComboAlg().getText());
                DesEncrypter encrypter = new DesEncrypter(desKey);
                encrypter.encrypt(byteArrayInputStream, fileOutputStream);
            } else if (this.dataPage.getComboAlg().getText().equals("Blowfish")) {
                SecretKeySpec desKey = new SecretKeySpec(this.dataPage.getKeyText().getText().getBytes(), this.dataPage.getComboAlg().getText());
                BlowfishEncrypter encrypter = new BlowfishEncrypter(desKey);
                encrypter.encrypt(byteArrayInputStream, fileOutputStream);
            }
            if (CryptMain.getUser() == null) {
                CryptMain.getOperationManager().store(Operation.valueOf(MAIL, outputFileName, "E", this.dataPage.getComboAlg().getText(), new Date(), "---"));
            } else {
                CryptMain.getOperationManager().store(Operation.valueOf(MAIL, outputFileName, "E", this.dataPage.getComboAlg().getText(), new Date(), CryptMain.getUser().getLogin()));
            }
            CryptMain.addTableItem(MAIL, outputFileName, "E", this.dataPage.getComboAlg().getText(), new Date());
            CryptMain.setStatusMessage(SUCCESSFULL_MESSAGE);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return outputFileName;
    }
}

