/*
 * Decompiled with CFR 0.152.
 */
package es.jlg.crypt.gui.wizard;

import es.jlg.crypt.utils.Messages;
import es.jlg.crypt.utils.PropertiesManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class MailDataPage
extends WizardPage {
    private Button buttonCBSendMail;
    private Text toDirText;
    private Text fromDirText;
    private Text subjectText;
    private Text serverHostText;
    private Text portText;
    private Text loginText;
    private Text passwordText;
    private ISelection selection;

    public MailDataPage(ISelection selection) {
        super("wizardPage");
        this.setTitle(Messages.getString(Messages.getString("MailDataPage.SendMail")));
        this.setDescription(Messages.getString(Messages.getString("MailDataPage.IntroduceTextTS")));
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout(layout);
        layout.numColumns = 2;
        layout.verticalSpacing = 1;
        this.setMailData(container);
        this.createLine(container, layout.numColumns);
        this.setControl(container);
    }

    private void setMailServerData(Composite container) {
        Label label = new Label(container, 0);
        label.setText(Messages.getString("MailDataPage.ServerHost"));
        this.serverHostText = new Text(container, 2048);
        this.serverHostText.setEnabled(false);
        GridData gd = new GridData(768);
        this.serverHostText.setLayoutData(gd);
        this.serverHostText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MailDataPage.this.dialogChanged();
            }
        });
        Label label5 = new Label(container, 0);
        label5.setText(Messages.getString("MailDataPage.Port"));
        this.portText = new Text(container, 2048);
        this.portText.setEnabled(false);
        gd = new GridData(768);
        this.portText.setLayoutData(gd);
        this.portText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MailDataPage.this.dialogChanged();
            }
        });
    }

    private void setMailData(Composite container) {
        Label labelSendMail = new Label(container, 0);
        labelSendMail.setText(Messages.getString("MailDataPage.DoYouWantToSendEmail"));
        this.buttonCBSendMail = new Button(container, 32);
        GridData gd = new GridData(768);
        this.buttonCBSendMail.setLayoutData(gd);
        this.buttonCBSendMail.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                if (MailDataPage.this.buttonCBSendMail.getSelection()) {
                    MailDataPage.this.enableMailFields();
                } else {
                    MailDataPage.this.disableMailFields();
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Label label2 = new Label(container, 0);
        label2.setText(Messages.getString("MailDataPage.ReceiverDirection"));
        this.toDirText = new Text(container, 2048);
        gd = new GridData(768);
        this.toDirText.setLayoutData(gd);
        this.toDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MailDataPage.this.dialogChanged();
            }
        });
        Label label3 = new Label(container, 0);
        label3.setText(Messages.getString("MailDataPage.SenderDirection"));
        this.fromDirText = new Text(container, 2048);
        gd = new GridData(768);
        this.fromDirText.setLayoutData(gd);
        this.fromDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MailDataPage.this.dialogChanged();
            }
        });
        Label label4 = new Label(container, 0);
        label4.setText(Messages.getString("MailDataPage.Subjet"));
        this.subjectText = new Text(container, 2048);
        gd = new GridData(768);
        this.subjectText.setLayoutData(gd);
        this.subjectText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MailDataPage.this.dialogChanged();
            }
        });
        try {
            this.toDirText.setText(PropertiesManager.getProperty("MailPrefPage.toDirection"));
            this.fromDirText.setText(PropertiesManager.getProperty("MailPrefPage.forDirection"));
            this.subjectText.setText(PropertiesManager.getProperty("MailPrefPage.subjet"));
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.disableMailFields();
    }

    private void disableMailFields() {
        this.toDirText.setEnabled(false);
        this.fromDirText.setEnabled(false);
        this.subjectText.setEnabled(false);
    }

    private void enableMailFields() {
        this.toDirText.setEnabled(true);
        this.fromDirText.setEnabled(true);
        this.subjectText.setEnabled(true);
    }

    private void dialogChanged() {
        if (this.getToDirText().getText().length() == 0) {
            this.updateStatus(Messages.getString("MailDataPage.Error1"));
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    private void createLine(Composite parent, int ncol) {
        Label line = new Label(parent, 259);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = ncol;
        line.setLayoutData(gridData);
    }

    public Text getFromDirText() {
        return this.fromDirText;
    }

    public void setFromDirText(Text fromDirText) {
        this.fromDirText = fromDirText;
    }

    public Text getServerHostText() {
        return this.serverHostText;
    }

    public void setServerHostText(Text serverHostText) {
        this.serverHostText = serverHostText;
    }

    public Text getToDirText() {
        return this.toDirText;
    }

    public void setToDirText(Text toDirText) {
        this.toDirText = toDirText;
    }

    public Text getSubjectText() {
        return this.subjectText;
    }

    public Text getLoginText() {
        return this.loginText;
    }

    public void setLoginText(Text loginText) {
        this.loginText = loginText;
    }

    public Text getPasswordText() {
        return this.passwordText;
    }

    public void setPasswordText(Text passwordText) {
        this.passwordText = passwordText;
    }

    public Text getPortText() {
        return this.portText;
    }

    public void setPortText(Text portText) {
        this.portText = portText;
    }

    public void setSubjectText(Text subjectText) {
        this.subjectText = subjectText;
    }

    public Button getButtonCBSendMail() {
        return this.buttonCBSendMail;
    }

    public void setButtonCBSendMail(Button buttonCBSendMail) {
        this.buttonCBSendMail = buttonCBSendMail;
    }
}

