/*
 * Decompiled with CFR 0.152.
 */
package es.jlg.crypt.gui;

import es.jlg.crypt.data.Operation;
import es.jlg.crypt.gui.CryptMain;
import es.jlg.crypt.gui.FileWindow;
import es.jlg.crypt.utils.Messages;
import es.jlg.crypt.utils.Utils;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.vafada.swtcalendar.SWTCalendar;
import org.vafada.swtcalendar.SWTCalendarEvent;
import org.vafada.swtcalendar.SWTCalendarListener;

public class SearchFileWindow
extends ApplicationWindow {
    private static final String SEARCH_COMPLETE = Messages.getString("SearchWindow.SearchComplete");
    private static SearchFileWindow app;
    private SWTCalendar c;
    private static TableViewer tableViewer;
    private Table table;
    private Label informationLabel;
    private Button buttonEdit;
    private Button buttonView;
    private List operationList;
    static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        logger = null;
    }

    public SearchFileWindow() {
        super(null);
    }

    protected Control createContents(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString("SearchFileWindow.text"));
        shell.setSize(750, 215);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout(layout);
        layout.numColumns = 6;
        layout.makeColumnsEqualWidth = false;
        GridData gd = new GridData(1);
        this.c = new SWTCalendar(container, 0x11000000);
        gd = new GridData(32);
        gd.verticalSpan = 6;
        this.c.setLayoutData((Object)gd);
        this.c.addSWTCalendarListener(new SWTCalendarListener(){

            public void dateChanged(SWTCalendarEvent arg0) {
                List operations = SearchFileWindow.this.listOperationsOnTheTable();
                SearchFileWindow.this.informationLabel.setText(Messages.getString("SearchFileWindow.searchComplete"));
                if (operations.size() == 0) {
                    SearchFileWindow.this.informationLabel.setText(Messages.getString("SearchFileWindow.messageNoDocuments"));
                }
            }
        });
        this.table = new Table(container, 67584);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                if (SearchFileWindow.this.operationList != null && SearchFileWindow.this.table.getSelectionIndex() >= 0) {
                    Operation o = (Operation)SearchFileWindow.this.operationList.get(SearchFileWindow.this.table.getSelectionIndex());
                    if (Utils.isEditable(o.getOutputFile())) {
                        SearchFileWindow.this.enableButtons();
                    } else {
                        SearchFileWindow.this.disableButtons();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        TableColumn column = new TableColumn(this.table, 16384);
        column.setText(Messages.getString("SearchFileWindow.source"));
        column.setWidth(330);
        this.table.setHeaderVisible(true);
        column = new TableColumn(this.table, 16384);
        column.setText(Messages.getString("SearchFileWindow.kind"));
        column.setWidth(100);
        this.table.setHeaderVisible(true);
        gd = new GridData(1808);
        gd.horizontalSpan = 5;
        gd.verticalSpan = 5;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.table.setLayoutData(gd);
        tableViewer = new TableViewer(this.table);
        this.buttonEdit = new Button(container, 0);
        this.buttonEdit.setText(Messages.getString("SearchFileWindow.edit"));
        gd = new GridData(64);
        this.buttonEdit.setLayoutData(gd);
        this.buttonEdit.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                if (SearchFileWindow.this.operationList != null && SearchFileWindow.this.table.getSelectionIndex() >= 0) {
                    Operation o = (Operation)SearchFileWindow.this.operationList.get(SearchFileWindow.this.table.getSelectionIndex());
                    FileWindow fileWindow = new FileWindow(o, true);
                    fileWindow.open();
                } else {
                    SearchFileWindow.this.informationLabel.setText(Messages.getString("SearchFileWindow.noItemSelected"));
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.buttonView = new Button(container, 0);
        this.buttonView.setText(Messages.getString("SearchFileWindow.view"));
        gd = new GridData(64);
        this.buttonView.setLayoutData(gd);
        this.buttonView.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                if (SearchFileWindow.this.operationList != null && SearchFileWindow.this.table.getSelectionIndex() >= 0) {
                    Operation o = (Operation)SearchFileWindow.this.operationList.get(SearchFileWindow.this.table.getSelectionIndex());
                    System.err.println(o.getInputFile());
                    FileWindow fileWindow = new FileWindow(o, false);
                    fileWindow.open();
                } else {
                    SearchFileWindow.this.informationLabel.setText(Messages.getString("SearchFileWindow.noItemSelected"));
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Button buttonRemove = new Button(container, 0);
        buttonRemove.setText(Messages.getString("SearchFileWindow.remove"));
        gd = new GridData(32);
        buttonRemove.setLayoutData(gd);
        buttonRemove.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                CryptMain.getOperationManager().deleteOperation((Operation)SearchFileWindow.this.operationList.get(SearchFileWindow.this.table.getSelectionIndex()));
                SearchFileWindow.this.deleteFile();
                SearchFileWindow.this.informationLabel.setText(Messages.getString("SearchFileWindow.messageItemDeleted"));
                SearchFileWindow.this.listOperationsOnTheTable();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.informationLabel = new Label(container, 0);
        this.informationLabel.setText(Messages.getString("SearchFileWindow.messageSelectDate"));
        Button buttonClose = new Button(container, 0);
        buttonClose.setText(Messages.getString("SearchFileWindow.close"));
        gd = new GridData(128);
        buttonClose.setLayoutData(gd);
        buttonClose.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                SearchFileWindow.this.getShell().close();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.listOperationsOnTheTable();
        this.disableButtons();
        return container;
    }

    public static void main(String[] args) {
        if (app == null) {
            app = new SearchFileWindow();
        }
        app.setBlockOnOpen(true);
        app.open();
        Display.getCurrent().dispose();
    }

    public static void addTableItem(String source, String kind) {
        Table table = tableViewer.getTable();
        TableItem item = new TableItem(table, 0);
        item.setText(0, source);
        item.setText(1, String.valueOf(kind));
    }

    public static Logger getLogger() {
        if (logger == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("es.jlg.crypt.gui.SearchFileWindow");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger = Logger.getLogger((Class)clazz);
            PropertyConfigurator.configure((String)"log4j.cryptLog.properties");
        }
        return logger;
    }

    private void deleteFile() {
        File inputFile = new File(((Operation)this.operationList.get(this.table.getSelectionIndex())).getOutputFile());
        if (inputFile.delete()) {
            SearchFileWindow.getLogger().debug((Object)"---------- The db file has been deleted");
        } else {
            SearchFileWindow.getLogger().error((Object)"---------- The db file has NOT been deleted");
            this.informationLabel.setText(Messages.getString("SearchFileWindow.messageFileNotDeleted"));
        }
    }

    private List listOperationsOnTheTable() {
        List operations;
        this.operationList = operations = CryptMain.getOperationManager().listOperationsForADate("", "", "Both", "Both", this.c.getCalendar().getTime(), CryptMain.getUser().getLogin());
        Table table = tableViewer.getTable();
        table.removeAll();
        Iterator iter = operations.iterator();
        while (iter.hasNext()) {
            Operation element = (Operation)iter.next();
            SearchFileWindow.addTableItem(element.getInputFile(), element.getKind());
        }
        return operations;
    }

    private void disableButtons() {
        this.buttonEdit.setEnabled(false);
        this.buttonView.setEnabled(false);
    }

    private void enableButtons() {
        this.buttonEdit.setEnabled(true);
        this.buttonView.setEnabled(true);
    }
}

