/*
 * Decompiled with CFR 0.152.
 */
package es.jlg.crypt.gui;

import es.jlg.crypt.data.Operation;
import es.jlg.crypt.gui.CryptMain;
import es.jlg.crypt.logic.DesEncrypter;
import es.jlg.crypt.logic.StringDesEncrypter;
import es.jlg.crypt.utils.Messages;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Date;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.vafada.swtcalendar.SWTCalendar;

public class FileWindow
extends ApplicationWindow {
    private static final String SEARCH_COMPLETE = Messages.getString("SearchWindow.SearchComplete");
    private static FileWindow app;
    private Text subjectText;
    private Combo typeCombo;
    private Text text;
    private SWTCalendar c;
    private Operation operation;
    private boolean isEditable = true;

    public FileWindow() {
        super(null);
    }

    public FileWindow(Operation operation, boolean isEditable) {
        super(null);
        this.operation = operation;
        this.isEditable = isEditable;
    }

    protected Control createContents(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString("FileWindow.fileWindow"));
        shell.setSize(600, 600);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout(layout);
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        GridData gd = new GridData(1);
        this.c = new SWTCalendar(container, 0x11000000);
        gd = new GridData(32);
        gd.verticalSpan = 6;
        this.c.setLayoutData((Object)gd);
        if (this.operation != null) {
            this.c.getCalendar().setTime(this.operation.getDate());
        }
        this.c.setEnabled(this.isEditable);
        Label subjectLabel = new Label(container, 0);
        subjectLabel.setText(Messages.getString("FileWindow.subjet"));
        this.subjectText = new Text(container, 2052);
        gd = new GridData(768);
        if (this.operation != null) {
            this.subjectText.setText(this.operation.getInputFile());
        }
        this.subjectText.setEditable(this.isEditable);
        this.subjectText.setLayoutData(gd);
        Label typeLabel = new Label(container, 0);
        typeLabel.setText(Messages.getString("FileWindow.type"));
        this.typeCombo = new Combo(container, 4);
        this.typeCombo.add(Messages.getString("FileWindow.diary"));
        this.typeCombo.add(Messages.getString("FileWindow.annotation"));
        this.typeCombo.add(Messages.getString("FileWindow.alarm"));
        this.typeCombo.select(0);
        if (this.operation != null) {
            this.typeCombo.setText(this.operation.getKind());
        } else {
            this.typeCombo.select(0);
        }
        this.typeCombo.setEnabled(this.isEditable);
        gd = new GridData(32);
        this.typeCombo.setLayoutData(gd);
        Button buttonSave = new Button(container, 0);
        buttonSave.setText(Messages.getString("FileWindow.save"));
        gd = new GridData(128);
        buttonSave.setLayoutData(gd);
        buttonSave.setEnabled(this.isEditable);
        buttonSave.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                String outputFileName = "data/" + new Date().getTime() + ".cp";
                if (CryptMain.getUser() != null) {
                    if (FileWindow.this.typeCombo.getText().equals(Messages.getString("FileWindow.alarm")) && FileWindow.this.c.getCalendar().getTime().before(new Date())) {
                        MessageDialog.openError(Display.getCurrent().getActiveShell(), Messages.getString("CWizard.Error"), Messages.getString("FileWindow.errorMessage1"));
                    } else {
                        FileWindow.this.encodeText(outputFileName);
                        CryptMain.getOperationManager().store(Operation.valueOf(FileWindow.this.subjectText.getText(), outputFileName, FileWindow.this.typeCombo.getText(), "DES", FileWindow.this.c.getCalendar().getTime(), CryptMain.getUser().getLogin()));
                        CryptMain.loadData(CryptMain.getOperationManager().listOperations(CryptMain.getUser().getLogin()));
                        FileWindow.this.getShell().close();
                        CryptMain.setStatusMessage(Messages.getString("FileWindow.sucesfullMessage"));
                    }
                } else {
                    MessageDialog.openError(Display.getCurrent().getActiveShell(), Messages.getString("CWizard.Error"), Messages.getString("FileWindow.errorMessage2"));
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Button buttonClose = new Button(container, 0);
        buttonClose.setText(Messages.getString("FileWindow.close"));
        gd = new GridData(128);
        buttonClose.setLayoutData(gd);
        buttonClose.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                FileWindow.this.getShell().close();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.text = new Text(container, 2882);
        gd = new GridData(1808);
        this.text.setEditable(this.isEditable);
        gd.horizontalSpan = 3;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.text.setLayoutData(gd);
        if (this.operation != null) {
            SecretKeySpec desKey = new SecretKeySpec(StringDesEncrypter.decryptString(CryptMain.getUser().getPassword()).getBytes(), "DES");
            DesEncrypter encrypter = new DesEncrypter(desKey);
            try {
                this.text.setText(encrypter.decrypt(new FileInputStream(this.operation.getOutputFile())).toString());
            }
            catch (FileNotFoundException e) {
                MessageDialog.openError(Display.getCurrent().getActiveShell(), Messages.getString("CWizard.Error"), e.getMessage());
                e.printStackTrace();
            }
        } else {
            this.text.setText(new Date().toString());
        }
        return container;
    }

    public static void main(String[] args) {
        if (app == null) {
            app = new FileWindow();
        }
        app.setBlockOnOpen(true);
        app.open();
        Display.getCurrent().dispose();
    }

    private void encodeText(String outputFileName) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.text.getText().getBytes());
        SecretKeySpec desKey = new SecretKeySpec(StringDesEncrypter.decryptString(CryptMain.getUser().getPassword()).getBytes(), "DES");
        DesEncrypter encrypter = new DesEncrypter(desKey);
        try {
            encrypter.encrypt(byteArrayInputStream, new FileOutputStream(outputFileName));
        }
        catch (FileNotFoundException e) {
            MessageDialog.openError(Display.getCurrent().getActiveShell(), Messages.getString("CWizard.Error"), e.getMessage());
            e.printStackTrace();
        }
    }
}

