/*
 * Decompiled with CFR 0.152.
 */
package es.jlg.crypt.gui;

import es.jlg.crypt.data.Operation;
import es.jlg.crypt.data.OperationManager;
import es.jlg.crypt.data.User;
import es.jlg.crypt.data.UserManager;
import es.jlg.crypt.gui.MessageWindow;
import es.jlg.crypt.gui.menubar.AboutAction;
import es.jlg.crypt.gui.menubar.CAndMailADirectoryAction;
import es.jlg.crypt.gui.menubar.CAndMailAction;
import es.jlg.crypt.gui.menubar.DesEncrypFileAction;
import es.jlg.crypt.gui.menubar.EncrypFileAction;
import es.jlg.crypt.gui.menubar.ExitAction;
import es.jlg.crypt.gui.menubar.FileAction;
import es.jlg.crypt.gui.menubar.FileDeleteAction;
import es.jlg.crypt.gui.menubar.FileEditAction;
import es.jlg.crypt.gui.menubar.HelpAction;
import es.jlg.crypt.gui.menubar.LoginAction;
import es.jlg.crypt.gui.menubar.MailAction;
import es.jlg.crypt.gui.menubar.PreferencesAction;
import es.jlg.crypt.gui.menubar.SearchFileAction;
import es.jlg.crypt.gui.menubar.ShearchAction;
import es.jlg.crypt.logic.DesEncrypter;
import es.jlg.crypt.logic.StringDesEncrypter;
import es.jlg.crypt.utils.Messages;
import es.jlg.crypt.utils.Utils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class CryptMain
extends ApplicationWindow {
    public static final String LOG_PRE = "---------- ";
    private static TableViewer tableViewer;
    private static CryptMain app;
    private static User user;
    private Table table;
    private static List operationList;
    private static Operation operation;
    private FileAction fileAction = new FileAction(this);
    private FileEditAction fileEditAction = new FileEditAction(this);
    private FileDeleteAction fileDeleteAction = new FileDeleteAction(this);
    static Logger logger;
    private static OperationManager operationManager;
    private static UserManager userManager;
    static /* synthetic */ Class class$0;

    static {
        logger = null;
        operationManager = null;
        userManager = null;
    }

    public CryptMain() {
        super(null);
        this.addMenuBar();
        this.addStatusLine();
        this.addToolBar(0x800040);
        CryptMain.setDefaultImage(new Image(null, "img/mainLogo.gif"));
    }

    public static void loadData(List list) {
        operationList = Utils.reverse(list);
        Table table = tableViewer.getTable();
        table.removeAll();
        Object[] operations = list.toArray();
        Iterator iter = operationList.iterator();
        while (iter.hasNext()) {
            Operation element = (Operation)iter.next();
            CryptMain.addTableItem(element.getInputFile(), element.getOutputFile(), element.getKind(), element.getAlgorithm(), element.getDate());
        }
    }

    protected Control createContents(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString("CryptMain.name"));
        shell.setSize(740, 300);
        SashForm form = new SashForm(parent, 256);
        Composite container = new Composite(parent, 0);
        this.table = new Table(form, 67584);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                if (operationList != null && CryptMain.this.table.getSelectionIndex() >= 0) {
                    Operation o = (Operation)operationList.get(CryptMain.this.table.getSelectionIndex());
                    System.out.println(String.valueOf(CryptMain.this.table.getSelectionIndex()) + "   " + o.getOutputFile() + "   " + o.getInputFile());
                    if (Utils.isEditable(CryptMain.this.findSelectedOrderByName().getOutputFile())) {
                        if (o.getInputFile().trim().equals(CryptMain.this.table.getSelection()[0].getText().trim())) {
                            CryptMain.this.setOperation(o);
                        } else {
                            CryptMain.this.setOperation(CryptMain.this.findSelectedOrderByName());
                        }
                        CryptMain.this.enableButtons();
                    } else {
                        CryptMain.this.disableButtons();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        TableColumn column = new TableColumn(this.table, 16384);
        column.setText(Messages.getString("CryptMain.InputFile"));
        column.setWidth(200);
        this.table.setHeaderVisible(true);
        column.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableItem[] items = CryptMain.this.table.getItems();
                Collator collator = Collator.getInstance(Locale.getDefault());
                int i = 1;
                while (i < items.length) {
                    String value1 = items[i].getText(0);
                    int j = 0;
                    while (j < i) {
                        String value2 = items[j].getText(0);
                        if (collator.compare(value1, value2) < 0) {
                            String[] values = new String[]{items[i].getText(0), items[i].getText(1), items[i].getText(2), items[i].getText(3), items[i].getText(4)};
                            items[i].dispose();
                            TableItem item = new TableItem(CryptMain.this.table, 0, j);
                            item.setText(values);
                            items = CryptMain.this.table.getItems();
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        });
        column = new TableColumn(this.table, 16384);
        column.setText(Messages.getString("CryptMain.OutputFile"));
        column.setWidth(200);
        this.table.setHeaderVisible(true);
        column.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableItem[] items = CryptMain.this.table.getItems();
                Collator collator = Collator.getInstance(Locale.getDefault());
                int i = 1;
                while (i < items.length) {
                    String value1 = items[i].getText(1);
                    int j = 0;
                    while (j < i) {
                        String value2 = items[j].getText(1);
                        if (collator.compare(value1, value2) < 0) {
                            String[] values = new String[]{items[i].getText(0), items[i].getText(1), items[i].getText(2), items[i].getText(3), items[i].getText(4)};
                            items[i].dispose();
                            TableItem item = new TableItem(CryptMain.this.table, 0, j);
                            item.setText(values);
                            items = CryptMain.this.table.getItems();
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        });
        column = new TableColumn(this.table, 16384);
        column.setText(Messages.getString("CryptMain.Kind"));
        column.setWidth(70);
        this.table.setHeaderVisible(true);
        column.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableItem[] items = CryptMain.this.table.getItems();
                Collator collator = Collator.getInstance(Locale.getDefault());
                int i = 1;
                while (i < items.length) {
                    String value1 = items[i].getText(2);
                    int j = 0;
                    while (j < i) {
                        String value2 = items[j].getText(2);
                        if (collator.compare(value1, value2) < 0) {
                            String[] values = new String[]{items[i].getText(0), items[i].getText(1), items[i].getText(2), items[i].getText(3), items[i].getText(4)};
                            items[i].dispose();
                            TableItem item = new TableItem(CryptMain.this.table, 0, j);
                            item.setText(values);
                            items = CryptMain.this.table.getItems();
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        });
        column = new TableColumn(this.table, 16384);
        column.setText(Messages.getString("CryptMain.Algorithm"));
        column.setWidth(82);
        this.table.setHeaderVisible(true);
        column.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableItem[] items = CryptMain.this.table.getItems();
                Collator collator = Collator.getInstance(Locale.getDefault());
                int i = 1;
                while (i < items.length) {
                    String value1 = items[i].getText(3);
                    int j = 0;
                    while (j < i) {
                        String value2 = items[j].getText(3);
                        if (collator.compare(value1, value2) < 0) {
                            String[] values = new String[]{items[i].getText(0), items[i].getText(1), items[i].getText(2), items[i].getText(3), items[i].getText(4)};
                            items[i].dispose();
                            TableItem item = new TableItem(CryptMain.this.table, 0, j);
                            item.setText(values);
                            items = CryptMain.this.table.getItems();
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        });
        column = new TableColumn(this.table, 16384);
        column.setText(Messages.getString("CryptMain.Date"));
        column.setWidth(76);
        this.table.setHeaderVisible(true);
        tableViewer = new TableViewer(this.table);
        return container;
    }

    public void disableButtons() {
        this.fileEditAction.setEnabled(false);
        this.fileDeleteAction.setEnabled(false);
    }

    protected void enableButtons() {
        this.fileEditAction.setEnabled(true);
        this.fileDeleteAction.setEnabled(true);
    }

    public static void main(String[] args) {
        MessageWindow progressBarWindow = new MessageWindow("Crypt www.javierlop.tk");
        progressBarWindow.open();
        if (app == null) {
            app = new CryptMain();
        }
        CryptMain.desencodeBDScript("data/test.script");
        app.setBlockOnOpen(true);
        progressBarWindow.close();
        app.open();
        Display.getCurrent().dispose();
    }

    protected MenuManager createMenuManager() {
        MenuManager bar = new MenuManager();
        MenuManager fileMenu = new MenuManager(Messages.getString("CryptMain.File"));
        MenuManager helpMenu = new MenuManager(Messages.getString("CryptMain.Help"));
        MenuManager usersMenu = new MenuManager(Messages.getString("CryptMain.User"));
        MenuManager diaryMenu = new MenuManager(Messages.getString("CryptMain.Diary"));
        MenuManager mailMenu = new MenuManager(Messages.getString("CryptMain.Mail"));
        MenuManager preferencesMenu = new MenuManager(Messages.getString("CryptMain.preferences"));
        bar.add(fileMenu);
        bar.add(usersMenu);
        bar.add(diaryMenu);
        bar.add(preferencesMenu);
        bar.add(helpMenu);
        fileMenu.add(new EncrypFileAction(this));
        fileMenu.add(new CAndMailADirectoryAction(this));
        fileMenu.add(new DesEncrypFileAction(this));
        fileMenu.add(new ShearchAction(this));
        fileMenu.add(new ExitAction(this));
        mailMenu.add(new MailAction(this));
        mailMenu.add(new CAndMailAction(this));
        usersMenu.add(new LoginAction(this));
        diaryMenu.add(new FileAction(this));
        diaryMenu.add(new SearchFileAction(this));
        diaryMenu.add(new MailAction(this));
        preferencesMenu.add(new PreferencesAction(this));
        helpMenu.add(new HelpAction(this));
        helpMenu.add(new AboutAction(this));
        return bar;
    }

    protected ToolBarManager createToolBarManager(int style) {
        ToolBarManager toolBarManager = new ToolBarManager(style);
        toolBarManager.add(new CAndMailAction(this));
        toolBarManager.add(new CAndMailADirectoryAction(this));
        toolBarManager.add(new DesEncrypFileAction(this));
        toolBarManager.add(new ShearchAction(this));
        toolBarManager.add(new Separator("group 1"));
        toolBarManager.add(new LoginAction(this));
        toolBarManager.add(new MailAction(this));
        toolBarManager.add(this.fileAction);
        toolBarManager.add(new SearchFileAction(this));
        toolBarManager.add(new Separator("group 2"));
        toolBarManager.add(this.fileEditAction);
        toolBarManager.add(this.fileDeleteAction);
        this.disableButtons();
        return toolBarManager;
    }

    public static void addTableItem(String inputFile, String outputFile, String kind, String algorithm, Date date) {
        Table table = tableViewer.getTable();
        TableItem item = new TableItem(table, 0);
        item.setText(0, inputFile);
        item.setText(1, String.valueOf(outputFile));
        item.setText(2, String.valueOf(kind));
        item.setText(3, String.valueOf(algorithm));
        SimpleDateFormat formatter = new SimpleDateFormat("MMM dd yyyy");
        item.setText(4, formatter.format(date));
    }

    public static void setStatusMessage(String message) {
        app.setStatus(message);
    }

    public static User getUser() {
        return user;
    }

    public static void setUser(User user) {
        CryptMain.user = user;
        CryptMain.getLogger().debug((Object)"---------- The user has been set");
    }

    public static OperationManager getOperationManager() {
        if (operationManager == null) {
            operationManager = new OperationManager();
        }
        return operationManager;
    }

    public static UserManager getUserManager() {
        if (userManager == null) {
            userManager = new UserManager();
        }
        return userManager;
    }

    public boolean close() {
        CryptMain.encodeBDScript("data/test.script");
        return super.close();
    }

    protected static void encodeBDScript(String p) {
        SecretKeySpec desKey = new SecretKeySpec(String.valueOf(StringDesEncrypter.k).getBytes(), "DES");
        DesEncrypter encrypter = new DesEncrypter(desKey);
        File inputFile = new File(p);
        try {
            encrypter.encrypt(new FileInputStream(p), new FileOutputStream(String.valueOf(p) + ".cp"));
            if (inputFile.delete()) {
                CryptMain.getLogger().debug((Object)"---------- The db file has been deleted");
            } else {
                CryptMain.getLogger().error((Object)"---------- The db file has NOT been deleted");
                try {
                    CryptMain.clearFile(p);
                    CryptMain.getLogger().error((Object)"---------- The db file has been cleared");
                }
                catch (IOException e1) {
                    CryptMain.getLogger().error((Object)"---------- The db file has NOT been cleared");
                    e1.printStackTrace();
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static void clearFile(String p) throws IOException {
        FileWriter fw = new FileWriter(p);
        BufferedWriter bw = new BufferedWriter(fw);
        PrintWriter salida = new PrintWriter(bw);
        salida.println("que pasa nennn");
        salida.close();
    }

    protected static void desencodeBDScript(String p) {
        SecretKeySpec desKey = new SecretKeySpec(String.valueOf(StringDesEncrypter.k).getBytes(), "DES");
        DesEncrypter encrypter = new DesEncrypter(desKey);
        try {
            OutputStream outputStream = encrypter.decrypt(new FileInputStream(String.valueOf(p) + ".cp"));
            FileWriter fw = new FileWriter(p);
            BufferedWriter bw = new BufferedWriter(fw);
            PrintWriter salida = new PrintWriter(bw);
            salida.println(outputStream.toString().trim());
            salida.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        CryptMain.getLogger().debug((Object)"---------- The data base file has been desencoded");
    }

    public static Logger getLogger() {
        if (logger == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("es.jlg.crypt.gui.CryptMain");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger = Logger.getLogger((Class)clazz);
            PropertyConfigurator.configure((String)"log4j.cryptLog.properties");
        }
        return logger;
    }

    public FileAction getFileAction() {
        return this.fileAction;
    }

    public static Operation getOperation() {
        return operation;
    }

    public void setOperation(Operation operation) {
        CryptMain.operation = operation;
    }

    public FileDeleteAction getFileDeleteAction() {
        return this.fileDeleteAction;
    }

    public FileEditAction getFileEditAction() {
        return this.fileEditAction;
    }

    private Operation findSelectedOrderByName() {
        Iterator iter = operationList.iterator();
        while (iter.hasNext()) {
            Operation element = (Operation)iter.next();
            if (!element.getInputFile().trim().equals(this.table.getSelection()[0].getText().trim())) continue;
            return element;
        }
        return null;
    }
}

