/*
 * Decompiled with CFR 0.152.
 */
package es.jlg.crypt.gui.wizard;

import es.jlg.crypt.gui.CryptMain;
import es.jlg.crypt.gui.wizard.FileDataPage;
import es.jlg.crypt.gui.wizard.KeyPage;
import es.jlg.crypt.logic.BlowfishEncrypter;
import es.jlg.crypt.logic.DesEncrypter;
import es.jlg.crypt.utils.Messages;
import es.jlg.crypt.utils.Zipper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Date;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;

public class DWizard
extends Wizard {
    public static final String DECODER_KIND = "D";
    private static final String DECODER_EXTENSION = ".dcp";
    private static final String DECODE_TOOL_SUCCESSFUL_MESSAGE = Messages.getString("DWizard.DecodeSuccessful");
    private FileDataPage fileDataPage;
    private KeyPage keyPage;
    private ISelection selection;

    public DWizard() {
        this.setNeedsProgressMonitor(true);
        ImageDescriptor imageDesc = ImageDescriptor.createFromFile(null, "img/new_wiz.gif");
        this.setDefaultPageImageDescriptor(imageDesc);
        this.setWindowTitle(Messages.getString("DesEncrypFileAction.DesEncrypText"));
    }

    public void addPages() {
        if (this.fileDataPage == null) {
            this.fileDataPage = new FileDataPage(this.selection, false);
            this.addPage(this.fileDataPage);
        }
        if (this.keyPage == null) {
            this.keyPage = new KeyPage(this.selection, false);
            this.addPage(this.keyPage);
        }
    }

    public boolean performFinish() {
        try {
            SecretKeySpec desKey = new SecretKeySpec(this.keyPage.getKeyText().getText().getBytes(), this.keyPage.getComboAlg().getText());
            String p = this.fileDataPage.getUrlText().getText();
            p = p.replace('\\', '/');
            if (this.keyPage.getComboAlg().getText().trim().equals("DES")) {
                DesEncrypter encrypter = new DesEncrypter(desKey);
                encrypter.decrypt(new FileInputStream(p), new FileOutputStream(String.valueOf(p) + DECODER_EXTENSION));
            } else if (this.keyPage.getComboAlg().getText().trim().equals("Blowfish")) {
                BlowfishEncrypter encrypter = new BlowfishEncrypter(desKey);
                encrypter.decrypt(new FileInputStream(p), new FileOutputStream(String.valueOf(p) + DECODER_EXTENSION));
            }
            CryptMain.addTableItem(p, String.valueOf(p) + DECODER_EXTENSION, DECODER_KIND, this.keyPage.getComboAlg().getText(), new Date());
            CryptMain.setStatusMessage(DECODE_TOOL_SUCCESSFUL_MESSAGE);
        }
        catch (FileNotFoundException e) {
            MessageDialog.openError(Display.getCurrent().getActiveShell(), Messages.getString("DWizard.Error"), Messages.getString("DWizard.Error"));
            e.printStackTrace();
        }
        catch (Exception e) {
            MessageDialog.openError(Display.getCurrent().getActiveShell(), Messages.getString("DWizard.Error"), Messages.getString("DWizard.Error"));
            e.printStackTrace();
        }
        return true;
    }

    private void deleteFileWithURL(String p) {
        if (this.keyPage.getButtonCBDeleteSource().getSelection()) {
            File inputFile = new File(p);
            if (!inputFile.delete()) {
                MessageDialog.openError(Display.getCurrent().getActiveShell(), Messages.getString("DWizard.ErrorDeleteFile"), String.valueOf(Messages.getString("DWizard.ErrorDeleteFile")) + ": " + p);
            }
            if (!(inputFile = new File(p = String.valueOf(p) + DECODER_EXTENSION)).delete()) {
                MessageDialog.openError(Display.getCurrent().getActiveShell(), Messages.getString("DWizard.ErrorDeleteFile"), String.valueOf(Messages.getString("DWizard.ErrorDeleteFile")) + ": " + p);
            }
        }
    }

    private String unzipOutputFile(String p) {
        String outFileName = p = p.replaceAll(".cp.dcp", "");
        if (this.keyPage.getButtonCBzipFile().getSelection()) {
            Zipper.unzip(p);
        }
        return outFileName;
    }
}

