/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.transaction.Synchronization;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.transaction.TransactionFactory;

public class JDBCTransaction
implements Transaction {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$transaction$JDBCTransaction == null ? (class$org$hibernate$transaction$JDBCTransaction = JDBCTransaction.class$("org.hibernate.transaction.JDBCTransaction")) : class$org$hibernate$transaction$JDBCTransaction));
    private final JDBCContext jdbcContext;
    private final TransactionFactory.Context transactionContext;
    private boolean toggleAutoCommit;
    private boolean rolledBack;
    private boolean committed;
    private boolean begun;
    private boolean commitFailed;
    private List synchronizations;
    private boolean synchronization;
    static /* synthetic */ Class class$org$hibernate$transaction$JDBCTransaction;

    public JDBCTransaction(JDBCContext jdbcContext, TransactionFactory.Context transactionContext) {
        this.jdbcContext = jdbcContext;
        this.transactionContext = transactionContext;
    }

    public void begin() throws HibernateException {
        log.debug((Object)"begin");
        try {
            this.toggleAutoCommit = this.jdbcContext.connection().getAutoCommit();
            if (log.isDebugEnabled()) {
                log.debug((Object)("current autocommit status: " + this.toggleAutoCommit));
            }
            if (this.toggleAutoCommit) {
                log.debug((Object)"disabling autocommit");
                this.jdbcContext.connection().setAutoCommit(false);
            }
        }
        catch (SQLException e) {
            log.error((Object)"JDBC begin failed", (Throwable)e);
            throw new TransactionException("JDBC begin failed: ", e);
        }
        this.synchronization = !this.jdbcContext.registerCallbackIfNecessary();
        this.begun = true;
    }

    private void closeIfRequired() throws HibernateException {
        if (!this.synchronization && this.transactionContext.shouldAutoClose() && this.transactionContext.isOpen()) {
            try {
                this.transactionContext.managedClose();
            }
            catch (HibernateException he) {
                log.error((Object)"Could not close session", (Throwable)he);
            }
        }
    }

    public void commit() throws HibernateException {
        if (!this.begun) {
            throw new TransactionException("Transaction not successfully started");
        }
        log.debug((Object)"commit");
        if (!this.transactionContext.isFlushModeNever() && !this.synchronization) {
            this.transactionContext.managedFlush();
        }
        this.beforeTransactionCompletion();
        if (!this.synchronization) {
            this.jdbcContext.beforeTransactionCompletion(this);
        }
        try {
            this.jdbcContext.connection().commit();
            log.debug((Object)"committed JDBC Connection");
            this.committed = true;
            if (!this.synchronization) {
                this.jdbcContext.afterTransactionCompletion(true, this);
            }
            this.afterTransactionCompletion(3);
        }
        catch (SQLException e) {
            log.error((Object)"JDBC commit failed", (Throwable)e);
            this.commitFailed = true;
            if (!this.synchronization) {
                this.jdbcContext.afterTransactionCompletion(false, this);
            }
            this.afterTransactionCompletion(5);
            throw new TransactionException("JDBC commit failed", e);
        }
        finally {
            this.toggleAutoCommit();
            this.closeIfRequired();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rollback() throws HibernateException {
        if (!this.begun) {
            throw new TransactionException("Transaction not successfully started");
        }
        log.debug((Object)"rollback");
        if (this.commitFailed) return;
        this.beforeTransactionCompletion();
        if (!this.synchronization) {
            this.jdbcContext.beforeTransactionCompletion(this);
        }
        try {
            try {
                this.jdbcContext.connection().rollback();
                log.debug((Object)"rolled back JDBC Connection");
                this.rolledBack = true;
                this.afterTransactionCompletion(4);
            }
            catch (SQLException e) {
                log.error((Object)"JDBC rollback failed", (Throwable)e);
                this.afterTransactionCompletion(5);
                throw new TransactionException("JDBC rollback failed", e);
            }
            Object var3_1 = null;
            if (!this.synchronization) {
                this.jdbcContext.afterTransactionCompletion(false, this);
            }
            this.toggleAutoCommit();
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            if (!this.synchronization) {
                this.jdbcContext.afterTransactionCompletion(false, this);
            }
            this.toggleAutoCommit();
            this.closeIfRequired();
            throw throwable;
        }
        this.closeIfRequired();
    }

    private void toggleAutoCommit() {
        try {
            if (this.toggleAutoCommit) {
                log.debug((Object)"re-enabling autocommit");
                this.jdbcContext.connection().setAutoCommit(true);
            }
        }
        catch (Exception sqle) {
            log.error((Object)"Could not toggle autocommit", (Throwable)sqle);
        }
    }

    public boolean wasRolledBack() {
        return this.rolledBack;
    }

    public boolean wasCommitted() {
        return this.committed;
    }

    public void registerSynchronization(Synchronization sync) throws HibernateException {
        if (sync == null) {
            throw new NullPointerException("null Synchronization");
        }
        if (this.synchronizations == null) {
            this.synchronizations = new ArrayList();
        }
        this.synchronizations.add(sync);
    }

    private void beforeTransactionCompletion() {
        if (this.synchronizations != null) {
            for (int i = 0; i < this.synchronizations.size(); ++i) {
                Synchronization sync = (Synchronization)this.synchronizations.get(i);
                try {
                    sync.beforeCompletion();
                    continue;
                }
                catch (Throwable t) {
                    log.error((Object)"exception calling user Synchronization", t);
                }
            }
        }
    }

    private void afterTransactionCompletion(int status) {
        if (this.synchronizations != null) {
            for (int i = 0; i < this.synchronizations.size(); ++i) {
                Synchronization sync = (Synchronization)this.synchronizations.get(i);
                try {
                    sync.afterCompletion(status);
                    continue;
                }
                catch (Throwable t) {
                    log.error((Object)"exception calling user Synchronization", t);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

