/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.proxy;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.LazyInitializationException;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.proxy.LazyInitializer;

public abstract class AbstractLazyInitializer
implements LazyInitializer {
    private Object target;
    private String entityName;
    private Serializable id;
    private transient SessionImplementor session;

    protected AbstractLazyInitializer(String entityName, Serializable id, SessionImplementor session) {
        this.id = id;
        this.session = session;
        this.entityName = entityName;
    }

    public final Serializable getIdentifier() {
        return this.id;
    }

    public final void setIdentifier(Serializable id) {
        this.id = id;
    }

    public final String getEntityName() {
        return this.entityName;
    }

    public final boolean isUninitialized() {
        return this.target == null;
    }

    public final SessionImplementor getSession() {
        return this.session;
    }

    public final void initialize() throws HibernateException {
        if (this.target == null) {
            if (this.session == null) {
                throw new LazyInitializationException("could not initialize proxy - no Session");
            }
            if (!this.session.isOpen()) {
                throw new LazyInitializationException("could not initialize proxy - the owning Session was closed");
            }
            if (!this.session.isConnected()) {
                throw new LazyInitializationException("could not initialize proxy - the owning Session is disconnected");
            }
            this.target = this.session.immediateLoad(this.entityName, this.id);
        }
    }

    public final void setSession(SessionImplementor s) throws HibernateException {
        if (s != this.session) {
            if (this.session != null && this.session.isOpen()) {
                throw new HibernateException("illegally attempted to associate a proxy with two open Sessions");
            }
            this.session = s;
        }
    }

    public final Object getImplementation() {
        this.initialize();
        return this.target;
    }

    public final Object getImplementation(SessionImplementor s) throws HibernateException {
        return s.getPersistenceContext().getEntity(new EntityKey(this.getIdentifier(), s.getFactory().getEntityPersister(this.getEntityName()), s.getEntityMode()));
    }

    protected final void setTarget(Object target) {
        this.target = target;
    }

    protected final Object getTarget() {
        return this.target;
    }
}

