/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Iterator;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.type.CollectionType;
import org.hibernate.type.TypeFactory;

public class Set
extends Collection {
    public Set(PersistentClass owner) {
        super(owner);
    }

    public boolean isSet() {
        return true;
    }

    public CollectionType getDefaultCollectionType() {
        return this.isSorted() ? TypeFactory.sortedSet(this.getRole(), this.getReferencedPropertyName(), this.isEmbedded(), this.getComparator()) : TypeFactory.set(this.getRole(), this.getReferencedPropertyName(), this.isEmbedded());
    }

    void createPrimaryKey() {
        if (!this.isOneToMany()) {
            PrimaryKey pk = new PrimaryKey();
            pk.addColumns(this.getKey().getColumnIterator());
            boolean nullable = false;
            Iterator iter = this.getElement().getColumnIterator();
            while (iter.hasNext()) {
                Column col = (Column)iter.next();
                if (col.isNullable()) {
                    nullable = true;
                }
                pk.addColumn(col);
            }
            if (!nullable) {
                this.getCollectionTable().setPrimaryKey(pk);
            }
        }
    }

    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }
}

