/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.type.Type;
import org.hibernate.util.ReflectHelper;

public final class IdentifierGeneratorFactory {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$id$IdentifierGeneratorFactory == null ? (class$org$hibernate$id$IdentifierGeneratorFactory = IdentifierGeneratorFactory.class$("org.hibernate.id.IdentifierGeneratorFactory")) : class$org$hibernate$id$IdentifierGeneratorFactory));
    private static final HashMap GENERATORS = new HashMap();
    public static final String SHORT_CIRCUIT_INDICATOR = new String();
    public static final String POST_INSERT_INDICATOR = new String();
    static /* synthetic */ Class class$org$hibernate$id$IdentifierGeneratorFactory;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$hibernate$id$UUIDHexGenerator;
    static /* synthetic */ Class class$org$hibernate$id$TableHiLoGenerator;
    static /* synthetic */ Class class$org$hibernate$id$Assigned;
    static /* synthetic */ Class class$org$hibernate$id$IdentityGenerator;
    static /* synthetic */ Class class$org$hibernate$id$SelectGenerator;
    static /* synthetic */ Class class$org$hibernate$id$SequenceGenerator;
    static /* synthetic */ Class class$org$hibernate$id$SequenceHiLoGenerator;
    static /* synthetic */ Class class$org$hibernate$id$IncrementGenerator;
    static /* synthetic */ Class class$org$hibernate$id$ForeignGenerator;
    static /* synthetic */ Class class$org$hibernate$id$GUIDGenerator;

    public static Serializable getGeneratedIdentity(ResultSet rs, Type type) throws SQLException, HibernateException, IdentifierGenerationException {
        if (!rs.next()) {
            throw new HibernateException("The database returned no natively generated identity value");
        }
        Serializable id = IdentifierGeneratorFactory.get(rs, type);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Natively generated identity: " + id));
        }
        return id;
    }

    public static Serializable get(ResultSet rs, Type type) throws SQLException, IdentifierGenerationException {
        Class clazz = type.getReturnedClass();
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = IdentifierGeneratorFactory.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long(rs.getLong(1));
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = IdentifierGeneratorFactory.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer(rs.getInt(1));
        }
        if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = IdentifierGeneratorFactory.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new Short(rs.getShort(1));
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = IdentifierGeneratorFactory.class$("java.lang.String")) : class$java$lang$String)) {
            return rs.getString(1);
        }
        throw new IdentifierGenerationException("this id generator generates long, integer, short or string");
    }

    public static IdentifierGenerator create(String strategy, Type type, Properties params, Dialect dialect) throws MappingException {
        try {
            IdentifierGenerator idgen;
            Class clazz = (Class)GENERATORS.get(strategy);
            if ("native".equals(strategy)) {
                clazz = dialect.getNativeIdentifierGeneratorClass();
            }
            if (clazz == null) {
                clazz = ReflectHelper.classForName(strategy);
            }
            if ((idgen = (IdentifierGenerator)clazz.newInstance()) instanceof Configurable) {
                ((Configurable)((Object)idgen)).configure(type, params, dialect);
            }
            return idgen;
        }
        catch (Exception e) {
            throw new MappingException("could not instantiate id generator", e);
        }
    }

    public static Number createNumber(long value, Class clazz) throws IdentifierGenerationException {
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = IdentifierGeneratorFactory.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long(value);
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = IdentifierGeneratorFactory.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer((int)value);
        }
        if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = IdentifierGeneratorFactory.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new Short((short)value);
        }
        throw new IdentifierGenerationException("this id generator generates long, integer, short");
    }

    private IdentifierGeneratorFactory() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        GENERATORS.put("uuid", class$org$hibernate$id$UUIDHexGenerator == null ? (class$org$hibernate$id$UUIDHexGenerator = IdentifierGeneratorFactory.class$("org.hibernate.id.UUIDHexGenerator")) : class$org$hibernate$id$UUIDHexGenerator);
        GENERATORS.put("hilo", class$org$hibernate$id$TableHiLoGenerator == null ? (class$org$hibernate$id$TableHiLoGenerator = IdentifierGeneratorFactory.class$("org.hibernate.id.TableHiLoGenerator")) : class$org$hibernate$id$TableHiLoGenerator);
        GENERATORS.put("assigned", class$org$hibernate$id$Assigned == null ? (class$org$hibernate$id$Assigned = IdentifierGeneratorFactory.class$("org.hibernate.id.Assigned")) : class$org$hibernate$id$Assigned);
        GENERATORS.put("identity", class$org$hibernate$id$IdentityGenerator == null ? (class$org$hibernate$id$IdentityGenerator = IdentifierGeneratorFactory.class$("org.hibernate.id.IdentityGenerator")) : class$org$hibernate$id$IdentityGenerator);
        GENERATORS.put("select", class$org$hibernate$id$SelectGenerator == null ? (class$org$hibernate$id$SelectGenerator = IdentifierGeneratorFactory.class$("org.hibernate.id.SelectGenerator")) : class$org$hibernate$id$SelectGenerator);
        GENERATORS.put("sequence", class$org$hibernate$id$SequenceGenerator == null ? (class$org$hibernate$id$SequenceGenerator = IdentifierGeneratorFactory.class$("org.hibernate.id.SequenceGenerator")) : class$org$hibernate$id$SequenceGenerator);
        GENERATORS.put("seqhilo", class$org$hibernate$id$SequenceHiLoGenerator == null ? (class$org$hibernate$id$SequenceHiLoGenerator = IdentifierGeneratorFactory.class$("org.hibernate.id.SequenceHiLoGenerator")) : class$org$hibernate$id$SequenceHiLoGenerator);
        GENERATORS.put("increment", class$org$hibernate$id$IncrementGenerator == null ? (class$org$hibernate$id$IncrementGenerator = IdentifierGeneratorFactory.class$("org.hibernate.id.IncrementGenerator")) : class$org$hibernate$id$IncrementGenerator);
        GENERATORS.put("foreign", class$org$hibernate$id$ForeignGenerator == null ? (class$org$hibernate$id$ForeignGenerator = IdentifierGeneratorFactory.class$("org.hibernate.id.ForeignGenerator")) : class$org$hibernate$id$ForeignGenerator);
        GENERATORS.put("guid", class$org$hibernate$id$GUIDGenerator == null ? (class$org$hibernate$id$GUIDGenerator = IdentifierGeneratorFactory.class$("org.hibernate.id.GUIDGenerator")) : class$org$hibernate$id$GUIDGenerator);
        GENERATORS.put("uuid.hex", class$org$hibernate$id$UUIDHexGenerator == null ? (class$org$hibernate$id$UUIDHexGenerator = IdentifierGeneratorFactory.class$("org.hibernate.id.UUIDHexGenerator")) : class$org$hibernate$id$UUIDHexGenerator);
    }
}

