/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.TypedValue;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.hql.ast.HqlSqlWalker;
import org.hibernate.type.Type;

public class UpdateStatementExecutor {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$hql$ast$UpdateStatementExecutor == null ? (class$org$hibernate$hql$ast$UpdateStatementExecutor = UpdateStatementExecutor.class$("org.hibernate.hql.ast.UpdateStatementExecutor")) : class$org$hibernate$hql$ast$UpdateStatementExecutor));
    private String sql;
    private HqlSqlWalker walker;
    private SessionFactoryImplementor factory;
    static /* synthetic */ Class class$org$hibernate$hql$ast$UpdateStatementExecutor;

    public UpdateStatementExecutor(String sql, HqlSqlWalker walker, SessionFactoryImplementor factory) {
        this.sql = sql;
        this.walker = walker;
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public int execute(QueryParameters parameters, SessionImplementor session) throws HibernateException {
        PreparedStatement st = null;
        try {
            int n;
            block5: {
                try {
                    st = session.getBatcher().prepareStatement(this.sql);
                    int col = 1;
                    col += this.bindPositionalParameters(st, parameters, col, session);
                    col += this.bindNamedParameters(st, parameters.getNamedParameters(), col, session);
                    n = st.executeUpdate();
                    Object var7_7 = null;
                    if (st == null) break block5;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    if (st != null) {
                        session.getBatcher().closeStatement(st);
                    }
                    throw throwable;
                }
                session.getBatcher().closeStatement(st);
            }
            return n;
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sqle, "could not execute update query", this.sql);
        }
    }

    private int bindPositionalParameters(PreparedStatement st, QueryParameters queryParameters, int start, SessionImplementor session) throws SQLException, HibernateException {
        Object[] values = queryParameters.getPositionalParameterValues();
        Type[] types = queryParameters.getPositionalParameterTypes();
        int span = 0;
        for (int i = 0; i < values.length; ++i) {
            types[i].nullSafeSet(st, values[i], start + span, session);
            span += types[i].getColumnSpan(this.factory);
        }
        return span;
    }

    private int bindNamedParameters(PreparedStatement ps, Map namedParams, int start, SessionImplementor session) throws SQLException, HibernateException {
        if (namedParams != null) {
            Iterator iter = namedParams.entrySet().iterator();
            int result = 0;
            while (iter.hasNext()) {
                Map.Entry e = iter.next();
                String name = (String)e.getKey();
                TypedValue typedval = (TypedValue)e.getValue();
                int[] locs = this.walker.getNamedParameterLocs(name);
                for (int i = 0; i < locs.length; ++i) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("bindNamedParameters() " + typedval.getValue() + " -> " + name + " [" + (locs[i] + start) + "]"));
                    }
                    typedval.getType().nullSafeSet(ps, typedval.getValue(), locs[i] + start, session);
                }
                result += locs.length;
            }
            return result;
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

