/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import antlr.SemanticException;
import antlr.collections.AST;
import java.util.List;
import org.hibernate.hql.ast.DotNode;
import org.hibernate.hql.ast.FromElement;
import org.hibernate.hql.ast.FromReferenceNode;
import org.hibernate.hql.ast.SelectExpression;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;

class IdentNode
extends FromReferenceNode
implements SelectExpression {
    private boolean nakedPropertyRef = false;

    IdentNode() {
    }

    public void resolveIndex(AST parent) throws SemanticException {
        throw new UnsupportedOperationException();
    }

    public void resolve(boolean generateJoin, boolean implicitJoin, String classAlias, AST parent) {
        if (!this.isResolved()) {
            if (this.getWalker().getCurrentFromClause().isFromElementAlias(this.getText())) {
                if (this.resolveAsAlias()) {
                    this.setResolved();
                }
            } else if (parent != null && parent.getType() == 15) {
                DotNode dot = (DotNode)parent;
                if (parent.getFirstChild() == this) {
                    if (this.resolveAsNakedComponentPropertyRefLHS(dot)) {
                        this.setResolved();
                    }
                } else if (this.resolveAsNakedComponentPropertyRefRHS(dot)) {
                    this.setResolved();
                }
            } else if (this.resolveAsNakedPropertyRef()) {
                this.setResolved();
            }
            if (!this.isResolved() && !this.getWalker().getCurrentFromClause().isFromElementAlias(this.getText())) {
                try {
                    this.getWalker().processConstant((AST)this);
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
        }
    }

    private boolean resolveAsAlias() {
        FromElement element = this.getWalker().getCurrentFromClause().getFromElement(this.getText());
        if (element != null) {
            this.setFromElement(element);
            this.setText(element.getIdentityColumn());
            this.setType(121);
            return true;
        }
        return false;
    }

    private boolean resolveAsNakedPropertyRef() {
        FromElement fromElement = this.locateSingleFromElement();
        if (fromElement == null) {
            return false;
        }
        Queryable persister = fromElement.getQueryable();
        if (persister == null) {
            return false;
        }
        String property = this.getText();
        Type propertyType = null;
        try {
            propertyType = fromElement.getPropertyType(this.getText(), property);
        }
        catch (Throwable t) {
            return false;
        }
        this.setFromElement(fromElement);
        if (persister != null) {
            String[] columns = this.getWalker().isSelectStatement() ? persister.toColumns(fromElement.getTableAlias(), property) : persister.toColumns(property);
            this.setText(StringHelper.join(", ", columns));
            this.setType(123);
        }
        super.setDataType(propertyType);
        this.nakedPropertyRef = true;
        return true;
    }

    private boolean resolveAsNakedComponentPropertyRefLHS(DotNode parent) {
        FromElement fromElement = this.locateSingleFromElement();
        if (fromElement == null) {
            return false;
        }
        String propertyPath = this.getText() + "." + this.getNextSibling().getText();
        Type propertyType = null;
        try {
            propertyType = fromElement.getPropertyType(this.getText(), propertyPath);
        }
        catch (Throwable t) {
            return false;
        }
        this.setFromElement(fromElement);
        parent.setPropertyPath(propertyPath);
        parent.setDataType(propertyType);
        return true;
    }

    private boolean resolveAsNakedComponentPropertyRefRHS(DotNode parent) {
        FromElement fromElement = this.locateSingleFromElement();
        if (fromElement == null) {
            return false;
        }
        Type propertyType = null;
        String propertyPath = parent.getLhs().getText() + "." + this.getText();
        try {
            propertyType = fromElement.getPropertyType(this.getText(), propertyPath);
        }
        catch (Throwable t) {
            return false;
        }
        this.setFromElement(fromElement);
        super.setDataType(propertyType);
        this.nakedPropertyRef = true;
        return true;
    }

    private FromElement locateSingleFromElement() {
        List fromElements = this.getWalker().getCurrentFromClause().getFromElements();
        if (fromElements == null || fromElements.size() != 1) {
            return null;
        }
        FromElement element = (FromElement)fromElements.get(0);
        if (element.getClassAlias() != null) {
            return null;
        }
        return element;
    }

    public Type getDataType() {
        Type type = super.getDataType();
        return type == null && this.getFromElement() != null ? this.getFromElement().getDataType() : type;
    }

    public void setScalarColumnText(int i) throws SemanticException {
        if (!this.nakedPropertyRef) {
            this.setText(this.getFromElement().renderScalarIdentifierSelect(i));
        }
    }

    public boolean isReturnableEntity() throws SemanticException {
        return !this.nakedPropertyRef;
    }

    public String getDisplayText() {
        StringBuffer buf = new StringBuffer();
        if (this.getType() == 121) {
            buf.append("{alias=").append(this.getOriginalText());
            if (this.getFromElement() == null) {
                buf.append(", no from element");
            } else {
                buf.append(", className=").append(this.getFromElement().getClassName());
                buf.append(", tableAlias=").append(this.getFromElement().getTableAlias());
            }
            buf.append("}");
        } else {
            buf.append("{originalText=" + this.getOriginalText()).append("}");
        }
        return buf.toString();
    }
}

