/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import antlr.ASTPair;
import antlr.MismatchedTokenException;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.hql.antlr.HqlBaseParser;
import org.hibernate.hql.ast.ASTPrinter;
import org.hibernate.hql.ast.ASTUtil;
import org.hibernate.hql.ast.ErrorCounter;
import org.hibernate.hql.ast.HqlLexer;
import org.hibernate.hql.ast.HqlToken;
import org.hibernate.hql.ast.ParseErrorHandler;

public final class HqlParser
extends HqlBaseParser {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$hql$ast$HqlParser == null ? (class$org$hibernate$hql$ast$HqlParser = HqlParser.class$("org.hibernate.hql.ast.HqlParser")) : class$org$hibernate$hql$ast$HqlParser));
    private ParseErrorHandler parseErrorHandler;
    private ASTPrinter printer = HqlParser.getASTPrinter();
    static /* synthetic */ Class class$org$hibernate$hql$ast$HqlParser;
    static /* synthetic */ Class class$org$hibernate$hql$antlr$HqlTokenTypes;

    private static ASTPrinter getASTPrinter() {
        return new ASTPrinter(class$org$hibernate$hql$antlr$HqlTokenTypes == null ? (class$org$hibernate$hql$antlr$HqlTokenTypes = HqlParser.class$("org.hibernate.hql.antlr.HqlTokenTypes")) : class$org$hibernate$hql$antlr$HqlTokenTypes);
    }

    public static HqlParser getInstance(String hql) {
        HqlLexer lexer = new HqlLexer(new DataInputStream(new ByteArrayInputStream(hql.getBytes())));
        HqlParser parser = new HqlParser(lexer);
        return parser;
    }

    private HqlParser(TokenStream lexer) {
        super(lexer);
        this.initialize();
    }

    public void reportError(RecognitionException e) {
        this.parseErrorHandler.reportError(e);
    }

    public void reportError(String s) {
        this.parseErrorHandler.reportError(s);
    }

    public void reportWarning(String s) {
        this.parseErrorHandler.reportWarning(s);
    }

    public ParseErrorHandler getParseErrorHandler() {
        return this.parseErrorHandler;
    }

    public AST handleIdentifierError(Token token, RecognitionException ex) throws RecognitionException, TokenStreamException {
        HqlToken hqlToken;
        if (token instanceof HqlToken && (hqlToken = (HqlToken)token).isPossibleID() && ex instanceof MismatchedTokenException) {
            MismatchedTokenException mte = (MismatchedTokenException)ex;
            if (mte.expecting == 109) {
                this.reportWarning("Keyword  '" + token.getText() + "' is being intepreted as an identifier due to: " + mte.getMessage());
                ASTPair currentAST = new ASTPair();
                token.setType(80);
                this.astFactory.addASTChild(currentAST, this.astFactory.create(token));
                this.consume();
                AST identifierAST = currentAST.root;
                return identifierAST;
            }
        }
        return super.handleIdentifierError(token, ex);
    }

    public AST negateNode(AST x) {
        switch (x.getType()) {
            case 38: {
                x.setType(6);
                x.setText("{and}");
                this.negateNode(x.getFirstChild());
                this.negateNode(x.getFirstChild().getNextSibling());
                return x;
            }
            case 6: {
                x.setType(38);
                x.setText("{or}");
                this.negateNode(x.getFirstChild());
                this.negateNode(x.getFirstChild().getNextSibling());
                return x;
            }
            case 86: {
                x.setType(92);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 92: {
                x.setType(86);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 95: {
                x.setType(96);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 94: {
                x.setType(97);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 97: {
                x.setType(94);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 96: {
                x.setType(95);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 32: {
                x.setType(74);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 74: {
                x.setType(32);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 70: {
                x.setType(69);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 69: {
                x.setType(70);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 10: {
                x.setType(72);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 72: {
                x.setType(10);
                x.setText("{not}" + x.getText());
                return x;
            }
        }
        return super.negateNode(x);
    }

    public AST processEqualityExpression(AST x) {
        if (x == null) {
            log.warn((Object)"processEqualityExpression() : No expression to process!");
            return null;
        }
        int type = x.getType();
        if (type == 86 || type == 92) {
            boolean negated;
            boolean bl = negated = type == 92;
            if (x.getNumberOfChildren() == 2) {
                AST a = x.getFirstChild();
                AST b = a.getNextSibling();
                if (a.getType() == 37 && b.getType() != 37) {
                    return this.createIsNullParent(b, negated);
                }
                if (b.getType() == 37 && a.getType() != 37) {
                    return this.createIsNullParent(a, negated);
                }
                if (b.getType() == 56) {
                    return this.processIsEmpty(a, negated);
                }
                return x;
            }
            return x;
        }
        return x;
    }

    private AST createIsNullParent(AST node, boolean negated) {
        node.setNextSibling(null);
        int type = negated ? 69 : 70;
        String text = negated ? "is not null" : "is null";
        return ASTUtil.createParent(this.astFactory, type, text, node);
    }

    private AST processIsEmpty(AST node, boolean negated) {
        node.setNextSibling(null);
        AST ast = this.createSubquery(node);
        ast = ASTUtil.createParent(this.astFactory, 19, "exists", ast);
        if (!negated) {
            ast = ASTUtil.createParent(this.astFactory, 36, "not", ast);
        }
        return ast;
    }

    private AST createSubquery(AST node) {
        AST ast = ASTUtil.createParent(this.astFactory, 22, "from", node);
        ast = ASTUtil.createParent(this.astFactory, 77, "SELECT_FROM", ast);
        ast = ASTUtil.createParent(this.astFactory, 76, "QUERY", ast);
        return ast;
    }

    public void showAst(AST ast, PrintStream out) {
        this.showAst(ast, new PrintWriter(out));
    }

    private void showAst(AST ast, PrintWriter pw) {
        this.printer.showAst(ast, pw);
    }

    private void initialize() {
        this.parseErrorHandler = new ErrorCounter();
    }

    public void weakKeywords() throws TokenStreamException {
        int t = this.LA(1);
        switch (t) {
            case 24: 
            case 39: {
                if (this.LA(2) == 89) break;
                this.LT(1).setType(109);
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("weakKeywords() : new LT(1) token - " + this.LT(1)));
                break;
            }
        }
    }

    public void processMemberOf(Token n, AST p, ASTPair currentAST) {
        AST inAst = n == null ? this.astFactory.create(26, "in") : this.astFactory.create(73, "not in");
        this.astFactory.makeASTRoot(currentAST, inAst);
        AST ast = this.createSubquery(p);
        ast = ASTUtil.createParent(this.astFactory, 67, "inList", ast);
        inAst.addChild(ast);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

