/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import antlr.SemanticException;
import antlr.collections.AST;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.hql.ast.DetailedSemanticException;
import org.hibernate.hql.ast.FromElement;
import org.hibernate.hql.ast.PathNode;
import org.hibernate.hql.ast.SelectExpression;
import org.hibernate.hql.ast.SelectExpressionList;
import org.hibernate.type.Type;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;

public class ConstructorNode
extends SelectExpressionList
implements SelectExpression {
    private Constructor constructor;
    private Type[] constructorArgumentTypes;

    public void setScalarColumnText(int i) throws SemanticException {
        SelectExpression[] selectExpressions = this.collectSelectExpressions();
        for (int j = 0; j < selectExpressions.length; ++j) {
            SelectExpression selectExpression = selectExpressions[j];
            selectExpression.setScalarColumnText(j);
        }
    }

    protected AST getFirstSelectExpression() {
        return this.getFirstChild().getNextSibling();
    }

    public Type getDataType() {
        throw new UnsupportedOperationException("getDataType() is not supported by ConstructorNode!");
    }

    public void prepare() throws SemanticException {
        this.constructorArgumentTypes = this.resolveConstructorArgumentTypes();
        this.constructor = this.resolveConstructor();
    }

    private Type[] resolveConstructorArgumentTypes() throws SemanticException {
        SelectExpression[] argumentExpressions = this.collectSelectExpressions();
        if (argumentExpressions == null) {
            return new Type[0];
        }
        Type[] types = new Type[argumentExpressions.length];
        for (int x = 0; x < argumentExpressions.length; ++x) {
            types[x] = argumentExpressions[x].getDataType();
        }
        return types;
    }

    private Constructor resolveConstructor() throws SemanticException {
        String className;
        String path = ((PathNode)this.getFirstChild()).getPath();
        String importedClassName = this.getSessionFactoryHelper().getImportedClassName(path);
        String string = className = StringHelper.isEmpty(importedClassName) ? path : importedClassName;
        if (className == null) {
            throw new SemanticException("Unable to locate class [" + path + "]");
        }
        try {
            Class holderClass = ReflectHelper.classForName(className);
            return ReflectHelper.getConstructor(holderClass, this.constructorArgumentTypes);
        }
        catch (ClassNotFoundException e) {
            throw new DetailedSemanticException("Unable to locate class [" + className + "]", e);
        }
        catch (PropertyNotFoundException e) {
            throw new DetailedSemanticException("Unable to locate appropriate constructor on class [" + className + "]", e);
        }
    }

    public Constructor getConstructor() {
        return this.constructor;
    }

    public List getConstructorArgumentTypeList() {
        return Arrays.asList(this.constructorArgumentTypes);
    }

    public FromElement getFromElement() {
        return null;
    }

    public boolean isConstructor() {
        return true;
    }

    public boolean isReturnableEntity() throws SemanticException {
        return false;
    }

    public boolean isScalar() {
        return true;
    }
}

