/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.action.CollectionRecreateAction;
import org.hibernate.action.CollectionRemoveAction;
import org.hibernate.action.CollectionUpdateAction;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.Cascades;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.engine.CollectionKey;
import org.hibernate.engine.Collections;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.event.FlushEntityEvent;
import org.hibernate.event.FlushEvent;
import org.hibernate.event.def.AbstractEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.Printer;
import org.hibernate.util.IdentityMap;

public abstract class AbstractFlushingEventListener
extends AbstractEventListener {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$event$def$AbstractFlushingEventListener == null ? (class$org$hibernate$event$def$AbstractFlushingEventListener = AbstractFlushingEventListener.class$("org.hibernate.event.def.AbstractFlushingEventListener")) : class$org$hibernate$event$def$AbstractFlushingEventListener));
    static /* synthetic */ Class class$org$hibernate$event$def$AbstractFlushingEventListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushEverythingToExecutions(FlushEvent event) throws HibernateException {
        log.trace((Object)"flushing session");
        SessionImplementor session = event.getSession();
        PersistenceContext persistenceContext = session.getPersistenceContext();
        session.getInterceptor().preFlush(persistenceContext.getEntitiesByKey().values().iterator());
        this.prepareEntityFlushes(session);
        this.prepareCollectionFlushes(session);
        persistenceContext.setFlushing(true);
        try {
            this.flushEntities(event);
            this.flushCollections(session);
        }
        finally {
            persistenceContext.setFlushing(false);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Flushed: " + session.getActionQueue().numberOfInsertions() + " insertions, " + session.getActionQueue().numberOfUpdates() + " updates, " + session.getActionQueue().numberOfDeletions() + " deletions to " + persistenceContext.getEntityEntries().size() + " objects"));
            log.debug((Object)("Flushed: " + session.getActionQueue().numberOfCollectionCreations() + " (re)creations, " + session.getActionQueue().numberOfCollectionUpdates() + " updates, " + session.getActionQueue().numberOfCollectionRemovals() + " removals to " + persistenceContext.getCollectionEntries().size() + " collections"));
            new Printer(session.getFactory()).toString(persistenceContext.getEntitiesByKey().values().iterator(), session.getEntityMode());
        }
    }

    private void prepareEntityFlushes(SessionImplementor session) throws HibernateException {
        log.debug((Object)"processing flush-time cascades");
        Map.Entry[] list = IdentityMap.concurrentEntries(session.getPersistenceContext().getEntityEntries());
        int size = list.length;
        for (int i = 0; i < size; ++i) {
            Map.Entry me = list[i];
            EntityEntry entry = (EntityEntry)me.getValue();
            Status status = entry.getStatus();
            if (status != Status.MANAGED && status != Status.SAVING) continue;
            this.cascadeOnFlush(session, entry.getPersister(), me.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cascadeOnFlush(SessionImplementor session, EntityPersister persister, Object object) throws HibernateException {
        session.getPersistenceContext().incrementCascadeLevel();
        try {
            Cascades.cascade(session, persister, object, this.getCascadingAction(), 0, this.getAnything());
        }
        finally {
            session.getPersistenceContext().decrementCascadeLevel();
        }
    }

    protected Object getAnything() {
        return null;
    }

    protected Cascades.CascadingAction getCascadingAction() {
        return Cascades.ACTION_SAVE_UPDATE;
    }

    private void prepareCollectionFlushes(SessionImplementor session) throws HibernateException {
        log.debug((Object)"dirty checking collections");
        List list = IdentityMap.entries(session.getPersistenceContext().getCollectionEntries());
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Map.Entry e = (Map.Entry)list.get(i);
            ((CollectionEntry)e.getValue()).preFlush((PersistentCollection)e.getKey());
        }
    }

    private void flushEntities(FlushEvent event) throws HibernateException {
        log.trace((Object)"Flushing entities and processing referenced collections");
        SessionImplementor source = event.getSession();
        Map.Entry[] list = IdentityMap.concurrentEntries(source.getPersistenceContext().getEntityEntries());
        int size = list.length;
        for (int i = 0; i < size; ++i) {
            Map.Entry me = list[i];
            EntityEntry entry = (EntityEntry)me.getValue();
            Status status = entry.getStatus();
            if (status == Status.LOADING || status == Status.GONE) continue;
            FlushEntityEvent entityEvent = new FlushEntityEvent(source, me.getKey(), entry);
            source.getListeners().getFlushEntityEventListener().onFlushEntity(entityEvent);
        }
        source.getActionQueue().sortUpdateActions();
    }

    private void flushCollections(SessionImplementor session) throws HibernateException {
        Map.Entry me;
        int i;
        log.trace((Object)"Processing unreferenced collections");
        List list = IdentityMap.entries(session.getPersistenceContext().getCollectionEntries());
        int size = list.size();
        for (i = 0; i < size; ++i) {
            me = (Map.Entry)list.get(i);
            CollectionEntry ce = (CollectionEntry)me.getValue();
            if (ce.isReached() || ce.isIgnore()) continue;
            Collections.updateUnreachableCollection((PersistentCollection)me.getKey(), session);
        }
        log.trace((Object)"Scheduling collection removes/(re)creates/updates");
        list = IdentityMap.entries(session.getPersistenceContext().getCollectionEntries());
        size = list.size();
        for (i = 0; i < size; ++i) {
            me = (Map.Entry)list.get(i);
            PersistentCollection coll = (PersistentCollection)me.getKey();
            CollectionEntry ce = (CollectionEntry)me.getValue();
            if (ce.isDorecreate()) {
                session.getActionQueue().addAction(new CollectionRecreateAction(coll, ce.getCurrentPersister(), ce.getCurrentKey(), session));
            }
            if (ce.isDoremove()) {
                session.getActionQueue().addAction(new CollectionRemoveAction(ce.getLoadedPersister(), ce.getLoadedKey(), ce.snapshotIsEmpty(), session));
            }
            if (!ce.isDoupdate()) continue;
            session.getActionQueue().addAction(new CollectionUpdateAction(coll, ce.getLoadedPersister(), ce.getLoadedKey(), ce.snapshotIsEmpty(), session));
        }
        session.getActionQueue().sortCollectionActions();
    }

    protected void performExecutions(SessionImplementor session) throws HibernateException {
        log.trace((Object)"executing flush");
        try {
            session.getActionQueue().prepareActions();
            session.getActionQueue().executeActions();
        }
        catch (HibernateException he) {
            log.error((Object)"Could not synchronize database state with session", (Throwable)he);
            throw he;
        }
    }

    protected void postFlush(SessionImplementor session) throws HibernateException {
        log.trace((Object)"post flush");
        PersistenceContext persistenceContext = session.getPersistenceContext();
        persistenceContext.getCollectionsByKey().clear();
        persistenceContext.getBatchFetchQueue().clearSubselect();
        Iterator iter = persistenceContext.getCollectionEntries().entrySet().iterator();
        while (iter.hasNext()) {
            PersistentCollection pc;
            Map.Entry me = iter.next();
            CollectionEntry ce = (CollectionEntry)me.getValue();
            if (ce.postFlush(pc = (PersistentCollection)me.getKey())) {
                iter.remove();
                continue;
            }
            if (!ce.isReached()) continue;
            persistenceContext.getCollectionsByKey().put(new CollectionKey(ce.getCurrentPersister(), ce.getCurrentKey(), session.getEntityMode()), pc);
        }
        session.getInterceptor().postFlush(persistenceContext.getEntitiesByKey().values().iterator());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

