/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.engine.JoinHelper;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.QueryJoinFragment;
import org.hibernate.type.AssociationType;
import org.hibernate.util.CollectionHelper;

public class JoinSequence {
    private final SessionFactoryImplementor factory;
    private final List joins = new ArrayList();
    private boolean useThetaStyle = false;
    private final StringBuffer conditions = new StringBuffer();
    private String rootAlias;
    private Joinable rootJoinable;
    private Selector selector;
    private JoinSequence next;
    private boolean isFromPart = false;

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("JoinSequence{");
        if (this.rootJoinable != null) {
            buf.append(this.rootJoinable).append('[').append(this.rootAlias).append(']');
        }
        for (int i = 0; i < this.joins.size(); ++i) {
            buf.append("->").append(this.joins.get(i));
        }
        return buf.append('}').toString();
    }

    public JoinSequence(SessionFactoryImplementor factory) {
        this.factory = factory;
    }

    public JoinSequence getFromPart() {
        JoinSequence fromPart = new JoinSequence(this.factory);
        fromPart.joins.addAll(this.joins);
        fromPart.useThetaStyle = this.useThetaStyle;
        fromPart.rootAlias = this.rootAlias;
        fromPart.rootJoinable = this.rootJoinable;
        fromPart.selector = this.selector;
        fromPart.next = this.next == null ? null : this.next.getFromPart();
        fromPart.isFromPart = true;
        return fromPart;
    }

    public JoinSequence copy() {
        JoinSequence copy = new JoinSequence(this.factory);
        copy.joins.addAll(this.joins);
        copy.useThetaStyle = this.useThetaStyle;
        copy.rootAlias = this.rootAlias;
        copy.rootJoinable = this.rootJoinable;
        copy.selector = this.selector;
        copy.next = this.next == null ? null : this.next.copy();
        copy.isFromPart = this.isFromPart;
        copy.conditions.append(this.conditions.toString());
        return copy;
    }

    public JoinSequence addJoin(AssociationType associationType, String alias, int joinType, String[] referencingKey) throws MappingException {
        this.joins.add(new Join(associationType, alias, joinType, referencingKey));
        return this;
    }

    public JoinFragment toJoinFragment() throws MappingException {
        return this.toJoinFragment(CollectionHelper.EMPTY_MAP, true);
    }

    public JoinFragment toJoinFragment(Map enabledFilters, boolean includeExtraJoins) throws MappingException {
        QueryJoinFragment joinFragment = new QueryJoinFragment(this.factory.getDialect(), this.useThetaStyle);
        if (this.rootJoinable != null) {
            joinFragment.addCrossJoin(this.rootJoinable.getTableName(), this.rootAlias);
            String filterCondition = this.rootJoinable.filterFragment(this.rootAlias, enabledFilters);
            joinFragment.setHasFilterCondition(joinFragment.addCondition(filterCondition));
            if (includeExtraJoins) {
                this.addExtraJoins(joinFragment, this.rootAlias, this.rootJoinable, true);
            }
        }
        for (int i = 0; i < this.joins.size(); ++i) {
            Join join = (Join)this.joins.get(i);
            joinFragment.addJoin(join.getJoinable().getTableName(), join.getAlias(), join.getLHSColumns(), JoinHelper.getRHSColumnNames(join.getAssociationType(), this.factory), join.joinType, join.getAssociationType().getOnCondition(join.getAlias(), this.factory, enabledFilters));
            if (!includeExtraJoins) continue;
            this.addExtraJoins(joinFragment, join.getAlias(), join.getJoinable(), join.joinType == 0);
        }
        if (this.next != null) {
            joinFragment.addFragment(this.next.toJoinFragment(enabledFilters, includeExtraJoins));
        }
        joinFragment.addCondition(this.conditions.toString());
        if (this.isFromPart) {
            joinFragment.clearWherePart();
        }
        return joinFragment;
    }

    private boolean isIncluded(String alias) {
        return this.selector != null && this.selector.includeSubclasses(alias);
    }

    private void addExtraJoins(JoinFragment joinFragment, String alias, Joinable joinable, boolean innerJoin) {
        boolean include = this.isIncluded(alias);
        joinFragment.addJoins(joinable.fromJoinFragment(alias, innerJoin, include), joinable.whereJoinFragment(alias, innerJoin, include));
    }

    public JoinSequence addCondition(String condition) {
        if (condition.trim().length() != 0) {
            if (!condition.startsWith(" and ")) {
                this.conditions.append(" and ");
            }
            this.conditions.append(condition);
        }
        return this;
    }

    public JoinSequence addCondition(String alias, String[] columns, String condition) {
        for (int i = 0; i < columns.length; ++i) {
            this.conditions.append(" and ").append(alias).append('.').append(columns[i]).append(condition);
        }
        return this;
    }

    public JoinSequence setRoot(Joinable joinable, String alias) {
        this.rootAlias = alias;
        this.rootJoinable = joinable;
        return this;
    }

    public JoinSequence setNext(JoinSequence next) {
        this.next = next;
        return this;
    }

    public JoinSequence setSelector(Selector s) {
        this.selector = s;
        return this;
    }

    public JoinSequence setUseThetaStyle(boolean useThetaStyle) {
        this.useThetaStyle = useThetaStyle;
        return this;
    }

    public boolean isThetaStyle() {
        return this.useThetaStyle;
    }

    public int getJoinCount() {
        return this.joins.size();
    }

    public static interface Selector {
        public boolean includeSubclasses(String var1);
    }

    final class Join {
        private final AssociationType associationType;
        private final Joinable joinable;
        private final int joinType;
        private final String alias;
        private final String[] lhsColumns;

        Join(AssociationType associationType, String alias, int joinType, String[] lhsColumns) throws MappingException {
            this.associationType = associationType;
            this.joinable = associationType.getAssociatedJoinable(JoinSequence.this.factory);
            this.alias = alias;
            this.joinType = joinType;
            this.lhsColumns = lhsColumns;
        }

        String getAlias() {
            return this.alias;
        }

        AssociationType getAssociationType() {
            return this.associationType;
        }

        Joinable getJoinable() {
            return this.joinable;
        }

        int getJoinType() {
            return this.joinType;
        }

        String[] getLHSColumns() {
            return this.lhsColumns;
        }

        public String toString() {
            return this.joinable.toString() + '[' + this.alias + ']';
        }
    }
}

