/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.LazyInitializationException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionSnapshot;
import org.hibernate.engine.ForeignKeys;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.TypedValue;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.Type;
import org.hibernate.util.EmptyIterator;

public abstract class AbstractPersistentCollection
implements Serializable,
PersistentCollection {
    private transient SessionImplementor session;
    private boolean initialized;
    private transient List additions;
    private CollectionSnapshot collectionSnapshot;
    private transient boolean directlyAccessible;
    private transient boolean initializing;

    public abstract boolean empty();

    protected final void read() {
        this.initialize(false);
    }

    private final boolean isConnectedToSession() {
        return this.session != null && this.session.isOpen();
    }

    protected final void write() {
        this.initialize(true);
        this.collectionSnapshot.setDirty();
    }

    private boolean isQueueAdditionEnabled() {
        return !this.initialized && this.isConnectedToSession() && this.session.getPersistenceContext().isInverseCollection(this);
    }

    protected final boolean queueAdd(Object element) {
        if (this.isQueueAdditionEnabled()) {
            if (this.additions == null) {
                this.additions = new ArrayList(10);
            }
            this.additions.add(element);
            this.collectionSnapshot.setDirty();
            return true;
        }
        return false;
    }

    protected final boolean queueAddAll(Collection coll) {
        if (this.isQueueAdditionEnabled()) {
            if (this.additions == null) {
                this.additions = new ArrayList(20);
            }
            this.additions.addAll(coll);
            return true;
        }
        return false;
    }

    public void delayedAddAll(Collection coll) {
        throw new AssertionFailure("Collection does not support delayed initialization");
    }

    public void postFlush() {
        if (this.additions != null) {
            this.additions = null;
        }
    }

    public AbstractPersistentCollection() {
    }

    protected AbstractPersistentCollection(SessionImplementor session) {
        this.session = session;
    }

    public Object getValue() {
        return this;
    }

    public void beginRead() {
        this.initializing = true;
    }

    public boolean endRead() {
        this.setInitialized();
        if (this.additions != null) {
            this.delayedAddAll(this.additions);
            this.additions = null;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void initialize(boolean writing) {
        if (this.initialized) return;
        if (this.initializing) {
            throw new LazyInitializationException("cannot access loading collection");
        }
        if (this.isConnectedToSession()) {
            if (this.session.isConnected()) {
                this.session.initializeCollection(this, writing);
                return;
            }
            String name = this.getCollectionSnapshot() != null ? "(" + this.getCollectionSnapshot().getRole() + ")" : "";
            throw new LazyInitializationException("failed to lazily initialize a collection " + name + " - session is disconnected");
        }
        String name = this.getCollectionSnapshot() != null ? "(" + this.getCollectionSnapshot().getRole() + ")" : "";
        throw new LazyInitializationException("failed to lazily initialize a collection " + name + " - no session or session was closed");
    }

    protected final void setInitialized() {
        this.initializing = false;
        this.initialized = true;
    }

    protected final void setDirectlyAccessible(boolean directlyAccessible) {
        this.directlyAccessible = directlyAccessible;
    }

    public boolean isDirectlyAccessible() {
        return this.directlyAccessible;
    }

    public final boolean unsetSession(SessionImplementor currentSession) {
        if (currentSession == this.session) {
            this.session = null;
            return true;
        }
        return false;
    }

    public final boolean setCurrentSession(SessionImplementor session) throws HibernateException {
        if (session == this.session) {
            return false;
        }
        if (this.isConnectedToSession()) {
            throw new HibernateException("Illegal attempt to associate a collection with two open sessions");
        }
        this.session = session;
        return true;
    }

    public boolean needsRecreate(CollectionPersister persister) {
        return false;
    }

    public final Serializable getSnapshot(CollectionPersister persister) throws HibernateException {
        return persister == null ? null : this.snapshot(persister);
    }

    protected abstract Serializable snapshot(CollectionPersister var1) throws HibernateException;

    public final void forceInitialization() throws HibernateException {
        if (!this.initialized) {
            if (this.initializing) {
                throw new AssertionFailure("force initialize loading collection");
            }
            if (this.session == null) {
                throw new HibernateException("collection is not associated with any session");
            }
            if (!this.session.isConnected()) {
                throw new HibernateException("disconnected session");
            }
            this.session.initializeCollection(this, false);
        }
    }

    protected final Serializable getSnapshot() {
        return this.session.getPersistenceContext().getSnapshot(this);
    }

    public final boolean wasInitialized() {
        return this.initialized;
    }

    public boolean isRowUpdatePossible() {
        return true;
    }

    public final boolean hasQueuedAdditions() {
        return this.additions != null;
    }

    public final Iterator queuedAdditionIterator() {
        return this.hasQueuedAdditions() ? this.additions.iterator() : EmptyIterator.INSTANCE;
    }

    public CollectionSnapshot getCollectionSnapshot() {
        return this.collectionSnapshot;
    }

    public void setCollectionSnapshot(CollectionSnapshot collectionSnapshot) {
        this.collectionSnapshot = collectionSnapshot;
    }

    public void preInsert(CollectionPersister persister) throws HibernateException {
    }

    public void afterRowInsert(CollectionPersister persister, Object entry, int i) throws HibernateException {
    }

    public abstract Collection getOrphans(Serializable var1, String var2) throws HibernateException;

    protected final SessionImplementor getSession() {
        return this.session;
    }

    protected static Collection getOrphans(Collection oldElements, Collection currentElements, String entityName, SessionImplementor session) throws HibernateException {
        if (currentElements.size() == 0) {
            return oldElements;
        }
        if (oldElements.size() == 0) {
            return oldElements;
        }
        Type idType = session.getFactory().getEntityPersister(entityName).getIdentifierType();
        ArrayList res = new ArrayList();
        HashSet<TypedValue> currentIds = new HashSet<TypedValue>();
        Iterator it = currentElements.iterator();
        while (it.hasNext()) {
            Object current = it.next();
            if (current == null || !ForeignKeys.isNotTransient(entityName, current, null, session)) continue;
            Serializable currentId = ForeignKeys.getEntityIdentifierIfNotUnsaved(entityName, current, session);
            currentIds.add(new TypedValue(idType, currentId, session.getEntityMode()));
        }
        it = oldElements.iterator();
        while (it.hasNext()) {
            Object old = it.next();
            Serializable oldId = ForeignKeys.getEntityIdentifierIfNotUnsaved(entityName, old, session);
            if (currentIds.contains(new TypedValue(idType, oldId, session.getEntityMode()))) continue;
            res.add(old);
        }
        return res;
    }

    static void identityRemove(Collection list, Object object, String entityName, SessionImplementor session) throws HibernateException {
        if (object != null && ForeignKeys.isNotTransient(entityName, object, null, session)) {
            Type idType = session.getFactory().getEntityPersister(entityName).getIdentifierType();
            Serializable idOfCurrent = ForeignKeys.getEntityIdentifierIfNotUnsaved(entityName, object, session);
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Serializable idOfOld = ForeignKeys.getEntityIdentifierIfNotUnsaved(entityName, iter.next(), session);
                if (!idType.isEqual(idOfCurrent, idOfOld, session.getEntityMode(), session.getFactory())) continue;
                iter.remove();
                break;
            }
        }
    }

    public Object getIdentifier(Object entry, int i) {
        throw new UnsupportedOperationException();
    }

    final class ListProxy
    implements List {
        private final List list;

        ListProxy(List list) {
            this.list = list;
        }

        public void add(int index, Object value) {
            AbstractPersistentCollection.this.write();
            this.list.add(index, value);
        }

        public boolean add(Object o) {
            AbstractPersistentCollection.this.write();
            return this.list.add(o);
        }

        public boolean addAll(Collection c) {
            AbstractPersistentCollection.this.write();
            return this.list.addAll(c);
        }

        public boolean addAll(int i, Collection c) {
            AbstractPersistentCollection.this.write();
            return this.list.addAll(i, c);
        }

        public void clear() {
            AbstractPersistentCollection.this.write();
            this.list.clear();
        }

        public boolean contains(Object o) {
            return this.list.contains(o);
        }

        public boolean containsAll(Collection c) {
            return this.list.containsAll(c);
        }

        public Object get(int i) {
            return this.list.get(i);
        }

        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public Iterator iterator() {
            return new IteratorProxy(this.list.iterator());
        }

        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        public ListIterator listIterator() {
            return new ListIteratorProxy(this.list.listIterator());
        }

        public ListIterator listIterator(int i) {
            return new ListIteratorProxy(this.list.listIterator(i));
        }

        public Object remove(int i) {
            AbstractPersistentCollection.this.write();
            return this.list.remove(i);
        }

        public boolean remove(Object o) {
            AbstractPersistentCollection.this.write();
            return this.list.remove(o);
        }

        public boolean removeAll(Collection c) {
            AbstractPersistentCollection.this.write();
            return this.list.removeAll(c);
        }

        public boolean retainAll(Collection c) {
            AbstractPersistentCollection.this.write();
            return this.list.retainAll(c);
        }

        public Object set(int i, Object o) {
            AbstractPersistentCollection.this.write();
            return this.list.set(i, o);
        }

        public int size() {
            return this.list.size();
        }

        public List subList(int i, int j) {
            return this.list.subList(i, j);
        }

        public Object[] toArray() {
            return this.list.toArray();
        }

        public Object[] toArray(Object[] array) {
            return this.list.toArray(array);
        }
    }

    class SetProxy
    implements Set {
        final Collection set;

        SetProxy(Collection set) {
            this.set = set;
        }

        public boolean add(Object o) {
            AbstractPersistentCollection.this.write();
            return this.set.add(o);
        }

        public boolean addAll(Collection c) {
            AbstractPersistentCollection.this.write();
            return this.set.addAll(c);
        }

        public void clear() {
            AbstractPersistentCollection.this.write();
            this.set.clear();
        }

        public boolean contains(Object o) {
            return this.set.contains(o);
        }

        public boolean containsAll(Collection c) {
            return this.set.containsAll(c);
        }

        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        public Iterator iterator() {
            return new IteratorProxy(this.set.iterator());
        }

        public boolean remove(Object o) {
            AbstractPersistentCollection.this.write();
            return this.set.remove(o);
        }

        public boolean removeAll(Collection c) {
            AbstractPersistentCollection.this.write();
            return this.set.removeAll(c);
        }

        public boolean retainAll(Collection c) {
            AbstractPersistentCollection.this.write();
            return this.set.retainAll(c);
        }

        public int size() {
            return this.set.size();
        }

        public Object[] toArray() {
            return this.set.toArray();
        }

        public Object[] toArray(Object[] array) {
            return this.set.toArray(array);
        }
    }

    final class ListIteratorProxy
    implements ListIterator {
        private final ListIterator iter;

        ListIteratorProxy(ListIterator iter) {
            this.iter = iter;
        }

        public void add(Object o) {
            AbstractPersistentCollection.this.write();
            this.iter.add(o);
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public boolean hasPrevious() {
            return this.iter.hasPrevious();
        }

        public Object next() {
            return this.iter.next();
        }

        public int nextIndex() {
            return this.iter.nextIndex();
        }

        public Object previous() {
            return this.iter.previous();
        }

        public int previousIndex() {
            return this.iter.previousIndex();
        }

        public void remove() {
            AbstractPersistentCollection.this.write();
            this.iter.remove();
        }

        public void set(Object o) {
            AbstractPersistentCollection.this.write();
            this.iter.set(o);
        }
    }

    final class IteratorProxy
    implements Iterator {
        private final Iterator iter;

        IteratorProxy(Iterator iter) {
            this.iter = iter;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            return this.iter.next();
        }

        public void remove() {
            AbstractPersistentCollection.this.write();
            this.iter.remove();
        }
    }
}

