/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.general.GeneralCacheAdministrator;
import java.util.Map;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.Timestamper;

public class OSCache
implements Cache {
    private GeneralCacheAdministrator cache = new GeneralCacheAdministrator();
    private final int refreshPeriod;
    private final String cron;
    private final String regionName;

    private String toString(Object key) {
        return String.valueOf(key) + '.' + this.regionName;
    }

    public OSCache(int refreshPeriod, String cron, String region) {
        this.refreshPeriod = refreshPeriod;
        this.cron = cron;
        this.regionName = region;
    }

    public void setCacheCapacity(int cacheCapacity) {
        this.cache.setCacheCapacity(cacheCapacity);
    }

    public Object get(Object key) throws CacheException {
        try {
            return this.cache.getFromCache(this.toString(key), this.refreshPeriod, this.cron);
        }
        catch (NeedsRefreshException e) {
            this.cache.cancelUpdate(this.toString(key));
            return null;
        }
    }

    public void update(Object key, Object value) throws CacheException {
        this.put(key, value);
    }

    public void put(Object key, Object value) throws CacheException {
        this.cache.putInCache(this.toString(key), value);
    }

    public void remove(Object key) throws CacheException {
        this.cache.flushEntry(this.toString(key));
    }

    public void clear() throws CacheException {
        this.cache.flushAll();
    }

    public void destroy() throws CacheException {
        this.cache.destroy();
    }

    public void lock(Object key) throws CacheException {
    }

    public void unlock(Object key) throws CacheException {
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public int getTimeout() {
        return 245760000;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public long getSizeInMemory() {
        return -1L;
    }

    public long getElementCountInMemory() {
        return -1L;
    }

    public long getElementCountOnDisk() {
        return -1L;
    }

    public Map toMap() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "OSCache(" + this.regionName + ')';
    }
}

