/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.Timestamper;

public class HashtableCache
implements Cache {
    private final Map hashtable = new Hashtable();
    private final String regionName;

    public HashtableCache(String regionName) {
        this.regionName = regionName;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public Object get(Object key) throws CacheException {
        return this.hashtable.get(key);
    }

    public void update(Object key, Object value) throws CacheException {
        this.put(key, value);
    }

    public void put(Object key, Object value) throws CacheException {
        this.hashtable.put(key, value);
    }

    public void remove(Object key) throws CacheException {
        this.hashtable.remove(key);
    }

    public void clear() throws CacheException {
        this.hashtable.clear();
    }

    public void destroy() throws CacheException {
    }

    public void lock(Object key) throws CacheException {
    }

    public void unlock(Object key) throws CacheException {
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public int getTimeout() {
        return 245760000;
    }

    public long getSizeInMemory() {
        return -1L;
    }

    public long getElementCountInMemory() {
        return this.hashtable.size();
    }

    public long getElementCountOnDisk() {
        return 0L;
    }

    public Map toMap() {
        return Collections.unmodifiableMap(this.hashtable);
    }

    public String toString() {
        return "HashtableCache(" + this.regionName + ')';
    }
}

